/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.filetools.journal.j14;

import com.spacekiller.filetools.journal.FileJournalEntry;
import com.spacekiller.filetools.journal.FileJournalFilter;
import com.spacekiller.filetools.journal.FileJournalReplacer;
import com.spacekiller.filetools.journal.impl.AbstractFileJournalScanner;
import com.spacekiller.filetools.journal.impl.FileJournalUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.HashSet;
import java.util.Set;

public class FileJournalScannerJ14
extends AbstractFileJournalScanner {
    private String basePath;
    private FileJournalEntry tempEntry;

    @Override
    public String getBasePath() {
        return this.basePath;
    }

    @Override
    public void setBasePath(String basePath) {
        this.basePath = basePath;
    }

    @Override
    public synchronized void scan() throws Exception {
        File baseDir = new File(this.basePath);
        this.scan(baseDir);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void scan(File base) throws Exception {
        if (this.verbose) {
            this.verbose("Scanning files: " + base);
        }
        HashSet done = new HashSet();
        try {
            this.scan(base, done);
        }
        finally {
            this.flushNewEntries();
        }
        if (this.verbose) {
            long existingCount = done.size();
            this.verbose("Number of files scanned: " + existingCount);
        }
        if (!this.ignoreMissing) {
            try {
                if (this.verbose) {
                    this.verbose("Checking for missing files...");
                }
                long missingCount = this.checkMissingFiles(done);
                if (this.verbose) {
                    this.verbose("Number of missing files: " + missingCount);
                }
            }
            finally {
                this.flushNewEntries();
            }
        }
    }

    protected void scan(File file, Set done) throws Exception {
        block36: {
            int reason;
            byte type;
            String canonicalPath;
            String path = file.getPath();
            FileJournalFilter scan = this.scanFilter;
            if (scan != null && !scan.accept(path)) {
                if (this.debug) {
                    this.debug("Skipped: " + path);
                }
                return;
            }
            try {
                canonicalPath = file.getCanonicalPath();
            }
            catch (Exception e) {
                this.error(e);
                if (!this.ignoreErrors) {
                    throw e;
                }
                return;
            }
            if (!done.add(canonicalPath)) {
                if (this.debug) {
                    this.debug("Duplicate: " + canonicalPath);
                }
                return;
            }
            boolean symlink = !path.equals(canonicalPath);
            FileJournalReplacer fjr = this.replacer;
            if (fjr != null) {
                path = fjr.replace(path);
            }
            FileJournalEntry entry = this.latestEntryMap.get(path);
            long timestamp = this.timestamp();
            boolean directoryRecursive = file.isDirectory();
            boolean exclude = false;
            FileJournalFilter include = this.includeFilter;
            if (include != null && !include.accept(path)) {
                if (this.debug) {
                    this.debug("Excluded: " + path);
                }
                if (!directoryRecursive) {
                    return;
                }
                exclude = true;
            }
            long lastModified = file.lastModified();
            if (this.tempEntry == null) {
                this.tempEntry = new FileJournalEntry();
            }
            this.tempEntry.setExisting(true);
            this.tempEntry.setTimestamp(timestamp);
            this.tempEntry.setLastModified(lastModified);
            if (directoryRecursive) {
                type = 2;
                if (symlink) {
                    type = 3;
                }
                this.tempEntry.setType(type);
                this.tempEntry.setLength(-1L);
                this.tempEntry.setLinkTarget(null);
                this.tempEntry.setMd5Checksum(null);
                if (symlink && !this.followSymlinks) {
                    if (this.debug) {
                        this.debug("Ignored symlink: " + path + " -> " + canonicalPath);
                    }
                    directoryRecursive = false;
                }
            } else if (file.isFile()) {
                byte[] md5Checksum;
                block35: {
                    int reason2;
                    type = 1;
                    if (symlink) {
                        type = 3;
                    }
                    long fileLen = file.length();
                    this.tempEntry.setType(type);
                    this.tempEntry.setLength(fileLen);
                    this.tempEntry.setLinkTarget(null);
                    this.tempEntry.setMd5Checksum(null);
                    if (entry != null && !this.comparator.isChecksum() && (reason2 = this.comparator.compareEntry(this.tempEntry, entry)) == 0) {
                        return;
                    }
                    md5Checksum = null;
                    try {
                        if (fileLen > 0L && !symlink) {
                            if (this.verbose) {
                                this.verbose("Checking: " + file);
                            }
                            md5Checksum = this.computeMd5Checksum(file, fileLen);
                        } else if (this.verbose) {
                            this.verbose("Empty: " + file);
                        }
                    }
                    catch (FileNotFoundException e) {
                        this.error(e);
                        this.tempEntry.setExisting(false);
                    }
                    catch (Exception e) {
                        this.error(e);
                        if (this.ignoreErrors) break block35;
                        throw e;
                    }
                }
                this.tempEntry.setMd5Checksum(md5Checksum);
            } else {
                if (this.debug) {
                    this.debug("Ignored unknown: " + path);
                }
                return;
            }
            if (!exclude && (reason = this.comparator.compareEntry(this.tempEntry, entry)) != 0) {
                this.mergeEntry(this.tempEntry, entry);
                this.tempEntry.setPath(path);
                this.info(FileJournalUtil.formatEntry(this.tempEntry, entry));
                if (this.debug) {
                    this.debug("Reason: " + this.comparator.getReasonString(reason, this.tempEntry, entry));
                }
                this.appendEntry(this.tempEntry, entry);
                this.tempEntry = null;
            }
            if (directoryRecursive) {
                try {
                    File[] files = file.listFiles();
                    int num = files == null ? 0 : files.length;
                    for (int i = 0; i < num; ++i) {
                        File child = files[i];
                        if (child == null) continue;
                        this.scan(child, done);
                    }
                }
                catch (Exception e) {
                    this.error(e);
                    if (this.ignoreErrors) break block36;
                    throw e;
                }
            }
        }
    }
}

