/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.filetools.journal.j17;

import com.spacekiller.filetools.journal.FileJournalEntry;
import com.spacekiller.filetools.journal.FileJournalFilter;
import com.spacekiller.filetools.journal.FileJournalReplacer;
import com.spacekiller.filetools.journal.impl.AbstractFileJournalScanner;
import com.spacekiller.filetools.journal.impl.FileJournalUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileTime;
import java.util.HashSet;
import java.util.Set;

public class FileJournalScannerJ17
extends AbstractFileJournalScanner {
    private static final LinkOption[] NOFOLLOW_LINKS = new LinkOption[]{LinkOption.NOFOLLOW_LINKS};
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private String basePath;
    private FileJournalEntry tempEntry;

    @Override
    public String getBasePath() {
        return this.basePath;
    }

    @Override
    public void setBasePath(String basePath) {
        this.basePath = basePath;
    }

    @Override
    public synchronized void scan() throws Exception {
        Path base = FileSystems.getDefault().getPath(this.basePath, EMPTY_STRING_ARRAY);
        this.scan(base);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void scan(Path base) throws Exception {
        if (this.verbose) {
            this.verbose("Scanning files: " + base);
        }
        HashSet done = new HashSet();
        try {
            this.scan(base, done);
        }
        finally {
            this.flushNewEntries();
        }
        if (this.verbose) {
            long existingCount = done.size();
            this.verbose("Number of files scanned: " + existingCount);
        }
        if (!this.ignoreMissing) {
            try {
                if (this.verbose) {
                    this.verbose("Checking for missing files...");
                }
                long missingCount = this.checkMissingFiles(done);
                if (this.verbose) {
                    this.verbose("Number of missing files: " + missingCount);
                }
            }
            finally {
                this.flushNewEntries();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void scan(Path path, Set done) throws Exception {
        int reason;
        long lastAccessed;
        FileJournalReplacer fjr;
        String pathString = path.toString();
        FileJournalFilter scan = this.scanFilter;
        if (scan != null && !scan.accept(pathString)) {
            if (this.debug) {
                this.debug("Skipped: " + pathString);
            }
            return;
        }
        if (!done.add(pathString)) {
            if (this.debug) {
                this.debug("Duplicate: " + pathString);
            }
            return;
        }
        long timestamp = this.timestamp();
        BasicFileAttributes attr = Files.readAttributes(path, BasicFileAttributes.class, NOFOLLOW_LINKS);
        boolean exclude = false;
        FileJournalFilter include = this.includeFilter;
        if (include != null && !include.accept(pathString)) {
            if (this.debug) {
                this.debug("Excluded: " + pathString);
            }
            if (!attr.isDirectory()) {
                return;
            }
            exclude = true;
        }
        if ((fjr = this.replacer) != null) {
            pathString = fjr.replace(pathString);
        }
        FileJournalEntry entry = this.latestEntryMap.get(pathString);
        FileTime lastModifiedTime = attr.lastModifiedTime();
        FileTime creationTime = attr.creationTime();
        FileTime lastAccessTime = attr.lastAccessTime();
        long lastModified = lastModifiedTime == null ? Long.MIN_VALUE : lastModifiedTime.toMillis();
        long createdMillis = creationTime == null ? Long.MIN_VALUE : creationTime.toMillis();
        long l = lastAccessed = lastAccessTime == null ? Long.MIN_VALUE : lastAccessTime.toMillis();
        if (this.tempEntry == null) {
            this.tempEntry = new FileJournalEntry();
        }
        this.tempEntry.setExisting(true);
        this.tempEntry.setTimestamp(timestamp);
        this.tempEntry.setLastModified(lastModified);
        this.tempEntry.setLastAccessed(lastAccessed);
        this.tempEntry.setCreationTime(createdMillis);
        boolean directoryRecursive = false;
        if (attr.isOther()) {
            this.tempEntry.setType((byte)0);
            this.tempEntry.setLength(-1L);
            this.tempEntry.setLinkTarget(null);
            this.tempEntry.setMd5Checksum(null);
        } else if (attr.isSymbolicLink()) {
            Path target;
            block50: {
                target = null;
                try {
                    target = Files.readSymbolicLink(path);
                }
                catch (IOException e) {
                    this.error(e);
                    if (!this.ignoreErrors) {
                        throw e;
                    }
                }
                catch (Exception e) {
                    this.error(e);
                    if (this.ignoreErrors) break block50;
                    throw new RuntimeException(e);
                }
            }
            String linkTarget = target == null ? null : target.toString();
            this.tempEntry.setType((byte)3);
            this.tempEntry.setLength(-1L);
            this.tempEntry.setLinkTarget(linkTarget);
            this.tempEntry.setMd5Checksum(null);
        } else if (attr.isDirectory()) {
            this.tempEntry.setType((byte)2);
            this.tempEntry.setLength(-1L);
            this.tempEntry.setLinkTarget(null);
            this.tempEntry.setMd5Checksum(null);
            directoryRecursive = true;
        } else if (attr.isRegularFile()) {
            byte[] md5Checksum;
            block51: {
                int reason2;
                long fileLen = attr.size();
                this.tempEntry.setType((byte)1);
                this.tempEntry.setLength(fileLen);
                this.tempEntry.setLinkTarget(null);
                this.tempEntry.setMd5Checksum(null);
                if (entry != null && !this.comparator.isChecksum() && (reason2 = this.comparator.compareEntry(this.tempEntry, entry)) == 0) {
                    return;
                }
                md5Checksum = null;
                try {
                    if (fileLen > 0L) {
                        File file = path.toFile();
                        if (this.verbose) {
                            this.verbose("Checking: " + path);
                        }
                        md5Checksum = this.computeMd5Checksum(file, fileLen);
                    } else if (this.verbose) {
                        this.verbose("Empty: " + path);
                    }
                }
                catch (FileNotFoundException e) {
                    this.error(e);
                    this.tempEntry.setExisting(false);
                }
                catch (Exception e) {
                    this.error(e);
                    if (this.ignoreErrors) break block51;
                    throw e;
                }
            }
            this.tempEntry.setMd5Checksum(md5Checksum);
        } else {
            if (this.verbose) {
                this.verbose("Ignored unknown: " + path);
            }
            return;
        }
        if (!exclude && (reason = this.comparator.compareEntry(this.tempEntry, entry)) != 0) {
            this.mergeEntry(this.tempEntry, entry);
            this.tempEntry.setPath(pathString);
            this.info(FileJournalUtil.formatEntry(this.tempEntry, entry));
            if (this.debug) {
                this.debug("Reason: " + this.comparator.getReasonString(reason, this.tempEntry, entry));
            }
            this.appendEntry(this.tempEntry, entry);
            this.tempEntry = null;
        }
        if (directoryRecursive) {
            DirectoryStream<Path> directoryStream;
            try {
                directoryStream = Files.newDirectoryStream(path);
            }
            catch (Exception e) {
                this.error(e);
                if (!this.ignoreErrors) {
                    throw e;
                }
                return;
            }
            try {
                for (Path child : directoryStream) {
                    if (child == null) continue;
                    this.scan(child, done);
                }
            }
            catch (Exception e) {
                this.error(e);
                if (!this.ignoreErrors) {
                    throw e;
                }
            }
            finally {
                block53: {
                    if (directoryStream != null) {
                        try {
                            directoryStream.close();
                        }
                        catch (Exception e) {
                            this.error(e);
                            if (this.ignoreErrors) break block53;
                            throw e;
                        }
                    }
                }
            }
        }
    }
}

