/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.filetools.main;

import com.spacekiller.filetools.journal.FileJournalAction;
import com.spacekiller.filetools.journal.FileJournalFilter;
import com.spacekiller.filetools.journal.FileJournalReplacer;
import com.spacekiller.filetools.journal.impl.AbstractFileJournalAction;
import com.spacekiller.filetools.journal.impl.BaseFileJournalAction;
import com.spacekiller.filetools.journal.impl.CompareFileJournalAction;
import com.spacekiller.filetools.journal.impl.DumpFileJournalAction;
import com.spacekiller.filetools.journal.impl.DuplicatesFileJournalAction;
import com.spacekiller.filetools.journal.impl.ExportFileJournalAction;
import com.spacekiller.filetools.journal.impl.HelpFileJournalAction;
import com.spacekiller.filetools.journal.impl.ListFileJournalAction;
import com.spacekiller.filetools.journal.impl.MultiFileJournalFilter;
import com.spacekiller.filetools.journal.impl.MultiFileJournalReplacer;
import com.spacekiller.filetools.journal.impl.NoneFileJournalAction;
import com.spacekiller.filetools.journal.impl.ReconstructFileJournalAction;
import com.spacekiller.filetools.journal.impl.RegexFileJournalFilter;
import com.spacekiller.filetools.journal.impl.RegexFileJournalReplacer;
import com.spacekiller.filetools.journal.impl.ScanFileJournalAction;
import com.spacekiller.filetools.journal.impl.SizeFileJournalAction;
import com.spacekiller.filetools.journal.impl.TestFileJournalAction;
import com.spacekiller.filetools.journal.impl.VersionFileJournalAction;
import com.spacekiller.filetools.main.ConsoleHandler;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;

public class FileJournalizer
implements Runnable {
    private static final String CONSOLE_LOGGER_NAME = "FileJournalizerConsoleLogger";
    public static final String ACTION_NONE = "none";
    public static final String ACTION_HELP = "help";
    public static final String ACTION_SCAN = "scan";
    public static final String ACTION_LIST = "list";
    public static final String ACTION_DUMP = "dump";
    public static final String ACTION_SIZE = "size";
    public static final String ACTION_TEST = "test";
    public static final String ACTION_EXPORT = "export";
    public static final String ACTION_COMPARE = "compare";
    public static final String ACTION_DUPLICATES = "duplicates";
    public static final String ACTION_RECONSTRUCT = "reconstruct";
    public static final String OPTION_HELP = "--help";
    public static final String OPTION_VERSION = "--version";
    public static final String OPTION_VERBOSE = "--verbose";
    public static final String OPTION_DEBUG = "--debug";
    public static final String OPTION_JAVA14 = "--java14";
    public static final String OPTION_JAVA17 = "--java17";
    public static final String OPTION_JOURNAL = "--journal";
    public static final String OPTION_SEQUENTIAL = "--sequential";
    public static final String OPTION_IGNORE_CASE = "--ignore-case";
    public static final String OPTION_UNICODE_CASE = "--unicode-case";
    public static final String OPTION_MATCH_CASE = "--match-case";
    public static final String OPTION_INCLUDE = "--include";
    public static final String OPTION_EXCLUDE = "--exclude";
    public static final String OPTION_REPLACE = "--replace";
    public static final String OPTION_ARGUMENTS = "--arguments";
    public static final String OPTION_DRY_RUN = "--dry-run";
    public static final String OPTION_SKIP = "--skip";
    public static final String OPTION_SIZE_ONLY = "--size-only";
    public static final String OPTION_SUM_ONLY = "--sum-only";
    public static final String OPTION_CHECKSUM = "--checksum";
    public static final String OPTION_FOLLOW_SYMLINKS = "--follow-symlinks";
    public static final String OPTION_IGNORE_MISSING = "--ignore-missing";
    public static final String OPTION_IGNORE_ERRORS = "--ignore-errors";
    public static final String OPTION_UNCOMPRESSED = "--uncompressed";
    public static final String OPTION_SUMMARY = "--summary";
    public static final String OPTION_INCLUDE_MISSING = "--include-missing";
    public static final String OPTION_MISSING_ONLY = "--missing-only";
    public static final String OPTION_IGNORE_FILES = "--ignore-files";
    public static final String OPTION_IGNORE_DIRS = "--ignore-dirs";
    public static final String OPTION_IGNORE_LINKS = "--ignore-links";
    public static final String OPTION_PATH_ONLY = "--path-only";
    public static final String OPTION_ASCENDING = "--ascending";
    public static final String OPTION_DESCENDING = "--descending";
    public static final String OPTION_REMOVE = "--remove";
    public static final String OPTION_WINDOWS = "--windows";
    public static final String OPTION_UNIX = "--unix";
    public static final String OPTION_TIMESTAMP = "--timestamp";
    public static final String OPTION_SINCE = "--since";
    public static final String OPTION_UNTIL = "--until";
    public static final String OPTION_DELTA = "--delta";
    public static final String DEFAULT_DATE_FORMAT = "yyyyMMddHHmmss";
    private final String[] args;
    private final Logger logger;

    public FileJournalizer(String[] args, Logger logger) {
        this.args = args;
        this.logger = logger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        int rc;
        boolean success = false;
        try {
            Logger logger = Logger.getLogger(CONSOLE_LOGGER_NAME);
            logger.setUseParentHandlers(false);
            logger.setLevel(Level.ALL);
            ConsoleHandler handler = new ConsoleHandler();
            logger.addHandler(handler);
            FileJournalizer journalizer = new FileJournalizer(args, logger);
            success = journalizer.execute();
            rc = success ? 0 : 1;
        }
        catch (Throwable e) {
            int rc2;
            try {
                success = false;
                e.printStackTrace(System.err);
                rc2 = success ? 0 : 1;
            }
            catch (Throwable throwable) {
                int rc3 = success ? 0 : 1;
                System.exit(rc3);
                throw throwable;
            }
            System.exit(rc2);
        }
        System.exit(rc);
    }

    @Override
    public void run() {
        try {
            this.execute();
        }
        catch (Throwable e) {
            this.logger.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    public boolean execute() throws Exception {
        String[] arr = this.parseArguments(this.args);
        FileJournalAction action = this.createFileJournalAction(arr);
        if (action == null) {
            this.logger.severe("Invalid arguments! Use --help for syntax help.");
            return false;
        }
        boolean success = action.execute();
        if (success) {
            return true;
        }
        this.logger.severe("Failed: " + action);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String[] parseArguments(String[] args) throws Exception {
        boolean doneDebugArgs = false;
        LinkedList<String> list = new LinkedList<String>();
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if (arg == null) continue;
            if (OPTION_DEBUG.equals(arg)) {
                if (!doneDebugArgs) {
                    doneDebugArgs = true;
                    this.debug("Main Arguments: " + args.length);
                    for (int k = 0; k < args.length; ++k) {
                        this.debug(" - Argument #" + k + ": " + args[k]);
                    }
                }
                list.add(arg);
                continue;
            }
            if (OPTION_ARGUMENTS.equals(arg)) {
                if (i + 1 >= args.length) continue;
                String argPath = args[++i];
                File argFile = new File(argPath);
                BufferedReader reader = new BufferedReader(new FileReader(argFile));
                try {
                    this.readArguments(reader, list);
                    continue;
                }
                finally {
                    reader.close();
                }
            }
            list.add(arg);
        }
        return list.toArray(new String[list.size()]);
    }

    protected void readArguments(BufferedReader reader, List dstList) throws IOException {
        String s;
        while ((s = reader.readLine()) != null) {
            if ((s = s.trim()).length() < 1) continue;
            dstList.add(s);
        }
    }

    protected FileJournalAction createFileJournalAction(String[] args) throws Exception {
        String arg;
        int i;
        boolean valid = true;
        String action = null;
        boolean none = false;
        boolean verbose = false;
        boolean debug = false;
        boolean dryRun = false;
        boolean summary = false;
        boolean sizeOnly = false;
        boolean sumOnly = false;
        boolean checksum = false;
        boolean followSymlinks = false;
        boolean ignoreMissing = false;
        boolean ignoreErrors = false;
        boolean uncompressed = false;
        boolean sequential = false;
        boolean includeMissing = false;
        boolean missingOnly = false;
        boolean ignoreFiles = false;
        boolean ignoreDirs = false;
        boolean ignoreLinks = false;
        boolean pathOnly = false;
        boolean ascending = false;
        boolean descending = false;
        boolean unix = true;
        boolean windows = false;
        String since = null;
        String until = null;
        String dateFormat = null;
        boolean timestamp = false;
        LinkedList<String> otherJournalPaths = new LinkedList<String>();
        boolean ignoreCase = false;
        boolean unicodeCase = false;
        LinkedList<RegexFileJournalFilter> skipFilters = new LinkedList<RegexFileJournalFilter>();
        LinkedList<RegexFileJournalFilter> includeFilters = new LinkedList<RegexFileJournalFilter>();
        LinkedList<RegexFileJournalFilter> excludeFilters = new LinkedList<RegexFileJournalFilter>();
        LinkedList<RegexFileJournalReplacer> pathReplacers = new LinkedList<RegexFileJournalReplacer>();
        LinkedList<RegexFileJournalFilter> removeFilters = new LinkedList<RegexFileJournalFilter>();
        String scanPath = null;
        String journalPath = null;
        String exportPath = null;
        String comparePath = null;
        String deltaPath = null;
        boolean java14 = false;
        boolean java17 = false;
        for (i = 0; i < args.length; ++i) {
            String regex;
            RegexFileJournalFilter filter;
            arg = args[i];
            if (arg == null) continue;
            if (OPTION_HELP.equals(arg)) {
                new HelpFileJournalAction().execute();
                none = true;
                continue;
            }
            if (OPTION_VERSION.equals(arg)) {
                new VersionFileJournalAction().execute();
                none = true;
                continue;
            }
            if (OPTION_VERBOSE.equals(arg)) {
                verbose = true;
                summary = true;
                continue;
            }
            if (OPTION_DEBUG.equals(arg)) {
                debug = true;
                verbose = true;
                summary = true;
                continue;
            }
            if (OPTION_JAVA14.equals(arg)) {
                java14 = true;
                continue;
            }
            if (OPTION_JAVA17.equals(arg)) {
                java17 = true;
                continue;
            }
            if (OPTION_DRY_RUN.equals(arg)) {
                dryRun = true;
                continue;
            }
            if (OPTION_SUMMARY.equals(arg)) {
                summary = true;
                continue;
            }
            if (OPTION_SIZE_ONLY.equals(arg)) {
                sizeOnly = true;
                continue;
            }
            if (OPTION_SUM_ONLY.equals(arg)) {
                sumOnly = true;
                continue;
            }
            if (OPTION_CHECKSUM.equals(arg)) {
                checksum = true;
                continue;
            }
            if (OPTION_FOLLOW_SYMLINKS.equals(arg)) {
                followSymlinks = true;
                continue;
            }
            if (OPTION_IGNORE_MISSING.equals(arg)) {
                ignoreMissing = true;
                continue;
            }
            if (OPTION_IGNORE_ERRORS.equals(arg)) {
                ignoreErrors = true;
                continue;
            }
            if (OPTION_UNCOMPRESSED.equals(arg)) {
                uncompressed = true;
                continue;
            }
            if (OPTION_TIMESTAMP.equals(arg)) {
                timestamp = true;
                continue;
            }
            if (OPTION_SINCE.equals(arg)) {
                if (i + 1 < args.length) {
                    since = args[++i];
                    continue;
                }
                valid = false;
                continue;
            }
            if (OPTION_UNTIL.equals(arg)) {
                if (i + 1 < args.length) {
                    until = args[++i];
                    continue;
                }
                valid = false;
                continue;
            }
            if (OPTION_IGNORE_CASE.equals(arg)) {
                ignoreCase = true;
                unicodeCase = false;
                continue;
            }
            if (OPTION_UNICODE_CASE.equals(arg)) {
                ignoreCase = true;
                unicodeCase = true;
                continue;
            }
            if (OPTION_MATCH_CASE.equals(arg)) {
                ignoreCase = false;
                unicodeCase = false;
                continue;
            }
            if (OPTION_SKIP.equals(arg)) {
                if (i + 1 < args.length) {
                    if ((filter = this.createRegexFileJournalFilter(regex = args[++i], ignoreCase, unicodeCase)) != null) {
                        skipFilters.add(filter);
                        continue;
                    }
                    valid = false;
                    continue;
                }
                valid = false;
                continue;
            }
            if (OPTION_INCLUDE.equals(arg)) {
                if (i + 1 < args.length) {
                    if ((filter = this.createRegexFileJournalFilter(regex = args[++i], ignoreCase, unicodeCase)) != null) {
                        includeFilters.add(filter);
                        continue;
                    }
                    valid = false;
                    continue;
                }
                valid = false;
                continue;
            }
            if (OPTION_EXCLUDE.equals(arg)) {
                if (i + 1 < args.length) {
                    if ((filter = this.createRegexFileJournalFilter(regex = args[++i], ignoreCase, unicodeCase)) != null) {
                        excludeFilters.add(filter);
                        continue;
                    }
                    valid = false;
                    continue;
                }
                valid = false;
                continue;
            }
            if (OPTION_REPLACE.equals(arg)) {
                if (i + 2 < args.length) {
                    regex = args[i + 1];
                    String replace = args[i + 2];
                    i += 2;
                    RegexFileJournalReplacer replacer = this.createRegexFileJournalReplacer(regex, ignoreCase, unicodeCase, replace);
                    if (replacer != null) {
                        pathReplacers.add(replacer);
                        continue;
                    }
                    valid = false;
                    continue;
                }
                valid = false;
                continue;
            }
            if (OPTION_REMOVE.equals(arg)) {
                if (i + 1 < args.length) {
                    if ((filter = this.createRegexFileJournalFilter(regex = args[++i], ignoreCase, unicodeCase)) != null) {
                        removeFilters.add(filter);
                        continue;
                    }
                    valid = false;
                    continue;
                }
                valid = false;
                continue;
            }
            if (OPTION_JOURNAL.equals(arg)) {
                if (i + 1 < args.length) {
                    String otherJournalPath = args[++i];
                    otherJournalPaths.add(otherJournalPath);
                    continue;
                }
                valid = false;
                continue;
            }
            if (OPTION_DELTA.equals(arg)) {
                if (i + 1 < args.length) {
                    ++i;
                    if (deltaPath == null) {
                        deltaPath = args[i];
                        continue;
                    }
                    valid = false;
                    continue;
                }
                valid = false;
                continue;
            }
            if (OPTION_SEQUENTIAL.equals(arg)) {
                sequential = true;
                continue;
            }
            if (OPTION_INCLUDE_MISSING.equals(arg)) {
                includeMissing = true;
                continue;
            }
            if (OPTION_MISSING_ONLY.equals(arg)) {
                missingOnly = true;
                includeMissing = true;
                continue;
            }
            if (OPTION_IGNORE_FILES.equals(arg)) {
                ignoreFiles = true;
                continue;
            }
            if (OPTION_IGNORE_DIRS.equals(arg)) {
                ignoreDirs = true;
                continue;
            }
            if (OPTION_IGNORE_LINKS.equals(arg)) {
                ignoreLinks = true;
                continue;
            }
            if (OPTION_PATH_ONLY.equals(arg)) {
                pathOnly = true;
                continue;
            }
            if (OPTION_ASCENDING.equals(arg)) {
                ascending = true;
                descending = false;
                continue;
            }
            if (OPTION_DESCENDING.equals(arg)) {
                descending = true;
                ascending = false;
                continue;
            }
            if (OPTION_WINDOWS.equals(arg)) {
                windows = true;
                unix = false;
                continue;
            }
            if (OPTION_UNIX.equals(arg)) {
                unix = true;
                windows = false;
                continue;
            }
            if (action == null) {
                if (ACTION_HELP.equals(arg)) {
                    action = ACTION_HELP;
                    continue;
                }
                if (ACTION_SCAN.equals(arg)) {
                    action = ACTION_SCAN;
                    continue;
                }
                if (ACTION_LIST.equals(arg)) {
                    action = ACTION_LIST;
                    continue;
                }
                if (ACTION_DUMP.equals(arg)) {
                    action = ACTION_DUMP;
                    continue;
                }
                if (ACTION_SIZE.equals(arg)) {
                    action = ACTION_SIZE;
                    continue;
                }
                if (ACTION_TEST.equals(arg)) {
                    action = ACTION_TEST;
                    continue;
                }
                if (ACTION_EXPORT.equals(arg)) {
                    action = ACTION_EXPORT;
                    continue;
                }
                if (ACTION_COMPARE.equals(arg)) {
                    action = ACTION_COMPARE;
                    continue;
                }
                if (ACTION_DUPLICATES.equals(arg)) {
                    action = ACTION_DUPLICATES;
                    continue;
                }
                if (ACTION_RECONSTRUCT.equals(arg)) {
                    action = ACTION_RECONSTRUCT;
                    continue;
                }
                valid = false;
                this.logger.severe("Invalid argument #" + i + ": " + arg);
                break;
            }
            if (ACTION_HELP.equals(action)) continue;
            if (ACTION_SCAN.equals(action)) {
                if (scanPath == null) {
                    scanPath = arg;
                    continue;
                }
                if (journalPath == null) {
                    journalPath = arg;
                    continue;
                }
            }
            if (ACTION_LIST.equals(action) && journalPath == null) {
                journalPath = arg;
                continue;
            }
            if (ACTION_DUMP.equals(action) && journalPath == null) {
                journalPath = arg;
                continue;
            }
            if (ACTION_SIZE.equals(action) && journalPath == null) {
                journalPath = arg;
                continue;
            }
            if (ACTION_TEST.equals(action) && journalPath == null) {
                journalPath = arg;
                continue;
            }
            if (ACTION_EXPORT.equals(action)) {
                if (journalPath == null) {
                    journalPath = arg;
                    continue;
                }
                if (exportPath == null) {
                    exportPath = arg;
                    continue;
                }
            }
            if (ACTION_COMPARE.equals(action)) {
                if (journalPath == null) {
                    journalPath = arg;
                    continue;
                }
                if (comparePath == null) {
                    comparePath = arg;
                    continue;
                }
            }
            if (ACTION_DUPLICATES.equals(action) && journalPath == null) {
                journalPath = arg;
                continue;
            }
            if (ACTION_RECONSTRUCT.equals(action) && journalPath == null) {
                journalPath = arg;
                continue;
            }
            valid = false;
            this.logger.severe("Invalid argument #" + i + ": " + arg);
        }
        if (debug) {
            this.debug("Arguments: " + args.length);
            for (i = 0; i < args.length; ++i) {
                arg = args[i];
                this.debug(" - Argument #" + i + ": " + arg);
            }
        }
        if (none && action == null) {
            action = ACTION_NONE;
        }
        if (action == null) {
            valid = false;
            this.logger.severe("Missing argument: [action]");
        }
        if (dateFormat == null) {
            dateFormat = DEFAULT_DATE_FORMAT;
        }
        SimpleDateFormat timestampFormat = new SimpleDateFormat(dateFormat);
        Date sinceDate = null;
        if (since != null) {
            sinceDate = timestampFormat.parse(since);
        }
        Date untilDate = null;
        if (until != null) {
            untilDate = timestampFormat.parse(until);
        }
        MultiFileJournalFilter scanFilter = null;
        if (!skipFilters.isEmpty()) {
            FileJournalFilter[] skipArray = skipFilters.toArray(new FileJournalFilter[skipFilters.size()]);
            scanFilter = new MultiFileJournalFilter(null, skipArray);
        }
        MultiFileJournalFilter includeFilter = null;
        if (!includeFilters.isEmpty() || !excludeFilters.isEmpty()) {
            FileJournalFilter[] includeArray = includeFilters.toArray(new FileJournalFilter[includeFilters.size()]);
            FileJournalFilter[] excludeArray = excludeFilters.toArray(new FileJournalFilter[excludeFilters.size()]);
            includeFilter = new MultiFileJournalFilter(includeArray, excludeArray);
        }
        MultiFileJournalReplacer replacer = null;
        if (!pathReplacers.isEmpty()) {
            FileJournalReplacer[] replaceArray = pathReplacers.toArray(new FileJournalReplacer[pathReplacers.size()]);
            replacer = new MultiFileJournalReplacer(replaceArray);
        }
        MultiFileJournalFilter removeFilter = null;
        if (!removeFilters.isEmpty()) {
            FileJournalFilter[] includeArray = removeFilters.toArray(new FileJournalFilter[removeFilters.size()]);
            FileJournalFilter[] excludeArray = new FileJournalFilter[]{};
            removeFilter = new MultiFileJournalFilter(includeArray, excludeArray);
        }
        AbstractFileJournalAction act = null;
        if (ACTION_NONE.equals(action)) {
            act = new NoneFileJournalAction();
        }
        if (ACTION_HELP.equals(action)) {
            act = new HelpFileJournalAction();
        }
        if (valid) {
            AbstractFileJournalAction a;
            if (ACTION_SCAN.equals(action)) {
                a = new ScanFileJournalAction();
                ((ScanFileJournalAction)a).setBasePath(scanPath);
                ((ScanFileJournalAction)a).setDryRun(dryRun);
                ((ScanFileJournalAction)a).setScanFilter(scanFilter);
                ((ScanFileJournalAction)a).setSizeOnly(sizeOnly);
                ((ScanFileJournalAction)a).setSumOnly(sumOnly);
                ((ScanFileJournalAction)a).setChecksum(checksum);
                ((ScanFileJournalAction)a).setFollowSymlinks(followSymlinks);
                ((ScanFileJournalAction)a).setIgnoreMissing(ignoreMissing);
                ((ScanFileJournalAction)a).setIgnoreErrors(ignoreErrors);
                ((ScanFileJournalAction)a).setJava14(java14);
                ((ScanFileJournalAction)a).setJava17(java17);
                ((ScanFileJournalAction)a).setUncompressed(uncompressed);
                ((ScanFileJournalAction)a).setSummary(summary);
                act = a;
            }
            if (ACTION_LIST.equals(action)) {
                a = new ListFileJournalAction();
                ((ListFileJournalAction)a).setIncludeMissing(includeMissing);
                ((ListFileJournalAction)a).setMissingOnly(missingOnly);
                ((ListFileJournalAction)a).setIgnoreFiles(ignoreFiles);
                ((ListFileJournalAction)a).setIgnoreDirs(ignoreDirs);
                ((ListFileJournalAction)a).setIgnoreLinks(ignoreLinks);
                ((ListFileJournalAction)a).setPathOnly(pathOnly);
                ((ListFileJournalAction)a).setAscending(ascending);
                ((ListFileJournalAction)a).setDescending(descending);
                act = a;
            }
            if (ACTION_DUMP.equals(action)) {
                a = new DumpFileJournalAction();
                ((DumpFileJournalAction)a).setChecksum(checksum);
                ((DumpFileJournalAction)a).setTimestamp(timestamp);
                ((DumpFileJournalAction)a).setTimestampFormat(timestampFormat);
                act = a;
            }
            if (ACTION_SIZE.equals(action)) {
                a = new SizeFileJournalAction();
                act = a;
            }
            if (ACTION_TEST.equals(action)) {
                a = new TestFileJournalAction();
                act = a;
            }
            if (ACTION_EXPORT.equals(action)) {
                a = new ExportFileJournalAction();
                ((ExportFileJournalAction)a).setExportPath(exportPath);
                ((ExportFileJournalAction)a).setUncompressed(uncompressed);
                act = a;
            }
            if (ACTION_COMPARE.equals(action)) {
                a = new CompareFileJournalAction();
                ((CompareFileJournalAction)a).setComparePath(comparePath);
                ((CompareFileJournalAction)a).setDryRun(dryRun);
                ((CompareFileJournalAction)a).setSizeOnly(sizeOnly);
                ((CompareFileJournalAction)a).setSumOnly(sumOnly);
                ((CompareFileJournalAction)a).setChecksum(checksum);
                ((CompareFileJournalAction)a).setIgnoreMissing(ignoreMissing);
                ((CompareFileJournalAction)a).setDeltaPath(deltaPath);
                ((CompareFileJournalAction)a).setUncompressed(uncompressed);
                act = a;
            }
            if (ACTION_DUPLICATES.equals(action)) {
                a = new DuplicatesFileJournalAction();
                ((DuplicatesFileJournalAction)a).setRemoveFilter(removeFilter);
                ((DuplicatesFileJournalAction)a).setWindows(windows);
                ((DuplicatesFileJournalAction)a).setUnix(unix);
                act = a;
            }
            if (ACTION_RECONSTRUCT.equals(action)) {
                a = new ReconstructFileJournalAction();
                ((ReconstructFileJournalAction)a).setWindows(windows);
                ((ReconstructFileJournalAction)a).setUnix(unix);
                ((ReconstructFileJournalAction)a).setIgnoreLinks(ignoreLinks);
                ((ReconstructFileJournalAction)a).setIncludeMissing(includeMissing);
                ((ReconstructFileJournalAction)a).setMissingOnly(missingOnly);
                act = a;
            }
        }
        if (act == null) {
            return null;
        }
        if (act instanceof AbstractFileJournalAction) {
            AbstractFileJournalAction aa = act;
            aa.setLogger(this.logger);
            aa.setVerbose(verbose);
            aa.setDebug(debug);
            aa.setJournalPath(journalPath);
            aa.setOtherJournalPaths(otherJournalPaths);
            aa.setSequential(sequential);
            aa.setFilter(includeFilter);
            aa.setReplacer(replacer);
        }
        if (act instanceof BaseFileJournalAction) {
            BaseFileJournalAction ba = (BaseFileJournalAction)act;
            ba.setStartDate(sinceDate);
            ba.setUntilDate(untilDate);
        }
        return act;
    }

    protected RegexFileJournalFilter createRegexFileJournalFilter(String regex, boolean ignoreCase, boolean unicodeCase) {
        try {
            int flags = 32;
            if (ignoreCase) {
                flags |= 2;
                if (unicodeCase) {
                    flags |= 0x40;
                }
            }
            Pattern pattern = Pattern.compile(regex, flags);
            return new RegexFileJournalFilter(pattern);
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, e.getMessage(), e);
            return null;
        }
    }

    protected RegexFileJournalReplacer createRegexFileJournalReplacer(String regex, boolean ignoreCase, boolean unicodeCase, String replacement) {
        try {
            int flags = 32;
            if (ignoreCase) {
                flags |= 2;
                if (unicodeCase) {
                    flags |= 0x40;
                }
            }
            Pattern pattern = Pattern.compile(regex, flags);
            return new RegexFileJournalReplacer(pattern, replacement);
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, e.getMessage(), e);
            return null;
        }
    }

    protected void debug(String s) {
        Logger l = this.logger;
        if (l != null) {
            l.finer(s);
        } else {
            System.out.println(s);
        }
    }
}

