/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.filetools.md5sum;

import com.spacekiller.filetools.md5sum.Md5Entry;
import com.spacekiller.filetools.md5sum.Md5File;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;

public class Md5Comparator {
    public static void main(String[] args) {
        try {
            if (args.length > 0) {
                String charset = "UTF-8";
                int num = args.length;
                Md5File[] md5Files = new Md5File[num];
                for (int i = 0; i < num; ++i) {
                    String path = args[i];
                    File file = new File(path);
                    System.out.println("Reading: " + file);
                    Md5File md5File = new Md5File(file, charset);
                    System.out.println("Entries: " + md5File.getEntryCount());
                    md5Files[i] = md5File;
                }
                new Md5Comparator().compareMd5Files(md5Files);
            } else {
                System.out.println("Syntax: FileChecker [md5-file1] [md5-file2] ...");
            }
            System.exit(0);
        }
        catch (Throwable e) {
            e.printStackTrace(System.out);
            System.exit(1);
        }
    }

    protected Map createPathToEntryMap(Md5File md5File) throws Exception {
        HashMap<String, Md5Entry> map = new HashMap<String, Md5Entry>();
        int num = md5File.getEntryCount();
        for (int i = 0; i < num; ++i) {
            Md5Entry entry = md5File.getEntryAt(i);
            String path = entry.getFilePath();
            if (map.containsKey(path)) {
                throw new IOException("Duplicate file path: " + path);
            }
            map.put(path, entry);
        }
        return map;
    }

    public void compareMd5Files(Md5File[] md5Files) throws Exception {
        List list;
        int i;
        List bestList;
        TreeSet pathSet = new TreeSet();
        int num = md5Files.length;
        Map[] md5Maps = new Map[num];
        for (int i2 = 0; i2 < num; ++i2) {
            Map md5Map;
            md5Maps[i2] = md5Map = this.createPathToEntryMap(md5Files[i2]);
            pathSet.addAll(md5Map.keySet());
        }
        System.out.println("-------------------------------");
        System.out.println("Total number of paths: " + pathSet.size());
        List[] missingPaths = new List[num];
        for (int i3 = 0; i3 < num; ++i3) {
            missingPaths[i3] = new LinkedList();
        }
        LinkedList<String> equalPaths = new LinkedList<String>();
        HashMap<String, List> bestMap = new HashMap<String, List>();
        HashMap<String, LinkedList<Md5File>> checkMap = new HashMap<String, LinkedList<Md5File>>();
        for (String path : pathSet) {
            checkMap.clear();
            for (int i4 = 0; i4 < num; ++i4) {
                Md5Entry entry = (Md5Entry)md5Maps[i4].get(path);
                if (entry == null) {
                    missingPaths[i4].add(path);
                    continue;
                }
                String checksum = entry.getChecksum();
                LinkedList<Md5File> list2 = (LinkedList<Md5File>)checkMap.get(checksum);
                if (list2 == null) {
                    list2 = new LinkedList<Md5File>();
                    checkMap.put(checksum, list2);
                }
                list2.add(md5Files[i4]);
            }
            int checks = checkMap.size();
            if (checks < 1) {
                throw new IllegalStateException("No checksum(s) for path: " + path);
            }
            if (checks == 1) {
                equalPaths.add(path);
                continue;
            }
            int bestCount = 0;
            bestList = null;
            for (Map.Entry me : checkMap.entrySet()) {
                List list3 = (List)me.getValue();
                if (list3.size() <= bestCount) continue;
                bestCount = list3.size();
                bestList = list3;
            }
            if (bestList == null) {
                throw new IllegalStateException("No checksum(s) for path: " + path);
            }
            bestMap.put(path, bestList);
        }
        System.out.println("Number of equal entries: " + equalPaths.size());
        System.out.println("-------------------------------");
        for (int i5 = 0; i5 < num; ++i5) {
            System.out.println("Summary: " + md5Files[i5].getFile());
            System.out.println("Number of missing entries: " + missingPaths[i5].size());
            System.out.println("-------------------------------");
        }
        HashMap<Md5File, LinkedList<String>> bestSourceMap = new HashMap<Md5File, LinkedList<String>>();
        HashMap<Md5File, LinkedList<String>> alternativeSourceMap = new HashMap<Md5File, LinkedList<String>>();
        for (String path : pathSet) {
            bestList = (List)bestMap.get(path);
            if (bestList == null) continue;
            int index = 0;
            for (Md5File md5File : bestList) {
                List<String> list4;
                if (index == 0) {
                    list4 = (LinkedList<String>)bestSourceMap.get(md5File);
                    if (list4 == null) {
                        list4 = new LinkedList<String>();
                        bestSourceMap.put(md5File, (LinkedList<String>)list4);
                    }
                    list4.add(path);
                } else {
                    list4 = (List)alternativeSourceMap.get(md5File);
                    if (list4 == null) {
                        list4 = new LinkedList();
                        alternativeSourceMap.put(md5File, (LinkedList<String>)list4);
                    }
                    list4.add(path);
                }
                ++index;
            }
        }
        for (i = 0; i < num; ++i) {
            Md5File md5File = md5Files[i];
            list = (List)bestSourceMap.get(md5File);
            int siz = list == null ? 0 : list.size();
            System.out.println("Best sources: " + md5File.getFile() + " => " + siz + " files");
        }
        System.out.println("-------------------------------");
        for (i = 0; i < num; ++i) {
            Md5File md5File = md5Files[i];
            list = (List)alternativeSourceMap.get(md5File);
            int siz = list == null ? 0 : list.size();
            System.out.println("Alternative sources: " + md5File.getFile() + " => " + siz + " files");
        }
        System.out.println("-------------------------------");
        Map[] bestCopyMaps = new Map[num];
        for (int i6 = 0; i6 < num; ++i6) {
            bestCopyMaps[i6] = new HashMap();
        }
        for (String path : pathSet) {
            List bestList2 = (List)bestMap.get(path);
            if (bestList2 == null || bestList2.isEmpty()) continue;
            Md5File md5File = (Md5File)bestList2.get(0);
            int index = -1;
            for (int i7 = 0; i7 < num; ++i7) {
                if (md5File != md5Files[i7]) continue;
                index = i7;
                break;
            }
            if (index < 0) {
                throw new IllegalStateException("Md5File: " + md5File + ", Path: " + path);
            }
            Md5Entry entry = (Md5Entry)md5Maps[index].get(path);
            if (entry == null) {
                throw new IllegalStateException("Md5File: " + md5File + ", Path: " + path + ", Entry=" + entry);
            }
            String checksum = entry.getChecksum();
            for (int i8 = 0; i8 < num; ++i8) {
                String checksum2;
                Md5Entry entry2;
                if (i8 == index || (entry2 = (Md5Entry)md5Maps[i8].get(path)) != null && checksum.equals(checksum2 = entry2.getChecksum())) continue;
                LinkedList<String> list5 = (LinkedList<String>)bestCopyMaps[i8].get(md5File);
                if (list5 == null) {
                    list5 = new LinkedList<String>();
                    bestCopyMaps[i8].put(md5File, list5);
                }
                list5.add(path);
            }
        }
        for (int i9 = 0; i9 < num; ++i9) {
            Md5File target = md5Files[i9];
            Map bestCopyMap = bestCopyMaps[i9];
            for (Map.Entry me : bestCopyMap.entrySet()) {
                Md5File source = (Md5File)me.getKey();
                List list6 = (List)me.getValue();
                System.out.println("Best copy " + list6.size() + " files from " + source + " to " + target);
                boolean dump = true;
                if (!dump) continue;
                for (String path : list6) {
                    System.out.println("" + path);
                }
                System.out.println("-------------------------------");
            }
        }
        System.out.println("Compare completed.");
    }
}

