/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.filetools.md5sum;

import com.spacekiller.filetools.md5sum.Md5Entry;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StreamCorruptedException;
import java.util.ArrayList;
import java.util.List;

public class Md5File {
    private File file;
    private String charsetName;
    private List entries;

    public Md5File(File file, String charsetName) throws IOException {
        this.file = file;
        this.charsetName = charsetName;
        this.entries = new ArrayList();
        this.loadMd5File();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadMd5File() throws IOException {
        this.entries.clear();
        FileInputStream fis = new FileInputStream(this.file);
        try {
            InputStreamReader isr = new InputStreamReader((InputStream)fis, this.charsetName);
            try {
                BufferedReader reader = new BufferedReader(isr);
                try {
                    String line;
                    while ((line = reader.readLine()) != null) {
                        this.loadMd5Entry(line);
                    }
                }
                finally {
                    reader.close();
                }
            }
            finally {
                isr.close();
            }
        }
        finally {
            fis.close();
        }
    }

    protected void loadMd5Entry(String s) throws IOException {
        int x = s.indexOf(32);
        if (x != 32) {
            throw new StreamCorruptedException("Invalid md5sum entry: " + s);
        }
        String md5 = s.substring(0, x);
        if (s.length() < x + 2) {
            throw new StreamCorruptedException("Invalid md5sum entry: " + s);
        }
        char c = s.charAt(x + 1);
        if (c == ' ' || c == '*') {
            ++x;
        }
        String path = s.substring(x + 1);
        this.entries.add(new Md5Entry(md5, path));
    }

    public int getEntryCount() {
        return this.entries.size();
    }

    public Md5Entry getEntryAt(int index) {
        return (Md5Entry)this.entries.get(index);
    }

    public File getFile() {
        return this.file;
    }

    public String toString() {
        return this.file.getPath();
    }
}

