/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.filetools.recover;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;

public class FileChecker {
    private long maxBytesPerFile = -1L;
    private byte[] buffer;
    private boolean debug = false;

    public FileChecker(long maxBytesPerFile, int bufferSize) {
        this.maxBytesPerFile = maxBytesPerFile;
        this.buffer = new byte[bufferSize];
    }

    public static void main(String[] args) {
        try {
            if (args.length == 1) {
                String path = args[0];
                File base = new File(path);
                int maxBytesPerFile = 1024;
                int bufferSize = 0x100000;
                FileChecker checker = new FileChecker(maxBytesPerFile, bufferSize);
                checker.checkFiles(base);
            } else {
                System.out.println("Syntax: FileChecker [base-directory]");
            }
            System.exit(0);
        }
        catch (Throwable e) {
            e.printStackTrace(System.out);
            System.exit(1);
        }
    }

    public void checkFiles(File f) {
        System.out.println("Checking file(s): " + f);
        System.out.println("Max. bytes per file: " + this.maxBytesPerFile);
        System.out.println("Buffer size: " + this.buffer.length);
        long startTime = System.currentTimeMillis();
        HashSet done = new HashSet();
        this.checkFiles(f, done);
        long endTime = System.currentTimeMillis();
        System.out.println("Checked " + done.size() + " files in " + (endTime - startTime) + " ms.");
    }

    protected void checkFiles(File f, Set done) {
        try {
            File cf = f.getCanonicalFile();
            String cp = cf.getPath();
            if (!done.add(cp)) {
                return;
            }
            int don = done.size();
            if (don % 1000 == 0) {
                System.out.println("Checked " + don + " files...");
            }
            if (cf.isFile()) {
                if (this.debug) {
                    System.out.println(" - Checking file: " + cp);
                }
                this.checkFile(cf);
                return;
            }
            if (cf.isDirectory()) {
                File[] files;
                if (this.debug) {
                    System.out.println(" - Checking directory: " + cp);
                }
                if ((files = cf.listFiles()) != null) {
                    int num = files.length;
                    for (int i = 0; i < num; ++i) {
                        this.checkFiles(files[i], done);
                    }
                }
            }
        }
        catch (Exception e) {
            System.err.println("Error checking file: " + f + " ==> " + e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkFile(File f) throws IOException {
        FileInputStream fis = new FileInputStream(f);
        try {
            int r;
            if (this.maxBytesPerFile == 0L) {
                return;
            }
            long size = 0L;
            do {
                int n;
                if ((r = fis.read(this.buffer, 0, n = this.maxBytesPerFile > 0L ? (int)Math.min((long)this.buffer.length, this.maxBytesPerFile - size) : this.buffer.length)) >= 0) continue;
                break;
            } while ((size += (long)r) < this.maxBytesPerFile);
        }
        finally {
            fis.close();
        }
    }
}

