/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.filetools.search;

import java.io.IOException;
import java.io.RandomAccessFile;

public class FileCharSequence
implements CharSequence {
    private byte[] buf;
    private int ofs;
    private int end;
    private RandomAccessFile raf;
    private long fileOfs;
    private int fileLen;

    public FileCharSequence(byte[] buf) {
        this.buf = buf;
    }

    public void reset(RandomAccessFile file, long off, int len) throws IOException {
        this.raf = file;
        this.fileOfs = off;
        this.fileLen = len;
        this.ofs = 0;
        this.end = 0;
    }

    protected void load() {
        if (this.ofs < this.end) {
            try {
                this.raf.seek(this.fileOfs + (long)this.ofs);
                this.raf.readFully(this.buf, 0, this.end - this.ofs);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public int length() {
        return this.fileLen;
    }

    @Override
    public char charAt(int index) {
        if (index >= this.end || index < this.ofs) {
            if (index < 0) {
                throw new IndexOutOfBoundsException("index=" + index);
            }
            this.ofs = index;
            this.end = this.ofs + this.buf.length;
            if (this.end > this.fileLen) {
                this.end = this.fileLen;
            }
            if (index >= this.end) {
                throw new IndexOutOfBoundsException("index=" + index + " >= " + this.end);
            }
            this.load();
        }
        return (char)this.buf[index - this.ofs];
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        throw new UnsupportedOperationException();
    }
}

