/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.filetools.search;

import com.spacekiller.filetools.search.FileMatchConsumer;
import com.spacekiller.filetools.search.FileSearcher;
import com.spacekiller.filetools.search.RegexFileMatch;
import com.spacekiller.filetools.search.TestCharSequence;
import java.io.File;
import java.io.IOException;
import java.util.regex.Matcher;

public class RegexFileSearcher
implements FileSearcher {
    private Matcher[] matchers;
    private volatile boolean cancel;

    public Matcher[] getMatchers() {
        return this.matchers;
    }

    public void setMatchers(Matcher[] matchers) {
        this.matchers = matchers;
    }

    @Override
    public void cancel() {
        this.cancel = true;
    }

    @Override
    public void search(File file, FileMatchConsumer consumer) throws IOException {
        int num;
        this.cancel = false;
        Matcher[] mats = this.matchers;
        int n = num = mats == null ? 0 : mats.length;
        if (num < 1) {
            throw new IllegalArgumentException("No regex matchers specified!");
        }
        long fileOffset = 0L;
        TestCharSequence seq = new TestCharSequence(1000000);
        for (int i = 0; i < num; ++i) {
            Matcher mat = mats[i];
            mat.reset(seq);
            while (mat.find()) {
                if (consumer.consume(new RegexFileMatch(fileOffset + (long)mat.start(), fileOffset + (long)mat.end(), mat.pattern())) && !this.cancel) continue;
                return;
            }
            if (!this.cancel) continue;
            return;
        }
    }
}

