/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.filetools.split;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;

public class FileSplitter {
    public static final String PART_FILE_SUFFIX = ".part";
    public static final int KB = 1024;
    public static final int MB = 0x100000;
    public static final int GB = 0x40000000;
    private File file;
    private long partSize;

    public FileSplitter(File file, long partSize) {
        this.file = file;
        this.partSize = partSize;
    }

    public static void main(String[] args) {
        try {
            if (args.length != 2) {
                System.out.println("Invalid arguments!");
                System.out.println("Syntax: FileSplitter [filePath] [partSize]");
                throw new IllegalArgumentException("Invalid number of arguments: " + args.length + " != 2");
            }
            String filePath = args[0];
            String partSize = args[1];
            long partSizeLong = FileSplitter.parsePartSize(partSize);
            if (partSizeLong < 1L) {
                throw new IllegalArgumentException("Invalid part size specified: " + partSize + " = " + partSizeLong);
            }
            File file = new File(filePath);
            if (!file.exists()) {
                throw new FileNotFoundException(filePath);
            }
            long fileLen = file.length();
            if (fileLen <= partSizeLong) {
                throw new IllegalArgumentException("File length is smaller than part size: " + fileLen + " <= " + partSizeLong);
            }
            FileSplitter splitter = new FileSplitter(file, partSizeLong);
            splitter.split();
            System.out.println("Success.");
            System.exit(0);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long split() throws Exception {
        System.out.println("Splitting file: " + this.file);
        System.out.println("Part size: " + this.partSize);
        byte[] buf = new byte[0x1000000];
        long partCount = 0L;
        FileInputStream fis = new FileInputStream(this.file);
        try {
            File partFile = null;
            FileOutputStream fos = null;
            long remain = 0L;
            try {
                int num;
                block6: while ((num = fis.read(buf)) >= 0) {
                    int off = 0;
                    while (true) {
                        if (off >= num) continue block6;
                        if (partFile == null) {
                            String partPath = this.file.getPath() + "-" + ++partCount + PART_FILE_SUFFIX;
                            partFile = new File(partPath);
                            if (partFile.exists()) {
                                throw new IOException("Target part file already exists: " + partPath);
                            }
                            System.out.println("Writing part file: " + partPath);
                            fos = new FileOutputStream(partFile);
                            remain = this.partSize;
                        }
                        int n = (int)Math.min((long)(num - off), remain);
                        fos.write(buf, off, n);
                        off += n;
                        if ((remain -= (long)n) >= 1L) continue;
                        fos.close();
                        partFile = null;
                    }
                    break;
                }
            }
            finally {
                if (fos != null) {
                    fos.close();
                }
            }
        }
        finally {
            fis.close();
        }
        System.out.println("File splitted successfully into " + partCount + " parts.");
        return partCount;
    }

    public static long parsePartSize(String s) throws Exception {
        long unit = 0L;
        s = s.trim().toLowerCase();
        if (unit < 1L && s.endsWith("g")) {
            unit = 0x40000000L;
            s = s.substring(0, s.length() - 1);
        } else if (unit < 1L && s.endsWith("m")) {
            unit = 0x100000L;
            s = s.substring(0, s.length() - 1);
        } else if (unit < 1L && s.endsWith("k")) {
            unit = 1024L;
            s = s.substring(0, s.length() - 1);
        } else if (unit < 1L && s.endsWith("b")) {
            unit = 1L;
            s = s.substring(0, s.length() - 1);
        } else {
            unit = 1L;
        }
        long value = Long.parseLong(s.trim());
        return value * unit;
    }
}

