/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.large;

import com.spacekiller.util.Data;
import com.spacekiller.util.large.LargeSet;
import com.spacekiller.util.large.SerializedLargeMap;
import com.spacekiller.util.serializer.Serializer;
import java.math.BigInteger;
import java.util.AbstractSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public class DefaultSerializedLargeMap
extends SerializedLargeMap {
    private static final Long NULL_HASH = Data.toLong((long)0L);
    protected Map map = new HashMap();
    protected transient EntrySet entrySet;

    public DefaultSerializedLargeMap(Serializer keySerializer, Serializer valueSerializer) {
        super(keySerializer, valueSerializer);
    }

    public Set entrySet() {
        EntrySet es = this.entrySet;
        return es == null ? (this.entrySet = new EntrySet()) : es;
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public int intSize() {
        return this.map.size();
    }

    @Override
    public long longSize() {
        return this.map.size();
    }

    @Override
    public BigInteger bigSize() {
        return BigInteger.valueOf(this.map.size());
    }

    @Override
    public int exactIntSize() {
        int size = this.map.size();
        return size == Integer.MAX_VALUE ? -1 : size;
    }

    @Override
    public long exactLongSize() {
        int size = this.map.size();
        return size == Integer.MAX_VALUE ? -1L : (long)size;
    }

    @Override
    public BigInteger exactBigSize() {
        int size = this.map.size();
        return size == Integer.MAX_VALUE ? null : BigInteger.valueOf(size);
    }

    public Object get(Object key) {
        DefaultEntry entry;
        Long hk = this.hash(key);
        if (key == null) {
            for (entry = (DefaultEntry)this.map.get(hk); entry != null; entry = entry.next()) {
                if (entry.key != null) continue;
                byte[] v = entry.val;
                return v == null ? null : this.readValue(v, 0, v.length);
            }
        } else {
            while (entry != null) {
                byte[] k = entry.key;
                if (k != null && key.equals(this.readKey(k, 0, k.length))) {
                    byte[] v = entry.val;
                    return v == null ? null : this.readValue(v, 0, v.length);
                }
                entry = entry.next();
            }
        }
        return null;
    }

    public Object put(Object key, Object value) {
        DefaultEntry first;
        DefaultEntry entry;
        Long hk = this.hash(key);
        if (key == null) {
            for (entry = first = (DefaultEntry)this.map.get(hk); entry != null; entry = entry.next()) {
                if (entry.key != null) continue;
                byte[] v = entry.val;
                entry.val = this.writeValue(value);
                return v == null ? null : this.readValue(v, 0, v.length);
            }
        } else {
            while (entry != null) {
                byte[] k = entry.key;
                if (k != null && key.equals(this.readKey(k, 0, k.length))) {
                    byte[] v = entry.val;
                    entry.val = this.writeValue(value);
                    return v == null ? null : this.readValue(v, 0, v.length);
                }
                entry = entry.next();
            }
        }
        if (first == null) {
            this.map.put(hk, new DefaultEntry(this.writeKey(key), this.writeValue(value)));
        } else {
            this.map.put(hk, new MultiEntry(this.writeKey(key), this.writeValue(value), first));
        }
        return null;
    }

    public Object remove(Object key) {
        DefaultEntry entry;
        Long hk = this.hash(key);
        MultiEntry prev = null;
        if (key == null) {
            for (entry = (DefaultEntry)this.map.get(hk); entry != null; entry = entry.next()) {
                if (entry.key == null) {
                    byte[] v = entry.val;
                    if (prev == null) {
                        if ((entry = entry.next()) == null) {
                            this.map.remove(hk);
                        } else {
                            this.map.put(hk, entry);
                        }
                    } else {
                        prev.next = entry.next();
                    }
                    return v == null ? null : this.readValue(v, 0, v.length);
                }
                prev = (MultiEntry)entry;
            }
        } else {
            while (entry != null) {
                byte[] k = entry.key;
                if (k != null && key.equals(this.readKey(k, 0, k.length))) {
                    byte[] v = entry.val;
                    if (prev == null) {
                        if ((entry = entry.next()) == null) {
                            this.map.remove(hk);
                        } else {
                            this.map.put(hk, entry);
                        }
                    } else {
                        prev.next = entry.next();
                    }
                    return v == null ? null : this.readValue(v, 0, v.length);
                }
                prev = (MultiEntry)entry;
                entry = entry.next();
            }
        }
        return null;
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    protected Long hash(Object k) {
        if (k == null) {
            return NULL_HASH;
        }
        return Data.toLong((long)k.hashCode());
    }

    protected class EntryIter
    implements Iterator {
        protected Iterator iter;
        protected Map.Entry me;
        protected DefaultEntry de;
        protected MultiEntry pe;

        public EntryIter() {
            this.iter = DefaultSerializedLargeMap.this.map.entrySet().iterator();
            if (this.iter.hasNext()) {
                this.me = (Map.Entry)this.iter.next();
            }
        }

        @Override
        public boolean hasNext() {
            return this.me != null && (this.de != null && this.de.next() != null || this.iter.hasNext());
        }

        /*
         * Enabled aggressive block sorting
         */
        public Object next() {
            if (this.de == null) {
                if (this.me == null) {
                    throw new NoSuchElementException();
                }
                this.pe = null;
                this.de = (DefaultEntry)this.me.getValue();
                return this.de;
            }
            DefaultEntry ne = this.de.next();
            if (ne != null) {
                this.pe = (MultiEntry)this.de;
                this.de = ne;
                return this.de;
            }
            this.pe = null;
            if (this.iter.hasNext()) {
                this.me = (Map.Entry)this.iter.next();
                this.de = (DefaultEntry)this.me.getValue();
                return this.de;
            }
            this.de = null;
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            if (this.de == null) {
                throw new NoSuchElementException();
            }
            if (this.pe == null) {
                DefaultEntry ne = this.de.next();
                if (ne == null) {
                    this.iter.remove();
                } else {
                    this.me.setValue(ne);
                }
            } else {
                this.pe.next = this.de.next();
            }
        }
    }

    protected class EntrySet
    extends AbstractSet
    implements LargeSet {
        protected EntrySet() {
        }

        @Override
        public boolean isEmpty() {
            return DefaultSerializedLargeMap.this.map.isEmpty();
        }

        @Override
        public int size() {
            return DefaultSerializedLargeMap.this.map.size();
        }

        @Override
        public int intSize() {
            return DefaultSerializedLargeMap.this.map.size();
        }

        @Override
        public long longSize() {
            return DefaultSerializedLargeMap.this.map.size();
        }

        @Override
        public BigInteger bigSize() {
            return BigInteger.valueOf(DefaultSerializedLargeMap.this.map.size());
        }

        @Override
        public int exactIntSize() {
            int size = DefaultSerializedLargeMap.this.map.size();
            return size == Integer.MAX_VALUE ? -1 : size;
        }

        @Override
        public long exactLongSize() {
            int size = DefaultSerializedLargeMap.this.map.size();
            return size == Integer.MAX_VALUE ? -1L : (long)size;
        }

        @Override
        public BigInteger exactBigSize() {
            int size = DefaultSerializedLargeMap.this.map.size();
            return size == Integer.MAX_VALUE ? null : BigInteger.valueOf(size);
        }

        @Override
        public Iterator iterator() {
            return new EntryIter();
        }
    }

    protected class MultiEntry
    extends DefaultEntry {
        protected DefaultEntry next;

        public MultiEntry(byte[] key, byte[] val, DefaultEntry next) {
            super(key, val);
            this.next = next;
        }

        @Override
        protected DefaultEntry next() {
            return this.next;
        }
    }

    protected class DefaultEntry
    implements Map.Entry {
        protected byte[] key;
        protected byte[] val;

        public DefaultEntry(byte[] key, byte[] val) {
            this.key = key;
            this.val = val;
        }

        public Object getKey() {
            byte[] k = this.key;
            return k == null ? null : DefaultSerializedLargeMap.this.readKey(k, 0, k.length);
        }

        public Object getValue() {
            byte[] v = this.val;
            return v == null ? null : DefaultSerializedLargeMap.this.readValue(v, 0, v.length);
        }

        public Object setValue(Object value) {
            byte[] v = this.val;
            Object r = v == null ? null : DefaultSerializedLargeMap.this.readValue(v, 0, v.length);
            this.val = DefaultSerializedLargeMap.this.writeValue(value);
            return r;
        }

        protected DefaultEntry next() {
            return null;
        }
    }
}

