/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.large;

import com.spacekiller.util.Data;
import com.spacekiller.util.heap.Block;
import com.spacekiller.util.heap.Heap;
import com.spacekiller.util.large.LargeRuntimeException;
import com.spacekiller.util.large.LargeSet;
import com.spacekiller.util.large.SerializedLargeMap;
import com.spacekiller.util.serializer.Serializer;
import java.io.IOException;
import java.math.BigInteger;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.Set;

public class HeapSerializedLargeMap
extends SerializedLargeMap {
    private static final long NULL_HASH = -1L;
    private static final int LONG_SIZE = 8;
    private static final int HASH_ENTRY_SIZE = 16;
    private static final int MIN_BLOCK_CAPACITY = 4;
    private static final long NONE = 0L;
    protected final Heap hashHeap;
    protected final Heap dataHeap;
    protected final int hashBlockCapacity;
    protected final int hashBlockThreshold;
    protected final int hashBlockBytes;
    protected final int dataBlockBytes;
    protected long size;
    protected transient EntrySet entrySet;
    protected HashBlock firstHashBlock;
    protected HashBlock lastHashBlock;
    protected DataBlock firstDataBlock;
    protected DataBlock lastDataBlock;
    protected final byte[] buf;

    public HeapSerializedLargeMap(Serializer keySerializer, Serializer valueSerializer, Heap heap, int hashBlockCapacity, int dataBlockBytes) {
        super(keySerializer, valueSerializer);
        this.hashHeap = heap;
        this.dataHeap = heap;
        if (hashBlockCapacity < 4) {
            throw new IllegalArgumentException("Invalid hashBlockCapacity: " + hashBlockCapacity + " < " + 4);
        }
        this.hashBlockCapacity = hashBlockCapacity;
        this.hashBlockThreshold = hashBlockCapacity / 2;
        this.hashBlockBytes = hashBlockCapacity * 16;
        this.dataBlockBytes = dataBlockBytes;
        this.buf = new byte[16];
    }

    public synchronized Set entrySet() {
        EntrySet es = this.entrySet;
        return es == null ? (this.entrySet = new EntrySet()) : es;
    }

    @Override
    public synchronized boolean isEmpty() {
        return this.size < 1L;
    }

    @Override
    public synchronized int size() {
        long count = this.size;
        return count > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)count;
    }

    @Override
    public synchronized int intSize() {
        long count = this.size;
        return count > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)count;
    }

    @Override
    public synchronized long longSize() {
        return this.size;
    }

    @Override
    public synchronized BigInteger bigSize() {
        return BigInteger.valueOf(this.size);
    }

    @Override
    public synchronized int exactIntSize() {
        long count = this.size;
        return count > Integer.MAX_VALUE ? -1 : (int)count;
    }

    @Override
    public synchronized long exactLongSize() {
        return this.size;
    }

    @Override
    public synchronized BigInteger exactBigSize() {
        return BigInteger.valueOf(this.size);
    }

    public synchronized Object get(Object key) {
        long hk = this.hash(key);
        int ho = this.offset(hk);
        try {
            HashBlock hb = this.firstHashBlock;
            while (hb != null) {
                int o = ho;
                while (true) {
                    hb.block.read(o, this.buf, 0, 8);
                    long h = Data.getLong((byte[])this.buf, (int)0);
                    if (h == 0L) break;
                    if (h == hk) {
                        throw new UnsupportedOperationException("TODO get: key=" + key + ", hk=" + hk);
                    }
                    o = this.next(o);
                }
                hb = hb.next;
            }
        }
        catch (IOException e) {
            throw new LargeRuntimeException(e);
        }
        throw new UnsupportedOperationException("TODO get: key=" + key);
    }

    public synchronized Object put(Object key, Object value) {
        HashBlock hb;
        long hk = this.hash(key);
        int ho = this.offset(hk);
        if (this.size > 0L) {
            try {
                hb = this.firstHashBlock;
                while (hb != null) {
                    int o = ho;
                    while (true) {
                        hb.block.read(o, this.buf, 0, 8);
                        long h = Data.getLong((byte[])this.buf, (int)0);
                        if (h == 0L) break;
                        if (h == hk) {
                            throw new UnsupportedOperationException("TODO update: key=" + key + ", value=" + value);
                        }
                        o = this.next(o);
                    }
                    hb = hb.next;
                }
            }
            catch (IOException e) {
                throw new LargeRuntimeException(e);
            }
        }
        hb = this.lastHashBlock;
        while (hb != null) {
            if (hb.size < this.hashBlockThreshold) {
                this.insert(hk, ho, hb, key, value);
                return null;
            }
            hb = hb.prev;
        }
        hb = this.createHashBlock();
        if (this.lastHashBlock == null) {
            this.firstHashBlock = hb;
        } else {
            this.lastHashBlock.next = hb;
            hb.prev = this.lastHashBlock;
        }
        this.lastHashBlock = hb;
        this.insert(hk, ho, hb, key, value);
        return null;
    }

    protected synchronized void insert(long hk, int ho, HashBlock hb, Object key, Object value) {
        try {
            while (true) {
                hb.block.read(ho, this.buf, 0, 8);
                long h = Data.getLong((byte[])this.buf, (int)0);
                if (h == 0L) {
                    byte[] k = this.writeKey(key);
                    byte[] v = this.writeValue(value);
                    long dataOfs = -1L;
                    Data.setLong((byte[])this.buf, (int)0, (long)hk);
                    Data.setLong((byte[])this.buf, (int)8, (long)dataOfs);
                    hb.block.write(ho, this.buf, 0, 16);
                    ++hb.size;
                    ++this.size;
                    return;
                }
                ho = this.next(ho);
            }
        }
        catch (IOException e) {
            throw new LargeRuntimeException(e);
        }
    }

    public synchronized Object remove(Object key) {
        long hk = this.hash(key);
        int ho = this.offset(hk);
        throw new UnsupportedOperationException("TODO remove: key=" + key);
    }

    @Override
    public synchronized void clear() {
        if (this.size < 1L) {
            return;
        }
        throw new UnsupportedOperationException("TODO clear: " + this);
    }

    protected long hash(Object k) {
        if (k == null) {
            return -1L;
        }
        int hk = k.hashCode() << 1;
        return (long)hk == 0L ? -1L : (long)hk;
    }

    protected int offset(long hk) {
        return 16 * (int)(Math.abs(hk) % (long)this.hashBlockCapacity);
    }

    protected int next(int ho) {
        return (ho + 16) % this.hashBlockBytes;
    }

    protected HashBlock createHashBlock() {
        try {
            return new HashBlock(this.hashHeap.allocate(this.hashBlockBytes));
        }
        catch (IOException e) {
            throw new LargeRuntimeException(e);
        }
    }

    protected DataBlock createDataBlock() {
        try {
            return new DataBlock(this.dataHeap.allocate(this.dataBlockBytes));
        }
        catch (IOException e) {
            throw new LargeRuntimeException(e);
        }
    }

    protected class DataBlock {
        protected DataBlock prev;
        protected DataBlock next;
        protected Block block;

        public DataBlock(Block block) {
            this.block = block;
        }
    }

    protected class HashBlock {
        protected HashBlock prev;
        protected HashBlock next;
        protected Block block;
        protected int size;

        public HashBlock(Block block) {
            this.block = block;
        }

        public String toString() {
            return super.toString() + "[size=" + this.size + "]";
        }
    }

    protected class EntryIter
    implements Iterator {
        @Override
        public boolean hasNext() {
            throw new UnsupportedOperationException("TODO");
        }

        public Object next() {
            throw new UnsupportedOperationException("TODO");
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("TODO");
        }
    }

    protected class EntrySet
    extends AbstractSet
    implements LargeSet {
        protected EntrySet() {
        }

        @Override
        public boolean isEmpty() {
            return HeapSerializedLargeMap.this.size < 1L;
        }

        @Override
        public int size() {
            long count = HeapSerializedLargeMap.this.size;
            return count > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)count;
        }

        @Override
        public int intSize() {
            long count = HeapSerializedLargeMap.this.size;
            return count > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)count;
        }

        @Override
        public int exactIntSize() {
            long count = HeapSerializedLargeMap.this.size;
            return count > Integer.MAX_VALUE ? -1 : (int)count;
        }

        @Override
        public long longSize() {
            return HeapSerializedLargeMap.this.size;
        }

        @Override
        public long exactLongSize() {
            return HeapSerializedLargeMap.this.size;
        }

        @Override
        public BigInteger bigSize() {
            return BigInteger.valueOf(HeapSerializedLargeMap.this.size);
        }

        @Override
        public BigInteger exactBigSize() {
            return BigInteger.valueOf(HeapSerializedLargeMap.this.size);
        }

        @Override
        public Iterator iterator() {
            return new EntryIter();
        }
    }
}

