/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.large;

import com.spacekiller.util.Data;
import com.spacekiller.util.buffer.IntInput;
import com.spacekiller.util.buffer.IntOutput;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.List;

public class LargeIntArray {
    private int size;
    private File file;
    private RandomAccessFile raf;
    private int fileLength;
    private int partSize;
    private int partLength;
    private List parts;
    private int partCount;
    private int alloc = 0;
    private int cache = 0;
    private byte[] fbf;

    public LargeIntArray(File tempDir, int cacheSize, int partSize) throws IOException {
        this.cache = cacheSize;
        this.file = this.createTempFile(tempDir);
        this.raf = new RandomAccessFile(this.file, "rw");
        this.parts = new ArrayList();
        this.partSize = partSize;
        this.partLength = partSize * 4;
        Part p1 = new Part(0);
        this.parts.add(p1);
        this.partCount = 1;
        this.fileLength = this.partLength;
        this.size = 0;
        this.fbf = new byte[this.partLength];
    }

    protected File createTempFile(File dir) throws IOException {
        String prefix = "LargeIntArray";
        String suffix = ".tmp";
        File tempFile = File.createTempFile(prefix, suffix, dir);
        tempFile.deleteOnExit();
        return tempFile;
    }

    public int size() {
        return this.size;
    }

    public int get(int i) throws IOException {
        int p = i / this.partSize;
        Part pt = (Part)this.parts.get(p);
        if (pt.buf == null) {
            this.load(pt);
        }
        int o = i % this.partSize;
        return pt.buf[o];
    }

    protected void allocate(Part p) throws IOException {
        int[] recycle = null;
        if (this.alloc + this.partSize > this.cache) {
            for (int c = 0; c < this.partCount; ++c) {
                Part m = (Part)this.parts.get(c);
                if (m.buf == null) continue;
                if (m.mod) {
                    this.flush(m);
                }
                recycle = m.buf;
                m.buf = null;
                this.alloc -= this.partSize;
                if (this.alloc + this.partSize <= this.cache) break;
            }
        }
        p.buf = recycle == null ? new int[this.partSize] : recycle;
        this.alloc += this.partSize;
    }

    protected void flush(Part p) throws IOException {
        int num = p.size;
        int[] bf = p.buf;
        int o = 0;
        for (int c = 0; c < num; ++c) {
            Data.setInt((byte[])this.fbf, (int)o, (int)bf[c]);
            o += 4;
        }
        this.raf.seek(p.ofs);
        this.raf.write(this.fbf, 0, o);
        p.mod = false;
    }

    protected void load(Part p) throws IOException {
        this.allocate(p);
        int num = p.size;
        this.raf.seek(p.ofs);
        this.raf.read(this.fbf, 0, num * 4);
        int[] bf = p.buf;
        int o = 0;
        for (int c = 0; c < num; ++c) {
            bf[c] = Data.getInt((byte[])this.fbf, (int)o);
            o += 4;
        }
    }

    public void set(int i, int v) throws IOException {
        int p = i / this.partSize;
        Part pt = (Part)this.parts.get(p);
        if (pt.buf == null) {
            this.load(pt);
        }
        int o = i % this.partSize;
        pt.buf[o] = v;
        pt.mod = true;
    }

    public void add(int v) throws IOException {
        Part p = (Part)this.parts.get(this.partCount - 1);
        if (p.size < this.partSize) {
            if (p.buf == null) {
                this.load(p);
            }
            p.buf[p.size++] = v;
            p.mod = true;
            ++this.size;
            return;
        }
        Part np = new Part(this.fileLength);
        this.parts.add(np);
        ++this.partCount;
        this.fileLength += this.partLength;
        this.allocate(np);
        np.buf[np.size++] = v;
        np.mod = true;
        ++this.size;
    }

    public void clear() throws IOException {
        if (this.size < 1) {
            return;
        }
        throw new IOException("TODO clear");
    }

    public void dispose() throws IOException {
        if (this.raf != null) {
            this.raf.close();
            this.raf = null;
        }
        if (this.file != null) {
            this.file.delete();
            this.file = null;
        }
    }

    protected void finalize() throws Throwable {
        this.dispose();
    }

    public IntOutput createIntOutput() {
        return new LargeIntOutput();
    }

    public IntInput createIntInput(int index) {
        return new LargeIntInput(index);
    }

    public IntInput createReverseIntInput(int pos) {
        return new ReverseIntInput(pos);
    }

    protected class ReverseIntInput
    implements IntInput {
        private int x;

        public ReverseIntInput(int pos) {
            this.x = pos;
        }

        public int read() throws IOException {
            return LargeIntArray.this.get(--this.x);
        }

        public void read(DataOutputStream out, int len) throws IOException {
            throw new UnsupportedOperationException();
        }

        public void read(int[] dst, int ofs, int len) throws IOException {
            throw new UnsupportedOperationException();
        }
    }

    protected class LargeIntInput
    implements IntInput {
        private int x;

        public LargeIntInput(int index) {
            this.x = index;
        }

        public int read() throws IOException {
            return LargeIntArray.this.get(this.x++);
        }

        public void read(DataOutputStream out, int len) throws IOException {
            throw new UnsupportedOperationException();
        }

        public void read(int[] dst, int ofs, int len) throws IOException {
            throw new UnsupportedOperationException();
        }
    }

    protected class LargeIntOutput
    implements IntOutput {
        public void write(int i) throws IOException {
            LargeIntArray.this.add(i);
        }

        public void write(DataInputStream in, int len) throws IOException {
            throw new UnsupportedOperationException();
        }

        public void write(int[] src, int ofs, int len) throws IOException {
            throw new UnsupportedOperationException();
        }
    }

    protected class Part {
        int ofs;
        int[] buf;
        int size;
        boolean mod;

        public Part(int ofs) {
            this.ofs = ofs;
        }
    }
}

