/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.large;

import com.spacekiller.util.Data;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;

public class LargeIntSet {
    public static final int DEFAULT_MAX_PART_RANGE = 1000000;
    private int size;
    private List parts;
    private int partCount;
    private int partLength;
    private int maxPartRange;
    private int fileSize;
    private int cacheSize;
    private int cacheMax;
    private List partUsage;
    private File file;
    private RandomAccessFile raf;
    private byte[] rwb;
    private boolean hasZero;

    public LargeIntSet(File tempDir, int cache, int partLength, int maxPartRange) throws IOException {
        this.file = this.createTempFile(tempDir);
        this.raf = new RandomAccessFile(this.file, "rw");
        this.fileSize = 0;
        this.size = 0;
        this.parts = new ArrayList();
        this.partCount = 0;
        this.partLength = partLength;
        this.cacheSize = 0;
        this.cacheMax = cache;
        this.partUsage = new LinkedList();
        this.maxPartRange = maxPartRange;
        this.rwb = new byte[partLength * 4];
    }

    protected File createTempFile(File dir) throws IOException {
        String prefix = "LargeIntSet";
        String suffix = ".tmp";
        File tempFile = File.createTempFile(prefix, suffix, dir);
        tempFile.deleteOnExit();
        return tempFile;
    }

    protected void allocate(Part part, boolean clear) throws IOException {
        int[] tt = null;
        int plen = part.len;
        int len = plen * 4;
        this.cacheSize += len;
        if (this.cacheSize > this.cacheMax) {
            for (Part p : this.partUsage) {
                if (p.tab == null) continue;
                if (p.mod) {
                    this.flush(p);
                    p.mod = false;
                }
                if (p.len == plen) {
                    tt = p.tab;
                }
                p.tab = null;
                this.cacheSize -= p.len * 4;
                if (this.cacheSize > this.cacheMax) continue;
            }
        }
        if (tt != null) {
            part.tab = tt;
            if (clear) {
                Arrays.fill(tt, 0);
            }
        } else {
            part.tab = new int[part.len];
        }
    }

    protected void load(Part part) throws IOException {
        this.allocate(part, false);
        int len = part.len;
        int[] t = part.tab;
        this.raf.seek(part.ofs);
        this.raf.read(this.rwb, 0, len * 4);
        int o = 0;
        for (int c = 0; c < len; ++c) {
            t[c] = Data.getInt((byte[])this.rwb, (int)o);
            o += 4;
        }
    }

    protected void flush(Part part) throws IOException {
        int len = part.len;
        int[] t = part.tab;
        int o = 0;
        for (int c = 0; c < len; ++c) {
            Data.setInt((byte[])this.rwb, (int)o, (int)t[c]);
            o += 4;
        }
        this.raf.seek(part.ofs);
        this.raf.write(this.rwb, 0, o);
    }

    public int size() {
        return this.size;
    }

    public void put(int id) throws IOException {
        Part part;
        if (id == 0) {
            if (!this.hasZero) {
                this.hasZero = true;
                ++this.size;
            }
            return;
        }
        Part toUse = null;
        for (int c = 0; c < this.partCount; ++c) {
            part = (Part)this.parts.get(c);
            if (part.min > id || part.max < id) continue;
            if (part.lo <= id && part.hi >= id) {
                if (part.tab == null) {
                    this.load(part);
                }
                if (part.has(id)) {
                    return;
                }
            }
            if (toUse != null || part.isFull()) continue;
            toUse = part;
        }
        part = toUse;
        if (part == null) {
            int ofs = this.fileSize;
            int min = id & 0xFFFFFF00;
            int max = min + this.maxPartRange - 1;
            int len = this.partLength;
            this.fileSize += len * 4;
            part = new Part(ofs, min, max, len);
            this.parts.add(part);
            ++this.partCount;
            this.allocate(part, true);
            part.mod = true;
        } else if (part.tab == null) {
            this.load(part);
        }
        this.partUsage.remove(part);
        this.partUsage.add(part);
        part.put(id);
        part.mod = true;
        ++this.size;
    }

    public boolean has(int id) throws IOException {
        if (id == 0) {
            return this.hasZero;
        }
        for (int c = 0; c < this.partCount; ++c) {
            Part part = (Part)this.parts.get(c);
            if (part.min > id || part.max < id || part.lo > id || part.hi < id) continue;
            if (part.tab == null) {
                this.load(part);
            }
            if (!part.has(id)) continue;
            return true;
        }
        return false;
    }

    public void dispose() throws IOException {
        if (this.raf != null) {
            this.raf.close();
            this.raf = null;
        }
        if (this.file != null) {
            this.file.delete();
            this.file = null;
        }
    }

    protected void finalize() throws Throwable {
        this.dispose();
    }

    public File getFile() {
        return this.file;
    }

    protected void setFile(File file) {
        this.file = file;
    }

    public int getFileSize() {
        return this.fileSize;
    }

    protected void setFileSize(int fileSize) {
        this.fileSize = fileSize;
    }

    public static class Part {
        int ofs;
        int min;
        int max;
        int lo = 0;
        int hi = -1;
        int len;
        int size;
        int threshold;
        int[] tab;
        boolean mod;

        public Part(int ofs, int min, int max, int len) {
            this.ofs = ofs;
            this.min = min;
            this.max = max;
            this.lo = 0;
            this.hi = -1;
            this.len = len;
            this.threshold = len * 2 / 3;
            this.size = 0;
        }

        public boolean isFull() {
            return this.size >= this.threshold;
        }

        private int next(int i) {
            return ++i < this.len ? i : 0;
        }

        public void put(int id) {
            int v;
            int i = (id & Integer.MAX_VALUE) % this.len;
            while ((v = this.tab[i]) != 0) {
                if (v == id) {
                    return;
                }
                i = this.next(i);
            }
            this.tab[i] = id;
            ++this.size;
            if (this.lo > this.hi) {
                this.lo = id;
                this.hi = id;
            } else {
                if (id < this.lo) {
                    this.lo = id;
                }
                if (id > this.hi) {
                    this.hi = id;
                }
            }
        }

        public boolean has(int id) {
            int v;
            int i = (id & Integer.MAX_VALUE) % this.len;
            while ((v = this.tab[i]) != 0) {
                if (v == id) {
                    return true;
                }
                i = this.next(i);
            }
            return false;
        }
    }
}

