/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.large;

import com.spacekiller.util.buffer.LongInput;
import com.spacekiller.util.buffer.LongOutput;
import com.spacekiller.util.large.LargeLongSet;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;

public class LargeLongQueue
implements LongInput,
LongOutput {
    private int initCapacity = 64;
    private int incrementCapacity = 64;
    private boolean nullDone = false;
    private LargeLongSet done;
    private List queue;
    private int rBufIndex;
    private long[] rBuf;
    private int rLen = 0;
    private int rPos = 0;
    private int wBufIndex;
    private long[] wBuf;
    private int wLen = 0;
    private int wPos = 0;
    private File tempDir;
    private int cacheSize;
    private int partLength;
    private int maxPartRange;

    public LargeLongQueue(File tempDir, int cacheSize, int partLength, int maxPartRange, int initCapacity, int incrementCapacity) throws IOException {
        this.tempDir = tempDir;
        this.cacheSize = cacheSize;
        this.partLength = partLength;
        this.maxPartRange = maxPartRange;
        this.initCapacity = initCapacity;
        this.incrementCapacity = incrementCapacity;
        this.clear();
    }

    public LargeLongSet getDone() {
        return this.done;
    }

    public int size() {
        if (this.rBufIndex == this.wBufIndex) {
            return this.wPos - this.rPos;
        }
        int rc = this.rLen - this.rPos;
        for (int c = this.rBufIndex + 1; c < this.wBufIndex; ++c) {
            rc += ((int[])this.queue.get(c)).length;
        }
        return rc += this.wPos;
    }

    public void clear() throws IOException {
        this.nullDone = false;
        this.done = new LargeLongSet(this.tempDir, this.cacheSize, this.partLength, this.maxPartRange);
        if (this.queue == null) {
            this.queue = new LinkedList();
        }
        if (this.queue.isEmpty()) {
            this.queue.add(new int[this.initCapacity]);
        }
        this.rBufIndex = 0;
        this.rBuf = (long[])this.queue.get(this.rBufIndex);
        this.rLen = this.rBuf.length;
        this.rPos = 0;
        this.wBufIndex = 0;
        this.wBuf = (long[])this.queue.get(this.wBufIndex);
        this.wLen = this.wBuf.length;
        this.wPos = 0;
    }

    public boolean available() {
        return this.rPos != this.wPos || this.rBufIndex != this.wBufIndex;
    }

    public long read() throws IOException {
        long rc = this.rBuf[this.rPos++];
        if (this.rPos >= this.rLen) {
            this.queue.remove(this.rBufIndex);
            this.queue.add(this.rBuf);
            --this.wBufIndex;
            this.rBuf = (long[])this.queue.get(this.rBufIndex);
            this.rPos = 0;
            this.rLen = this.rBuf.length;
        }
        return rc;
    }

    public void read(DataOutputStream out, int len) throws IOException {
        for (int c = 0; c < len; ++c) {
            out.writeLong(this.read());
        }
    }

    public void read(long[] dst, int ofs, int len) throws IOException {
        int end = ofs + len;
        while (ofs < end) {
            dst[ofs++] = this.read();
        }
    }

    public void write(DataInputStream in, int len) throws IOException {
        for (int c = 0; c < len; ++c) {
            this.write(in.readLong());
        }
    }

    protected long[] allocate() {
        return new long[this.incrementCapacity];
    }

    public void write(long i) throws IOException {
        if (i == 0L) {
            if (this.nullDone) {
                return;
            }
            this.nullDone = true;
        } else {
            if (this.done.has(i)) {
                return;
            }
            this.done.put(i);
        }
        this.wBuf[this.wPos++] = i;
        if (this.wPos >= this.wLen) {
            ++this.wBufIndex;
            if (this.wBufIndex < this.queue.size()) {
                this.wBuf = (long[])this.queue.get(this.wBufIndex);
                this.wPos = 0;
                this.wLen = this.wBuf.length;
            } else {
                this.wBuf = this.allocate();
                this.wPos = 0;
                this.wLen = this.wBuf.length;
                this.queue.add(this.wBuf);
            }
        }
    }

    public void write(long[] src, int ofs, int len) throws IOException {
        int end = ofs + len;
        while (ofs < end) {
            this.write(src[ofs++]);
        }
    }

    public void dispose() throws IOException {
        this.queue = null;
        this.rBuf = null;
        this.wBuf = null;
        if (this.done != null) {
            this.done.dispose();
        }
        this.done = null;
    }
}

