/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.large;

import com.spacekiller.util.large.LargeCollection;
import com.spacekiller.util.large.LargeList;
import com.spacekiller.util.large.LargeMap;
import com.spacekiller.util.large.LargeSet;
import com.spacekiller.util.large.LargeSize;
import com.spacekiller.util.large.WrappedLargeCollection;
import com.spacekiller.util.large.WrappedLargeList;
import com.spacekiller.util.large.WrappedLargeMap;
import com.spacekiller.util.large.WrappedLargeSet;
import java.math.BigInteger;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class LargeUtil {
    private static final BigInteger BIG_ZERO = BigInteger.ZERO;
    private static final BigInteger BIG_ONE = BigInteger.ONE;
    private static final BigInteger BIG_MINUS_ONE = BigInteger.valueOf(-1L);
    private static final BigInteger BIG_MAX_INT = BigInteger.valueOf(Integer.MAX_VALUE);
    private static final BigInteger BIG_MAX_LONG = BigInteger.valueOf(Long.MAX_VALUE);

    private LargeUtil() {
    }

    public static LargeCollection getLargeCollection(Collection coll) {
        if (coll == null) {
            return null;
        }
        if (coll instanceof LargeCollection) {
            return (LargeCollection)coll;
        }
        return new WrappedLargeCollection(coll);
    }

    public static LargeList getLargeList(List list) {
        if (list == null) {
            return null;
        }
        if (list instanceof LargeList) {
            return (LargeList)list;
        }
        return new WrappedLargeList(list);
    }

    public static LargeMap getLargeMap(Map map) {
        if (map == null) {
            return null;
        }
        if (map instanceof LargeMap) {
            return (LargeMap)map;
        }
        return new WrappedLargeMap(map);
    }

    public static LargeSet getLargeSet(Set set) {
        if (set == null) {
            return null;
        }
        if (set instanceof LargeSet) {
            return (LargeSet)set;
        }
        return new WrappedLargeSet(set);
    }

    public static long getLongSize(Collection coll) {
        int size = coll.size();
        if (size < Integer.MAX_VALUE) {
            return size;
        }
        if (coll instanceof LargeCollection) {
            LargeCollection large = (LargeCollection)coll;
            return large.longSize();
        }
        return Integer.MAX_VALUE;
    }

    public static long getLongSize(Map map) {
        int size = map.size();
        if (size < Integer.MAX_VALUE) {
            return size;
        }
        if (map instanceof LargeMap) {
            LargeMap large = (LargeMap)map;
            return large.longSize();
        }
        return Integer.MAX_VALUE;
    }

    public static int getExactIntSize(Collection coll) {
        int size = coll.size();
        return size < Integer.MAX_VALUE ? size : -1;
    }

    public static int getExactIntSize(Map map) {
        int size = map.size();
        return size < Integer.MAX_VALUE ? size : -1;
    }

    public static long getExactLongSize(Collection coll) {
        int size = coll.size();
        if (size < Integer.MAX_VALUE) {
            return size;
        }
        if (coll instanceof LargeSize) {
            return ((LargeSize)((Object)coll)).exactLongSize();
        }
        return LargeUtil.getExactLongSize(coll.iterator());
    }

    public static long getExactLongSize(Map map) {
        int size = map.size();
        if (size < Integer.MAX_VALUE) {
            return size;
        }
        if (map instanceof LargeSize) {
            return ((LargeSize)((Object)map)).exactLongSize();
        }
        return LargeUtil.getExactLongSize(map.entrySet().iterator());
    }

    protected static long getExactLongSize(Iterator i) {
        if (!i.hasNext()) {
            return 0L;
        }
        i.next();
        long n = 1L;
        while (i.hasNext()) {
            i.next();
            if (++n >= 0L) continue;
            return -1L;
        }
        return n;
    }

    protected static BigInteger getExactBigSize(Iterator i) {
        if (!i.hasNext()) {
            return BIG_ZERO;
        }
        i.next();
        BigInteger total = BIG_ONE;
        long c = 0L;
        while (i.hasNext()) {
            i.next();
            if (++c < Long.MAX_VALUE) continue;
            total = total.add(BigInteger.valueOf(c));
            c = 0L;
        }
        if (c > 0L) {
            total = total.add(BigInteger.valueOf(c));
        }
        return total;
    }

    public static Object getLongEntry(List list, long index) {
        if (index < 0L) {
            throw new IndexOutOfBoundsException(Long.toString(index));
        }
        if (index < Integer.MAX_VALUE) {
            return list.get((int)index);
        }
        if (list instanceof LargeList) {
            LargeList large = (LargeList)list;
            return large.get(index);
        }
        long count = 0L;
        Iterator i = list.iterator();
        while (i.hasNext()) {
            if (count == index) {
                return i.next();
            }
            i.next();
            ++count;
        }
        throw new IndexOutOfBoundsException(Long.toString(index));
    }

    public static long getLongIndex(List list, Object o) {
        if (list.size() < Integer.MAX_VALUE) {
            return list.indexOf(o);
        }
        if (list instanceof LargeList) {
            LargeList large = (LargeList)list;
            return large.longIndexOf(o);
        }
        if (o == null) {
            long count = 0L;
            Iterator i = list.iterator();
            while (i.hasNext()) {
                if (i.next() == null) {
                    return count;
                }
                ++count;
            }
        } else {
            long count = 0L;
            Iterator i = list.iterator();
            while (i.hasNext()) {
                if (o.equals(i.next())) {
                    return count;
                }
                ++count;
            }
        }
        return -1L;
    }

    public static BigInteger getBigSize(Collection coll) {
        int size = coll.size();
        if (size < 1) {
            return BIG_ZERO;
        }
        if (size < Integer.MAX_VALUE) {
            return BigInteger.valueOf(size);
        }
        if (coll instanceof LargeCollection) {
            return ((LargeCollection)coll).bigSize();
        }
        return BIG_MAX_INT;
    }

    public static BigInteger getBigSize(Map map) {
        int size = map.size();
        if (size < 1) {
            return BIG_ZERO;
        }
        if (size < Integer.MAX_VALUE) {
            return BigInteger.valueOf(size);
        }
        if (map instanceof LargeMap) {
            return ((LargeMap)map).bigSize();
        }
        return BIG_MAX_INT;
    }

    public static BigInteger getExactBigSize(Collection coll) {
        int size = coll.size();
        if (size < Integer.MAX_VALUE) {
            return BigInteger.valueOf(size);
        }
        if (coll instanceof LargeSize) {
            return ((LargeSize)((Object)coll)).exactBigSize();
        }
        return LargeUtil.getExactBigSize(coll.iterator());
    }

    public static BigInteger getExactBigSize(Map map) {
        int size = map.size();
        if (size < Integer.MAX_VALUE) {
            return BigInteger.valueOf(size);
        }
        if (map instanceof LargeSize) {
            return ((LargeSize)((Object)map)).exactBigSize();
        }
        return LargeUtil.getExactBigSize(map.entrySet().iterator());
    }

    public static BigInteger getBigIndex(List list, Object o) {
        if (list.size() < Integer.MAX_VALUE) {
            return BigInteger.valueOf(list.indexOf(o));
        }
        if (list instanceof LargeList) {
            LargeList large = (LargeList)list;
            return large.bigIndexOf(o);
        }
        if (o == null) {
            long count = 0L;
            Iterator i = list.iterator();
            while (i.hasNext()) {
                if (i.next() == null) {
                    return BigInteger.valueOf(count);
                }
                ++count;
            }
        } else {
            long count = 0L;
            Iterator i = list.iterator();
            while (i.hasNext()) {
                if (o.equals(i.next())) {
                    return BigInteger.valueOf(count);
                }
                ++count;
            }
        }
        return BIG_MINUS_ONE;
    }

    public static Object getBigEntry(List list, BigInteger index) {
        if (index.compareTo(BIG_ZERO) < 0) {
            throw new IndexOutOfBoundsException(index.toString());
        }
        if (index.compareTo(BIG_MAX_INT) < 0) {
            return list.get(index.intValue());
        }
        if (list instanceof LargeList) {
            LargeList large = (LargeList)list;
            return large.get(index);
        }
        if (index.compareTo(BIG_MAX_LONG) < 0) {
            return LargeUtil.getLongEntry(list, index.longValue());
        }
        BigInteger bigSize = LargeUtil.getBigSize(list);
        if (index.compareTo(bigSize) < 0) {
            // empty if block
        }
        throw new IndexOutOfBoundsException(index.toString());
    }
}

