/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.large;

import com.spacekiller.util.large.LargeMap;
import com.spacekiller.util.large.LargeRuntimeException;
import com.spacekiller.util.serializer.Serializer;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.util.AbstractMap;

public abstract class SerializedLargeMap
extends AbstractMap
implements LargeMap {
    private static final byte[] EMPTY_ARRAY = new byte[0];
    protected final transient Serializer keySerializer;
    protected final transient Serializer valueSerializer;
    protected final transient Bais bais;
    protected final transient Baos baos;

    public SerializedLargeMap(Serializer keySerializer, Serializer valueSerializer) {
        if (keySerializer == null) {
            throw new NullPointerException("keySerializer");
        }
        this.keySerializer = keySerializer;
        if (valueSerializer == null) {
            throw new NullPointerException("valueSerializer");
        }
        this.valueSerializer = valueSerializer;
        this.bais = new Bais();
        this.baos = new Baos();
    }

    protected Object readKey(byte[] data, int off, int len) {
        try {
            this.bais.reset(data, 0, data.length);
            Object object = this.keySerializer.readObject(this.bais);
            return object;
        }
        catch (Exception e) {
            throw new LargeRuntimeException(e);
        }
        finally {
            this.bais.clear();
        }
    }

    protected byte[] writeKey(Object o) {
        try {
            this.baos.reset();
            this.keySerializer.writeObject(o, this.baos);
            byte[] byArray = this.baos.toByteArray();
            return byArray;
        }
        catch (Exception e) {
            throw new LargeRuntimeException(e);
        }
        finally {
            this.baos.reset();
        }
    }

    protected Object readValue(byte[] data, int off, int len) {
        try {
            this.bais.reset(data, 0, data.length);
            Object object = this.valueSerializer.readObject(this.bais);
            return object;
        }
        catch (Exception e) {
            throw new LargeRuntimeException(e);
        }
        finally {
            this.bais.clear();
        }
    }

    protected byte[] writeValue(Object o) {
        try {
            this.baos.reset();
            this.valueSerializer.writeObject(o, this.baos);
            byte[] byArray = this.baos.toByteArray();
            return byArray;
        }
        catch (Exception e) {
            throw new LargeRuntimeException(e);
        }
        finally {
            this.baos.reset();
        }
    }

    protected class Bais
    extends ByteArrayInputStream {
        public Bais() {
            super(EMPTY_ARRAY);
        }

        protected void reset(byte[] buf, int off, int len) {
            this.buf = buf;
            this.pos = off;
            this.count = off + len;
            this.mark = off;
        }

        protected void clear() {
            this.buf = null;
        }
    }

    protected class Baos
    extends ByteArrayOutputStream {
        public Baos() {
        }

        public Baos(int size) {
            super(size);
        }
    }
}

