/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.serializer;

import com.spacekiller.util.serializer.Serializer;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.StreamCorruptedException;

public class SerializerV2
implements Serializer {
    protected final ObjOutStream oos;
    protected final OutStream os = new OutStream();
    protected final ObjInStream ois;
    protected final InStream is;

    public SerializerV2() throws IOException {
        this.oos = new ObjOutStream(this.os);
        this.is = new InStream();
        this.ois = new ObjInStream(this.is);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeObject(Object o, OutputStream s) throws IOException {
        try {
            this.os.stream = s;
            this.oos.writeObject(o);
            this.oos.flush();
        }
        finally {
            this.os.stream = null;
            this.oos.reset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object readObject(InputStream s) throws IOException, ClassNotFoundException {
        try {
            this.is.stream = s;
            Object object = this.ois.readObject();
            return object;
        }
        finally {
            this.is.stream = null;
        }
    }

    protected class InStream
    extends InputStream {
        protected InputStream stream;

        protected InStream() {
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            InputStream s = this.stream;
            if (s == null) {
                return -1;
            }
            return s.read(b, off, len);
        }

        @Override
        public int read() throws IOException {
            InputStream s = this.stream;
            if (s == null) {
                return -1;
            }
            return s.read();
        }
    }

    protected class OutStream
    extends OutputStream {
        protected OutputStream stream;

        protected OutStream() {
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            OutputStream s = this.stream;
            if (s != null) {
                s.write(b, off, len);
            }
        }

        @Override
        public void write(int b) throws IOException {
            OutputStream s = this.stream;
            if (s != null) {
                s.write(b);
            }
        }
    }

    protected class ObjInStream
    extends ObjectInputStream {
        public ObjInStream(InputStream in) throws IOException {
            super(in);
        }

        @Override
        protected void readStreamHeader() throws IOException, StreamCorruptedException {
        }
    }

    protected class ObjOutStream
    extends ObjectOutputStream {
        public ObjOutStream(OutputStream out) throws IOException {
            super(out);
        }

        @Override
        protected void writeStreamHeader() throws IOException {
        }
    }
}

