/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.buffer;

import com.spacekiller.util.Platform;
import com.spacekiller.util.Tools;
import java.lang.reflect.Method;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Base64Util {
    private static final String JAVA_UTIL_BASE64 = "java.util.Base64";
    private static final String JAVA_UTIL_BASE64ENCODER = "java.util.Base64$Encoder";
    private static final String JAVA_UTIL_BASE64DECODER = "java.util.Base64$Decoder";
    private static final String SUN_MISC_BASE64ENCODER = "sun.misc.BASE64Encoder";
    private static final String SUN_MISC_BASE64DECODER = "sun.misc.BASE64Decoder";
    private static final Logger logger = Logger.getLogger(Base64Util.class.getName());
    private static final Encoder encoder = Base64Util.initBase64Encoder();
    private static final Decoder decoder = Base64Util.initBase64Decoder();

    private Base64Util() {
    }

    public static Encoder getEncoder() {
        return encoder;
    }

    public static Decoder getDecoder() {
        return decoder;
    }

    private static Encoder initBase64Encoder() {
        Throwable jdk8Error = null;
        if (Platform.isJavaVersionCompatible((double)1.8)) {
            try {
                return new Java8Encoder();
            }
            catch (Throwable e) {
                jdk8Error = e;
            }
        }
        try {
            return new Java1Encoder();
        }
        catch (Throwable e) {
            if (jdk8Error != null) {
                logger.log(Level.WARNING, jdk8Error.getMessage(), jdk8Error);
            }
            logger.log(Level.SEVERE, e.getMessage(), e);
            return null;
        }
    }

    private static Decoder initBase64Decoder() {
        Throwable jdk8Error = null;
        if (Platform.isJavaVersionCompatible((double)1.8)) {
            try {
                return new Java8Decoder();
            }
            catch (Throwable e) {
                jdk8Error = e;
            }
        }
        try {
            return new Java1Decoder();
        }
        catch (Throwable e) {
            if (jdk8Error != null) {
                logger.log(Level.WARNING, jdk8Error.getMessage(), jdk8Error);
            }
            logger.log(Level.SEVERE, e.getMessage(), e);
            return null;
        }
    }

    private static class Java1Decoder
    extends Decoder {
        private final Object base64DecoderObject;
        private final Method decodeStringMethod;

        protected Java1Decoder() throws Exception {
            Class<?> sunMiscBase64DecoderClass = Class.forName(Base64Util.SUN_MISC_BASE64DECODER);
            this.base64DecoderObject = Tools.newInstance(sunMiscBase64DecoderClass);
            this.decodeStringMethod = sunMiscBase64DecoderClass.getMethod("decode", String.class);
        }

        @Override
        public byte[] decode(String src) throws Exception {
            return (byte[])this.decodeStringMethod.invoke(this.base64DecoderObject, src);
        }
    }

    private static class Java1Encoder
    extends Encoder {
        private final Object base64EncoderObject;
        private final Method encodeStringMethod;

        protected Java1Encoder() throws Exception {
            Class<?> sunMiscBase64EncoderClass = Class.forName(Base64Util.SUN_MISC_BASE64ENCODER);
            this.base64EncoderObject = Tools.newInstance(sunMiscBase64EncoderClass);
            this.encodeStringMethod = sunMiscBase64EncoderClass.getMethod("encode", byte[].class);
        }

        @Override
        public String encodeToString(byte[] src) throws Exception {
            return (String)this.encodeStringMethod.invoke(this.base64EncoderObject, new Object[]{src});
        }
    }

    private static class Java8Decoder
    extends Decoder {
        private final Object base64DecoderObject;
        private final Method decodeStringMethod;

        protected Java8Decoder() throws Exception {
            Class<?> javaUtilBase64Class = Class.forName(Base64Util.JAVA_UTIL_BASE64);
            Class<?> javaUtilBase64DecoderClass = Class.forName(Base64Util.JAVA_UTIL_BASE64DECODER);
            Method getDecoderMethod = javaUtilBase64Class.getMethod("getDecoder", new Class[0]);
            this.base64DecoderObject = getDecoderMethod.invoke(null, new Object[0]);
            this.decodeStringMethod = javaUtilBase64DecoderClass.getMethod("decode", String.class);
        }

        @Override
        public byte[] decode(String src) throws Exception {
            return (byte[])this.decodeStringMethod.invoke(this.base64DecoderObject, src);
        }
    }

    private static class Java8Encoder
    extends Encoder {
        private final Object base64EncoderObject;
        private final Method encodeStringMethod;

        protected Java8Encoder() throws Exception {
            Class<?> javaUtilBase64Class = Class.forName(Base64Util.JAVA_UTIL_BASE64);
            Class<?> javaUtilBase64EncoderClass = Class.forName(Base64Util.JAVA_UTIL_BASE64ENCODER);
            Method getEncoderMethod = javaUtilBase64Class.getMethod("getEncoder", new Class[0]);
            this.base64EncoderObject = getEncoderMethod.invoke(null, new Object[0]);
            this.encodeStringMethod = javaUtilBase64EncoderClass.getMethod("encodeToString", byte[].class);
        }

        @Override
        public String encodeToString(byte[] src) throws Exception {
            return (String)this.encodeStringMethod.invoke(this.base64EncoderObject, new Object[]{src});
        }
    }

    public static abstract class Decoder {
        public abstract byte[] decode(String var1) throws Exception;
    }

    public static abstract class Encoder {
        public abstract String encodeToString(byte[] var1) throws Exception;
    }
}

