/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.buffer;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Vector;

public final class RandomAccessByteBuffer {
    private int capacity = 0;
    private Vector data = new Vector();
    private int bufCount = 0;
    private byte[] buf;
    private int bufId = 0;
    private int bufOfs = 0;
    private int bufLen = 0;
    private int bufPos = 0;
    private int incrementSize = 1024;
    private ByteBufferInputStream in = new ByteBufferInputStream();
    private ByteBufferOutputStream out = new ByteBufferOutputStream();

    public RandomAccessByteBuffer() {
        this(1024);
    }

    public RandomAccessByteBuffer(int incrementSize) {
        this.incrementSize = incrementSize;
        this.buf = new byte[incrementSize];
        this.data.add(this.buf);
        this.bufId = 0;
        this.bufOfs = 0;
        this.bufLen = this.buf.length;
        this.bufPos = 0;
        this.capacity = this.buf.length;
        this.bufCount = this.data.size();
    }

    public InputStream getInputStream() {
        return this.in;
    }

    public OutputStream getOutputStream() {
        return this.out;
    }

    public int getPosition() {
        return this.bufOfs + this.bufPos;
    }

    protected boolean nextBuffer(boolean allocate) {
        if (this.bufId + 1 >= this.bufCount) {
            if (allocate) {
                ++this.bufId;
                this.bufOfs += this.bufLen;
                this.buf = new byte[this.incrementSize];
                this.data.add(this.buf);
                ++this.bufCount;
                this.capacity += this.buf.length;
                this.bufLen = this.buf.length;
                this.bufPos = 0;
                return true;
            }
            return false;
        }
        ++this.bufId;
        this.bufOfs += this.bufLen;
        this.buf = (byte[])this.data.get(this.bufId);
        this.bufLen = this.buf.length;
        this.bufPos = 0;
        return true;
    }

    protected boolean prevBuffer() {
        if (this.bufId < 1) {
            return false;
        }
        --this.bufId;
        this.buf = (byte[])this.data.get(this.bufId);
        this.bufLen = this.buf.length;
        this.bufOfs -= this.bufLen;
        this.bufPos = 0;
        return true;
    }

    public byte read() {
        byte rc = this.buf[this.bufPos++];
        if (this.bufPos >= this.bufLen) {
            this.nextBuffer(false);
        }
        return rc;
    }

    public void read(byte[] b, int ofs, int len) {
        while (len > 0) {
            int num = this.bufLen - this.bufPos;
            if (num > len) {
                num = len;
            }
            System.arraycopy(this.buf, this.bufPos, b, ofs, num);
            ofs += num;
            this.bufPos += num;
            if (this.bufPos < this.bufLen || this.nextBuffer(false) || (len -= num) <= 0) continue;
            throw new ArrayIndexOutOfBoundsException(this.bufOfs + this.bufLen);
        }
    }

    public void read(OutputStream out, int len) throws IOException {
        while (len > 0) {
            int num = this.bufLen - this.bufPos;
            if (num > len) {
                num = len;
            }
            out.write(this.buf, this.bufPos, num);
            this.bufPos += num;
            if (this.bufPos < this.bufLen || this.nextBuffer(false) || (len -= num) <= 0) continue;
            throw new ArrayIndexOutOfBoundsException(this.bufOfs + this.bufLen);
        }
    }

    public void seek(int ofs) {
        if (ofs < 0) {
            throw new ArrayIndexOutOfBoundsException(ofs);
        }
        if (ofs >= this.bufOfs) {
            while (ofs >= this.bufOfs + this.bufLen) {
                this.nextBuffer(true);
            }
        } else {
            while (this.prevBuffer() && ofs <= this.bufOfs) {
            }
        }
        this.bufPos = ofs - this.bufOfs;
    }

    public void write(byte[] b, int ofs, int len) {
        while (len > 0) {
            int num = this.bufLen - this.bufPos;
            if (num > len) {
                num = len;
            }
            System.arraycopy(b, ofs, this.buf, this.bufPos, num);
            ofs += num;
            len -= num;
            this.bufPos += num;
            if (this.bufPos < this.bufLen) continue;
            this.nextBuffer(true);
        }
    }

    public void write(byte b) {
        this.buf[this.bufPos++] = b;
        if (this.bufPos >= this.bufLen) {
            this.nextBuffer(true);
        }
    }

    public void write(InputStream in, int len) throws IOException {
        while (len > 0) {
            int num = this.bufLen - this.bufPos;
            if (num > len) {
                num = len;
            }
            if ((num = in.read(this.buf, this.bufPos, num)) < 0) {
                throw new EOFException();
            }
            len -= num;
            this.bufPos += num;
            if (this.bufPos < this.bufLen) continue;
            this.nextBuffer(true);
        }
    }

    public void setBuffer(byte[] b, int ofs, int len) {
        this.data.clear();
        this.data.add(b);
        this.bufCount = 1;
        this.buf = b;
        this.bufId = 0;
        this.bufOfs = 0;
        this.bufLen = ofs + len;
        this.bufPos = ofs;
        this.capacity = this.bufLen;
    }

    public long capacity() {
        return this.capacity;
    }

    private class ByteBufferInputStream
    extends InputStream {
        private ByteBufferInputStream() {
        }

        @Override
        public int read() throws IOException {
            return RandomAccessByteBuffer.this.read() & 0xFF;
        }

        @Override
        public int read(byte[] b) {
            RandomAccessByteBuffer.this.read(b, 0, b.length);
            return b.length;
        }

        @Override
        public int read(byte[] b, int ofs, int len) {
            RandomAccessByteBuffer.this.read(b, ofs, len);
            return len;
        }
    }

    private class ByteBufferOutputStream
    extends OutputStream {
        private ByteBufferOutputStream() {
        }

        @Override
        public void write(byte[] b) throws IOException {
            RandomAccessByteBuffer.this.write(b, 0, b.length);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            RandomAccessByteBuffer.this.write(b, off, len);
        }

        @Override
        public void write(int b) throws IOException {
            RandomAccessByteBuffer.this.write((byte)b);
        }
    }
}

