/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.buffer;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.UTFDataFormatException;

public final class UTFBuffer {
    private int CHAR_BUF_SIZE;
    private char[] cbuf;
    private byte[] buf;

    public UTFBuffer() {
        this(1024, 2048);
    }

    public UTFBuffer(int charBufferSize, int initByteBuffer) {
        this.CHAR_BUF_SIZE = charBufferSize;
        this.cbuf = new char[this.CHAR_BUF_SIZE];
        this.buf = new byte[initByteBuffer];
    }

    public long getUTFLength(String s) {
        int csize;
        int len = s.length();
        long utflen = 0L;
        for (int off = 0; off < len; off += csize) {
            csize = Math.min(len - off, this.CHAR_BUF_SIZE);
            s.getChars(off, off + csize, this.cbuf, 0);
            for (int cpos = 0; cpos < csize; ++cpos) {
                char c = this.cbuf[cpos];
                if (c >= '\u0001' && c <= '\u007f') {
                    ++utflen;
                    continue;
                }
                if (c > '\u07ff') {
                    utflen += 3L;
                    continue;
                }
                utflen += 2L;
            }
        }
        return utflen;
    }

    public static void readUTF(byte[] buf, int ofs, StringBuffer sbuf, int utflen) throws IOException {
        int end = ofs + utflen;
        block5: while (ofs < end) {
            int b1 = buf[ofs++] & 0xFF;
            switch (b1 >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    sbuf.append((char)b1);
                    continue block5;
                }
                case 12: 
                case 13: {
                    byte b2;
                    if (utflen < 2) {
                        throw new UTFDataFormatException();
                    }
                    if (((b2 = buf[ofs++]) & 0xC0) != 128) {
                        throw new UTFDataFormatException();
                    }
                    sbuf.append((char)((b1 & 0x1F) << 6 | (b2 & 0x3F) << 0));
                    continue block5;
                }
                case 14: {
                    if (utflen < 3) {
                        if (utflen == 2) {
                            ++ofs;
                        }
                        throw new UTFDataFormatException();
                    }
                    byte b2 = buf[ofs++];
                    byte b3 = buf[ofs++];
                    if ((b2 & 0xC0) != 128 || (b3 & 0xC0) != 128) {
                        throw new UTFDataFormatException();
                    }
                    sbuf.append((char)((b1 & 0xF) << 12 | (b2 & 0x3F) << 6 | (b3 & 0x3F) << 0));
                    continue block5;
                }
            }
            throw new UTFDataFormatException();
        }
    }

    public void readUTF(DataInput in, StringBuffer sbuf, int utflen) throws IOException {
        if (utflen > this.buf.length) {
            this.buf = new byte[Math.max(this.buf.length * 2, utflen)];
        }
        in.readFully(this.buf, 0, utflen);
        UTFBuffer.readUTF(this.buf, 0, sbuf, utflen);
    }

    public int writeUTF(String s, byte[] buf, int ofs) throws IOException {
        int csize;
        int size = ofs;
        int len = s.length();
        for (int off = 0; off < len; off += csize) {
            csize = Math.min(len - off, this.CHAR_BUF_SIZE);
            s.getChars(off, off + csize, this.cbuf, 0);
            for (int cpos = 0; cpos < csize; ++cpos) {
                char c = this.cbuf[cpos];
                if (c <= '\u007f' && c != '\u0000') {
                    buf[size++] = (byte)c;
                    continue;
                }
                if (c > '\u07ff') {
                    buf[size + 2] = (byte)(0x80 | c >> 0 & 0x3F);
                    buf[size + 1] = (byte)(0x80 | c >> 6 & 0x3F);
                    buf[size + 0] = (byte)(0xE0 | c >> 12 & 0xF);
                    size += 3;
                    continue;
                }
                buf[size + 1] = (byte)(0x80 | c >> 0 & 0x3F);
                buf[size + 0] = (byte)(0xC0 | c >> 6 & 0x1F);
                size += 2;
            }
        }
        return size - ofs;
    }

    public int writeUTF(String s, DataOutput out) throws IOException {
        int len = (int)this.getUTFLength(s);
        if (len > this.buf.length) {
            this.buf = new byte[Math.max(this.buf.length * 2, len)];
        }
        this.writeUTF(s, this.buf, 0);
        out.write(this.buf, 0, len);
        return len;
    }

    public byte[] getUTF(String s, int[] dstLen) throws IOException {
        int len = (int)this.getUTFLength(s);
        if (len > this.buf.length) {
            this.buf = new byte[Math.max(this.buf.length * 2, len)];
        }
        this.writeUTF(s, this.buf, 0);
        dstLen[0] = len;
        return this.buf;
    }
}

