/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.platform;

import com.spacekiller.util.Parameter;
import com.spacekiller.util.PluginDescriptor;
import com.spacekiller.util.beans.ClipboardManager;
import com.spacekiller.util.platform.AbstractPlatform;
import com.spacekiller.util.platform.PluginLoader;
import com.spacekiller.util.platform.SupportClipboard;
import com.spacekiller.util.platform.SupportPluginLoader;
import java.util.Iterator;
import java.util.LinkedList;

public abstract class AbstractLauncher {
    private AbstractPlatform platform;

    protected AbstractLauncher() {
    }

    protected final AbstractPlatform getPlatform() {
        return this.platform;
    }

    protected void setPlatform(AbstractPlatform platform) {
        this.platform = platform;
    }

    protected PluginDescriptor[] lookupPluginDescriptors(ClassLoader[] loaders) {
        Class<PluginDescriptor> type = PluginDescriptor.class;
        PluginLoader pluginLoader = SupportPluginLoader.createPluginLoader(loaders);
        Iterator pluginDescrIter = pluginLoader.load(type);
        PluginDescriptor[] pluginDescrArray = this.lookupPluginDescriptors(pluginDescrIter);
        return pluginDescrArray;
    }

    protected PluginDescriptor[] lookupPluginDescriptors(Iterator pluginDescrIter) {
        Iterator serviceIter = AbstractPlatform.lookupServicesImpl(PluginDescriptor.class, pluginDescrIter);
        LinkedList<PluginDescriptor> pluginDescrList = new LinkedList<PluginDescriptor>();
        if (serviceIter != null) {
            while (serviceIter.hasNext()) {
                PluginDescriptor pluginDescriptor = (PluginDescriptor)serviceIter.next();
                if (pluginDescriptor == null) continue;
                pluginDescrList.add(pluginDescriptor);
            }
        }
        return pluginDescrList.toArray(new PluginDescriptor[pluginDescrList.size()]);
    }

    protected ClipboardManager createClipboardManager() {
        return SupportClipboard.createClipboardManager();
    }

    protected class ConstructorParameter
    implements Parameter {
        private String typeName;
        private String extensionId;

        public ConstructorParameter(String typeName, String extensionId) {
            this.setTypeName(typeName);
            this.setExtensionId(extensionId);
        }

        protected String getExtensionId() {
            return this.extensionId;
        }

        protected void setExtensionId(String extensionId) {
            this.extensionId = extensionId;
        }

        protected String getTypeName() {
            return this.typeName;
        }

        protected void setTypeName(String typeName) {
            this.typeName = typeName;
        }

        public Class getType() {
            try {
                return Class.forName(this.typeName);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        public Object getValue() {
            try {
                if (this.extensionId != null && this.extensionId.length() > 0) {
                    return AbstractLauncher.this.platform.getExtensionInstance(this.extensionId);
                }
                return null;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        public void setValue(Object o) {
            throw new UnsupportedOperationException();
        }
    }
}

