/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.platform;

import com.spacekiller.util.FileContext;
import com.spacekiller.util.FileType;
import com.spacekiller.util.FileTypeRegistry;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class DefaultFileTypeRegistry
implements FileTypeRegistry {
    private List fileTypeList = new ArrayList();
    private Map fileTypesByExtension = new HashMap();
    private List specialFileTypes = new ArrayList();

    public synchronized void registerFileType(FileType type) {
        String[] exts;
        if (type == null) {
            return;
        }
        if (this.fileTypeList.contains(type)) {
            return;
        }
        this.fileTypeList.add(type);
        boolean isSpecial = true;
        String ext = type.getFileExtension();
        if (ext != null && (ext = ext.trim().toLowerCase()).length() > 0) {
            this.registerFileTypeExtension(ext, type);
            isSpecial = false;
        }
        if ((exts = type.getFileExtensions()) != null) {
            for (int c = 0; c < exts.length; ++c) {
                String x = exts[c];
                if (x == null || (x = x.trim().toLowerCase()).length() <= 0) continue;
                this.registerFileTypeExtension(x, type);
                isSpecial = false;
            }
        }
        if (isSpecial) {
            this.specialFileTypes.add(type);
        }
    }

    protected synchronized void registerFileTypeExtension(String ext, FileType type) {
        if (type == null || ext == null) {
            return;
        }
        Object obj = this.fileTypesByExtension.get(ext);
        if (obj == null) {
            this.fileTypesByExtension.put(ext, type);
            return;
        }
        if (obj instanceof FileType) {
            FileType otherType = (FileType)obj;
            if (otherType == type) {
                return;
            }
            LinkedList<FileType> typeList = new LinkedList<FileType>();
            typeList.add(otherType);
            typeList.add(type);
            this.fileTypesByExtension.put(ext, typeList);
            return;
        }
        if (obj instanceof List) {
            List typeList = (List)obj;
            if (!typeList.contains(type)) {
                typeList.add(type);
            }
            return;
        }
    }

    public synchronized void unregisterFileType(FileType type) {
        if (type == null) {
            return;
        }
        if (!this.fileTypeList.remove(type)) {
            return;
        }
    }

    public synchronized FileType[] getFileTypes() {
        return this.fileTypeList.toArray(new FileType[this.fileTypeList.size()]);
    }

    public synchronized FileType getFileType(File file) {
        if (file == null) {
            return null;
        }
        String ext = file.getName().toLowerCase();
        while (ext.length() > 0) {
            int k;
            Object obj = this.fileTypesByExtension.get(ext);
            if (obj != null) {
                List typeList;
                if (obj instanceof FileType) {
                    return (FileType)obj;
                }
                if (obj instanceof List && !(typeList = (List)obj).isEmpty()) {
                    return (FileType)typeList.get(0);
                }
            }
            if ((k = ext.indexOf(".", 1)) < 0) break;
            ext = ext.substring(k);
        }
        if (!this.specialFileTypes.isEmpty()) {
            int num = this.specialFileTypes.size();
            for (int c = 0; c < num; ++c) {
                FileType type = (FileType)this.specialFileTypes.get(c);
                if (!type.matches(file)) continue;
                return type;
            }
        }
        return null;
    }

    public FileType getFileType(FileContext context) {
        if (context == null) {
            return null;
        }
        return this.getFileType(context.getFile());
    }

    public FileType getFileType(String path) {
        if (path == null) {
            return null;
        }
        return this.getFileType(new File(path));
    }

    public synchronized FileType[] getFileTypes(File file) {
        if (file == null) {
            return null;
        }
        String ext = file.getName().toLowerCase();
        while (ext.length() > 0) {
            int k;
            Object obj = this.fileTypesByExtension.get(ext);
            if (obj != null) {
                List typeList;
                if (obj instanceof FileType) {
                    return new FileType[]{(FileType)obj};
                }
                if (obj instanceof List && !(typeList = (List)obj).isEmpty()) {
                    return typeList.toArray(new FileType[typeList.size()]);
                }
            }
            if ((k = ext.indexOf(".", 1)) < 0) break;
            ext = ext.substring(k);
        }
        if (!this.specialFileTypes.isEmpty()) {
            int num = this.specialFileTypes.size();
            for (int c = 0; c < num; ++c) {
                FileType type = (FileType)this.specialFileTypes.get(c);
                if (!type.matches(file)) continue;
                return new FileType[]{type};
            }
        }
        return null;
    }

    public FileType[] getFileTypes(FileContext context) {
        if (context == null) {
            return null;
        }
        return this.getFileTypes(context.getFile());
    }

    public FileType[] getFileTypes(String path) {
        if (path == null) {
            return null;
        }
        return this.getFileTypes(new File(path));
    }
}

