/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.platform;

import com.spacekiller.util.platform.PluginLoader;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DefaultPluginLoader
implements PluginLoader {
    private static final Logger logger = Logger.getLogger(DefaultPluginLoader.class.getName());
    protected static final String META_INF_SERVICES_PREFIX = "META-INF/services/";
    private ClassLoader[] loaders;

    public DefaultPluginLoader(ClassLoader[] loaders) {
        this.loaders = loaders;
    }

    @Override
    public void reload(Class type) {
    }

    @Override
    public Iterator load(Class type) {
        String path = META_INF_SERVICES_PREFIX + type.getName();
        return this.load(type, this.loaders, path);
    }

    protected Iterator load(Class type, ClassLoader[] loaders, String path) {
        int num = loaders.length;
        LinkedList<PluginIterator> iteratorList = new LinkedList<PluginIterator>();
        HashSet processed = new HashSet();
        for (int i = 0; i < num; ++i) {
            Enumeration<URL> resources;
            ClassLoader loader = loaders[i];
            if (loader == null) continue;
            try {
                resources = loader.getResources(path);
            }
            catch (Throwable e) {
                logger.log(Level.SEVERE, e.getMessage(), e);
                continue;
            }
            if (resources == null) continue;
            ResourceIterator resourceIterator = new ResourceIterator(resources);
            PluginIterator pluginIterator = new PluginIterator(type, loader, processed, resourceIterator);
            iteratorList.add(pluginIterator);
        }
        MultiIterator multiIterator = new MultiIterator(iteratorList.iterator());
        return multiIterator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Iterator parsePluginClassNames(InputStream in) throws IOException {
        LinkedList<String> classNameList = null;
        BufferedReader reader = new BufferedReader(new InputStreamReader(in));
        try {
            String s;
            while ((s = reader.readLine()) != null) {
                if (s.length() < 1 || s.charAt(0) == '#' || (s = s.trim()).length() < 1) continue;
                if (classNameList == null) {
                    classNameList = new LinkedList<String>();
                }
                classNameList.add(s);
            }
        }
        finally {
            reader.close();
        }
        if (classNameList == null) {
            return null;
        }
        return classNameList.iterator();
    }

    protected class PluginIterator
    implements Iterator {
        private Class type;
        private ClassLoader loader;
        private Set processed;
        private Iterator resources;
        private URL resource;
        private Iterator classNames;
        private Object next;

        public PluginIterator(Class type, ClassLoader loader, Set processed, Iterator resources) {
            this.type = type;
            this.loader = loader;
            this.processed = processed;
            this.resources = resources;
        }

        @Override
        public boolean hasNext() {
            if (this.next == null) {
                this.iterate(false);
            }
            return this.next != null;
        }

        public Object next() {
            if (this.next == null) {
                this.iterate(true);
            }
            Object result = this.next;
            this.next = null;
            return result;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void iterate(boolean force) {
            this.resource = null;
            while (true) {
                URL url;
                if (this.classNames != null) {
                    if (!this.classNames.hasNext()) {
                        this.classNames = null;
                    } else {
                        Object plugin;
                        Class<?> clazz;
                        String className = (String)this.classNames.next();
                        try {
                            boolean initialize = false;
                            clazz = Class.forName(className, initialize, this.loader);
                        }
                        catch (Throwable e) {
                            if (!force) {
                                String msg = "Could not load class \"" + className + "\" specified in resource " + this.resource + ": " + e;
                                logger.log(Level.SEVERE, msg);
                                continue;
                            }
                            throw new RuntimeException(e);
                        }
                        if (!this.processed.add(clazz)) continue;
                        if (!this.type.isAssignableFrom(clazz)) {
                            throw new ClassCastException(String.valueOf(clazz) + " is not compatible with " + String.valueOf(this.type));
                        }
                        try {
                            plugin = clazz.newInstance();
                        }
                        catch (Throwable e) {
                            throw new RuntimeException(e);
                        }
                        this.next = plugin;
                        return;
                    }
                }
                if (!this.resources.hasNext()) {
                    this.resource = null;
                    if (force) {
                        throw new NoSuchElementException();
                    }
                    return;
                }
                Object element = this.resources.next();
                this.resource = url = (URL)element;
                try {
                    InputStream in = url.openStream();
                    try {
                        this.classNames = DefaultPluginLoader.this.parsePluginClassNames(in);
                        continue;
                    }
                    finally {
                        in.close();
                        continue;
                    }
                }
                catch (Throwable e) {
                    logger.log(Level.SEVERE, "Failed to read resource " + url + ": " + e.getMessage(), e);
                    continue;
                }
                break;
            }
        }
    }

    protected static class MultiIterator
    implements Iterator {
        private Iterator iterators;
        private Iterator iterator;

        public MultiIterator(Iterator iterators) {
            this.iterators = iterators;
            this.iterator = null;
        }

        @Override
        public boolean hasNext() {
            while (true) {
                if (this.iterator == null) {
                    if (!this.iterators.hasNext()) {
                        return false;
                    }
                    this.iterator = (Iterator)this.iterators.next();
                    continue;
                }
                if (this.iterator.hasNext()) {
                    return true;
                }
                this.iterator = null;
            }
        }

        public Object next() {
            while (true) {
                if (this.iterator == null) {
                    if (!this.iterators.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    this.iterator = (Iterator)this.iterators.next();
                    continue;
                }
                if (this.iterator.hasNext()) {
                    return this.iterator.next();
                }
                this.iterator = null;
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    protected static class ResourceIterator
    implements Iterator {
        private Enumeration resources;

        protected ResourceIterator(Enumeration resources) {
            this.resources = resources;
        }

        @Override
        public boolean hasNext() {
            return this.resources.hasMoreElements();
        }

        public Object next() {
            return this.resources.nextElement();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

