/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.platform;

import com.spacekiller.util.platform.PropertyReader;
import com.spacekiller.util.platform.PropertyWriter;
import java.awt.Rectangle;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;

public class DefaultPropertySupport {
    protected static final String TYPE_OBJECT = "object";
    protected static final String TYPE_RECTANGLE = "rectangle";
    protected static final RectangleWriter rectangleWriter = new RectangleWriter();
    protected static final RectangleReader rectangleReader = new RectangleReader();

    private DefaultPropertySupport() {
    }

    public static String formatRectangle(Rectangle o) {
        return "" + o.x + "," + o.y + "," + o.width + "," + o.height;
    }

    public static Object parseRectangle(String s) {
        int[] arr = DefaultPropertySupport.parseIntArray(s);
        if (arr != null && arr.length >= 4) {
            return new Rectangle(arr[0], arr[1], arr[2], arr[3]);
        }
        return s;
    }

    public static int[] parseIntArray(String s) {
        String[] arr = DefaultPropertySupport.split(s, ',');
        if (arr == null) {
            return null;
        }
        int n = arr.length;
        int[] x = new int[n];
        for (int i = 0; i < n; ++i) {
            try {
                x[i] = Integer.parseInt(arr[i].trim());
                continue;
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        return x;
    }

    public static String[] split(String str, char sep) {
        int i;
        int len = str.length();
        int num = 0;
        for (i = 0; i < len; ++i) {
            if (str.charAt(i) != sep) continue;
            ++num;
        }
        String[] arr = new String[num + 1];
        int x = 0;
        int o = 0;
        for (i = 0; i < len; ++i) {
            if (str.charAt(i) != sep) continue;
            arr[o++] = str.substring(x, i);
            x = i + 1;
        }
        arr[num] = str.substring(x);
        return arr;
    }

    protected static class RectangleReader
    implements PropertyReader {
        protected RectangleReader() {
        }

        @Override
        public void read(Properties props, String key, String value, Map<String, Object> map) throws IOException, ClassNotFoundException {
            map.put(key, DefaultPropertySupport.parseRectangle(value));
        }
    }

    protected static class RectangleWriter
    implements PropertyWriter {
        protected RectangleWriter() {
        }

        @Override
        public void write(String key, Object value, Properties props) {
            props.setProperty(key + '(' + DefaultPropertySupport.TYPE_RECTANGLE + ')', DefaultPropertySupport.formatRectangle((Rectangle)value));
        }
    }
}

