/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.platform;

import com.spacekiller.util.buffer.Base64Util;
import com.spacekiller.util.platform.DefaultPropertySupport;
import com.spacekiller.util.platform.PropertyWriter;
import java.awt.Rectangle;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class DefaultPropertyWriter
implements PropertyWriter {
    protected static final ToStringWriter toStringWriter = new ToStringWriter();
    protected static final ObjectWriter objectWriter = new ObjectWriter();
    protected Map<Class, PropertyWriter> writers = new HashMap<Class, PropertyWriter>();

    public DefaultPropertyWriter() {
        this.initializeWriters(this.writers);
    }

    protected void initializeWriters(Map<Class, PropertyWriter> map) {
        this.initializeDefaultWriters(map);
    }

    protected void initializeDefaultWriters(Map<Class, PropertyWriter> map) {
        map.put(Boolean.class, toStringWriter);
        map.put(Byte.class, toStringWriter);
        map.put(Character.class, toStringWriter);
        map.put(Short.class, toStringWriter);
        map.put(Integer.class, toStringWriter);
        map.put(Long.class, toStringWriter);
        map.put(Float.class, toStringWriter);
        map.put(Double.class, toStringWriter);
        map.put(String.class, toStringWriter);
        map.put(Rectangle.class, DefaultPropertySupport.rectangleWriter);
    }

    @Override
    public void write(String key, Object value, Properties props) throws IOException {
        if (value == null) {
            return;
        }
        Class<?> type = value.getClass();
        PropertyWriter writer = this.writers.get(type);
        if (writer != null) {
            writer.write(key, value, props);
        } else {
            objectWriter.write(key, value, props);
        }
    }

    protected static class ObjectWriter
    implements PropertyWriter {
        protected ObjectWriter() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void write(String key, Object value, Properties props) throws IOException {
            String s;
            byte[] data;
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            try {
                ObjectOutputStream oos = new ObjectOutputStream(baos);
                try {
                    oos.writeObject(value);
                    oos.flush();
                    data = baos.toByteArray();
                }
                finally {
                    oos.close();
                }
            }
            finally {
                baos.close();
            }
            try {
                s = Base64Util.getEncoder().encodeToString(data);
            }
            catch (IOException e) {
                throw e;
            }
            catch (Exception e) {
                throw new IOException(e);
            }
            props.setProperty(key + '(' + "object" + ')', s);
        }
    }

    protected static class ToStringWriter
    implements PropertyWriter {
        protected ToStringWriter() {
        }

        @Override
        public void write(String key, Object value, Properties props) {
            props.setProperty(key, value.toString());
        }
    }
}

