/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.platform;

import com.spacekiller.util.ListenerList;
import com.spacekiller.util.ThreadListener;
import com.spacekiller.util.ThreadManager;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DefaultThreadManager
implements ThreadManager {
    private static final Logger logger = Logger.getLogger(DefaultThreadManager.class.getName());
    private Set threads = new HashSet();
    private List threadList = new LinkedList();
    private ListenerList<ThreadListener> listeners = new ListenerList(ThreadListener.class);

    public synchronized void registerThread(Thread thread) {
        if (thread == null) {
            return;
        }
        if (this.threads.add(thread)) {
            this.threadList.add(thread);
            if (logger.isLoggable(Level.FINER)) {
                logger.finer("Thread registered: " + thread);
            }
            this.fireThreadRegistered(thread);
        }
    }

    public synchronized void unregisterThread(Thread thread) {
        if (thread == null) {
            return;
        }
        if (this.threads.remove(thread)) {
            this.threadList.remove(thread);
            if (logger.isLoggable(Level.FINER)) {
                logger.finer("Thread unregistered: " + thread);
            }
            this.fireThreadUnregistered(thread);
        }
    }

    public synchronized int getThreadCount() {
        return this.threadList.size();
    }

    public synchronized Thread[] getThreads() {
        return this.threadList.toArray(new Thread[this.threadList.size()]);
    }

    public synchronized void addThreadListener(ThreadListener listener) {
        if (listener == null) {
            return;
        }
        this.listeners.add((Object)listener);
    }

    public synchronized void removeThreadListener(ThreadListener listener) {
        if (listener == null) {
            return;
        }
        this.listeners.remove((Object)listener);
    }

    protected synchronized void fireThreadRegistered(Thread thread) {
        for (ThreadListener l : (ThreadListener[])this.listeners.array()) {
            l.threadRegistered(thread);
        }
    }

    protected synchronized void fireThreadUnregistered(Thread thread) {
        for (ThreadListener l : (ThreadListener[])this.listeners.array()) {
            l.threadUnregistered(thread);
        }
    }
}

