/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.platform;

import com.spacekiller.util.ConfigNode;
import com.spacekiller.util.Parameter;
import java.util.ArrayList;
import java.util.List;

public class RuntimeConfigNode
implements ConfigNode {
    private String name;
    private String type;
    private String className;
    private Object value;
    private String extension;
    private String bean;
    private List children;
    private List parameters;

    public RuntimeConfigNode(ConfigNode node) {
        int c;
        this.name = node.getName();
        this.type = node.getType();
        this.className = node.getClassName();
        this.value = node.getValue();
        this.extension = node.getExtension();
        this.bean = node.getBean();
        int num = node.getChildCount();
        if (num > 0) {
            this.children = new ArrayList();
            for (c = 0; c < num; ++c) {
                ConfigNode child = node.getChildAt(c);
                if (child == null) continue;
                RuntimeConfigNode rn = new RuntimeConfigNode(child);
                this.children.add(rn);
            }
        }
        if ((num = node.getParameterCount()) > 0) {
            this.parameters = new ArrayList();
            for (c = 0; c < num; ++c) {
                this.parameters.add(node.getParameterAt(c));
            }
        }
    }

    public String getClassName() {
        return this.className;
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    public Object getValue() {
        return this.value;
    }

    public ConfigNode getChildAt(int index) {
        return (ConfigNode)this.children.get(index);
    }

    public int getChildCount() {
        return this.children == null ? 0 : this.children.size();
    }

    public Parameter getParameterAt(int i) {
        return (Parameter)this.parameters.get(i);
    }

    public int getParameterCount() {
        return this.parameters == null ? 0 : this.parameters.size();
    }

    public String toString() {
        String info = "";
        int params = this.getParameterCount();
        for (int c = 0; c < params; ++c) {
            Parameter p = this.getParameterAt(c);
            info = info + p.getValue() + ", ";
        }
        int n = this.getChildCount();
        if (n > 0) {
            info = info + "children{";
            for (int c = 0; c < n; ++c) {
                ConfigNode ch = this.getChildAt(c);
                info = info + ch.toString() + ", ";
            }
            info = info + "}";
        }
        return "ConfigNode[" + this.name + "=" + this.value + " > " + info + "]";
    }

    public String getExtension() {
        return this.extension;
    }

    public String getBean() {
        return this.bean;
    }
}

