/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.platform;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.StreamCorruptedException;
import java.util.ArrayList;
import java.util.List;

public class TempFileIndex {
    private static final long INDEX_FILE_MAGIC = 13569036356456L;
    private static final int INDEX_FILE_VERSION = 0;
    private File indexFile;
    private List<String> tempFiles = new ArrayList<String>();

    public TempFileIndex(File indexFile) {
        this.setIndexFile(indexFile);
        if (indexFile.exists()) {
            try {
                this.load();
            }
            catch (Exception e) {
                String msg = "Error loading temp-file index: " + indexFile;
                System.err.println(msg);
                e.printStackTrace(System.err);
            }
        }
    }

    public synchronized void registerTempFile(File file) throws IOException {
        String path = file.getPath();
        if (!this.tempFiles.contains(path)) {
            this.tempFiles.add(path);
            this.save();
        }
    }

    public synchronized void unregisterTempFile(File file) throws IOException {
        if (this.tempFiles.remove(file.getPath())) {
            this.save();
        }
    }

    public synchronized int getTempFileCount() throws IOException {
        return this.tempFiles.size();
    }

    public synchronized File getTempFileAt(int i) throws IOException {
        return new File(this.tempFiles.get(i));
    }

    public synchronized boolean containsTempFile(File file) throws IOException {
        String path = file.getPath();
        return this.tempFiles.contains(path);
    }

    public synchronized boolean deleteTempFileAt(int i) throws IOException {
        File f = this.getTempFileAt(i);
        if (f != null) {
            if (f.exists() && f.isFile() && !f.delete()) {
                return false;
            }
            this.tempFiles.remove(i);
            this.save();
            return true;
        }
        return false;
    }

    public synchronized boolean deleteTempFile(File file) throws IOException {
        String path = file.getPath();
        int i = this.tempFiles.indexOf(path);
        if (i < 0) {
            return false;
        }
        return this.deleteTempFileAt(i);
    }

    public synchronized boolean deleteAllTempFiles() throws IOException {
        boolean rc = true;
        int count = this.tempFiles.size();
        for (int c = count - 1; c >= 0; --c) {
            if (this.deleteTempFileAt(c)) continue;
            rc = false;
        }
        return rc;
    }

    public File getIndexFile() {
        return this.indexFile;
    }

    protected void setIndexFile(File indexFile) {
        this.indexFile = indexFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void save() throws IOException {
        FileOutputStream fout = new FileOutputStream(this.indexFile);
        DataOutputStream dout = new DataOutputStream(fout);
        try {
            dout.writeLong(13569036356456L);
            dout.writeInt(0);
            int num = this.tempFiles.size();
            dout.writeInt(num);
            for (int c = 0; c < num; ++c) {
                dout.writeUTF(this.tempFiles.get(c));
            }
            dout.flush();
        }
        finally {
            fout.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void load() throws IOException {
        FileInputStream fin = new FileInputStream(this.indexFile);
        DataInputStream din = new DataInputStream(fin);
        try {
            long magic = din.readLong();
            if (magic != 13569036356456L) {
                throw new StreamCorruptedException("Invalid file magic: " + magic + " != " + 13569036356456L);
            }
            int version = din.readInt();
            if (version != 0) {
                throw new StreamCorruptedException("Invalid file version: " + version + " != " + 0);
            }
            int num = din.readInt();
            for (int c = 0; c < num; ++c) {
                String path = din.readUTF();
                if (path.length() <= 0) continue;
                this.tempFiles.add(path);
            }
        }
        finally {
            fin.close();
        }
    }
}

