/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.platform;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ZOldMuellerObjectInputStream
extends ObjectInputStream {
    private static final Logger logger = Logger.getLogger(ZOldMuellerObjectInputStream.class.getName());
    private final String oldPackagePrefix = "com.mueller.";
    private final String newPackagePrefix = "com.spacekiller.";

    public ZOldMuellerObjectInputStream(InputStream in) throws IOException {
        super(in);
    }

    @Override
    protected Class<?> resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
        try {
            return super.resolveClass(desc);
        }
        catch (ClassNotFoundException e) {
            logger.log(Level.FINE, e.getMessage(), e);
            String name = desc.getName();
            if (name.startsWith("com.mueller.")) {
                String newName = "com.spacekiller." + name.substring("com.mueller.".length());
                try {
                    return Class.forName(newName, false, this.getClass().getClassLoader());
                }
                catch (Throwable e2) {
                    logger.log(Level.FINE, e2.getMessage(), e2);
                }
            }
            throw e;
        }
    }
}

