/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.collect;

import com.spacekiller.util.Consumer;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collection;

public class FastSet<T> {
    protected final Class<T> type;
    protected boolean nil;
    protected T[] arr;
    protected int len;
    protected int thresh;
    protected int size;

    public FastSet(Class<T> type) {
        this(type, 16);
    }

    public FastSet(Class<T> type, int initCapacity) {
        assert (initCapacity > 4);
        this.type = type;
        this.arr = this.alloc(initCapacity);
        this.len = this.arr.length;
        this.thresh = this.arr.length * 2 / 3;
    }

    protected FastSet(Class<T> type, T[] arr) {
        this.type = type;
        this.arr = arr;
        this.len = arr.length;
        this.thresh = arr.length * 2 / 3;
    }

    protected T[] alloc(int n) {
        return (Object[])Array.newInstance(this.type, n);
    }

    public int threshold() {
        return this.thresh;
    }

    public void ensureThreshold(int min) {
        if (this.thresh < min) {
            this.grow((min + 1) * 3 / 2);
        }
    }

    public boolean isEmpty() {
        return this.size < 1;
    }

    public int size() {
        return this.size;
    }

    public void list(Collection<T> c) {
        if (this.nil) {
            c.add(null);
        }
        if (this.size > 0) {
            for (int i = 0; i < this.len; ++i) {
                T o = this.arr[i];
                if (o == null) continue;
                c.add(o);
            }
        }
    }

    public boolean list(Consumer<T> c) {
        if (this.nil && !c.invoke(null)) {
            return false;
        }
        if (this.size > 0) {
            for (int i = 0; i < this.len; ++i) {
                T o = this.arr[i];
                if (o == null || c.invoke(o)) continue;
                return false;
            }
        }
        return true;
    }

    public void clear() {
        if (this.size < 1) {
            return;
        }
        this.size = 0;
        this.nil = false;
        Arrays.fill(this.arr, null);
    }

    public void clear(int max) {
        if (this.thresh > max) {
            this.size = 0;
            this.nil = false;
            this.len = max * 3 / 2;
            this.thresh = this.len * 2 / 3;
            this.arr = this.alloc(this.len);
        } else {
            this.clear();
        }
    }

    protected T[] clear(T[] newArr) {
        this.size = 0;
        this.nil = false;
        this.len = newArr.length;
        this.thresh = this.len * 2 / 3;
        T[] old = this.arr;
        this.arr = newArr;
        return old;
    }

    protected int pos(T o) {
        return (o.hashCode() & Integer.MAX_VALUE) % this.len;
    }

    protected boolean eq(T a, T b) {
        return a.equals(b);
    }

    public boolean has(T o) {
        if (o == null) {
            return this.nil;
        }
        if (this.size < 1) {
            return false;
        }
        int i = this.pos(o);
        T t = this.arr[i];
        while (t != null) {
            if (this.eq(t, o)) {
                return true;
            }
            i = (i + 1) % this.len;
            t = this.arr[i];
        }
        return false;
    }

    public boolean add(T o) {
        if (o == null) {
            if (this.nil) {
                return false;
            }
            this.nil = true;
            ++this.size;
            return true;
        }
        int i = this.pos(o);
        T t = this.arr[i];
        while (t != null) {
            if (this.eq(t, o)) {
                return false;
            }
            i = (i + 1) % this.len;
            t = this.arr[i];
        }
        this.arr[i] = o;
        if (++this.size > this.thresh) {
            this.grow(this.len << 1);
        }
        return true;
    }

    public boolean del(T o) {
        if (o == null) {
            if (this.nil) {
                this.nil = false;
                --this.size;
                return true;
            }
            return false;
        }
        if (this.size < 1) {
            return false;
        }
        int i = this.pos(o);
        T t = this.arr[i];
        while (t != null) {
            if (this.eq(t, o)) {
                this.arr[i] = null;
                this.closeDel(i);
                --this.size;
                return true;
            }
            i = (i + 1) % this.len;
            t = this.arr[i];
        }
        return false;
    }

    protected void grow(int newLen) {
        int oldLen = this.len;
        T[] a = this.alloc(newLen);
        this.len = newLen = a.length;
        if (this.size > 0) {
            for (int j = 0; j < oldLen; ++j) {
                T t = this.arr[j];
                if (t == null) continue;
                int i = this.pos(t);
                while (a[i] != null) {
                    i = (i + 1) % newLen;
                }
                a[i] = t;
            }
        }
        this.arr = a;
        this.thresh = newLen * 2 / 3;
    }

    private void closeDel(int d) {
        T t;
        int i = (d + 1) % this.len;
        while ((t = this.arr[i]) != null) {
            int r = this.pos(t);
            if (i < r && (r <= d || d <= i) || r <= d && d <= i) {
                this.arr[d] = t;
                this.arr[i] = null;
                d = i;
            }
            i = (i + 1) % this.len;
        }
    }
}

