/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.collect;

import com.spacekiller.util.collect.Long2ObjectIter;
import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Iterator;

public class Long2ObjectMap<V> {
    private long[] ids;
    private V[] obj;
    private int len;
    private int size;
    private int threshold;
    private boolean zeroSet;
    private V zeroValue;

    public Long2ObjectMap(int initCapacity) {
        this.ids = new long[initCapacity];
        this.obj = new Object[initCapacity];
        this.len = initCapacity;
        this.threshold = this.len * 2 / 3;
        this.size = 0;
    }

    public int capacity() {
        return this.len;
    }

    private void closeDeletion(int d) {
        long key;
        int i = this.next(d);
        while ((key = this.ids[i]) != 0L) {
            int r = this.pos(key);
            if (i < r && (r <= d || d <= i) || r <= d && d <= i) {
                this.ids[d] = key;
                this.obj[d] = this.obj[i];
                this.ids[i] = 0L;
                this.obj[i] = null;
                d = i;
            }
            i = this.next(i);
        }
    }

    public V get(long id) {
        if (id == 0L) {
            return this.zeroValue;
        }
        int i = this.pos(id);
        long v;
        while ((v = this.ids[i]) != 0L) {
            if (v == id) {
                return this.obj[i];
            }
            i = this.next(i);
        }
        return null;
    }

    public boolean containsKey(long id) {
        if (id == 0L) {
            return this.zeroSet;
        }
        int i = this.pos(id);
        long v;
        while ((v = this.ids[i]) != 0L) {
            if (v == id) {
                return true;
            }
            i = this.next(i);
        }
        return false;
    }

    public int getUsedMemory() {
        int rc = this.capacity() * 12;
        return rc += 24;
    }

    protected int pos(long key) {
        return ((int)(key << 2) & Integer.MAX_VALUE) % this.len;
    }

    private int next(int i) {
        return ++i < this.len ? i : 0;
    }

    public void delete(long id) {
        long key;
        if (id == 0L) {
            if (this.zeroSet) {
                this.zeroSet = false;
                this.zeroValue = null;
                --this.size;
            }
            return;
        }
        int i = this.pos(id);
        while ((key = this.ids[i]) != 0L) {
            if (key == id) {
                this.ids[i] = 0L;
                this.obj[i] = null;
                --this.size;
                this.closeDeletion(i);
                return;
            }
            i = this.next(i);
        }
    }

    public V remove(long id) {
        long key;
        if (id == 0L) {
            if (this.zeroSet) {
                V o = this.zeroValue;
                this.zeroSet = false;
                this.zeroValue = null;
                --this.size;
                return o;
            }
            return null;
        }
        int i = this.pos(id);
        while ((key = this.ids[i]) != 0L) {
            if (key == id) {
                V o = this.obj[i];
                this.ids[i] = 0L;
                this.obj[i] = null;
                --this.size;
                this.closeDeletion(i);
                return o;
            }
            i = this.next(i);
        }
        return null;
    }

    private void resize(int newLen) {
        if (newLen < this.len) {
            return;
        }
        long[] oldIds = this.ids;
        V[] oldObj = this.obj;
        int oldLen = this.len;
        this.ids = new long[newLen];
        this.obj = new Object[newLen];
        this.len = newLen;
        this.threshold = this.len * 2 / 3;
        for (int j = 0; j < oldLen; ++j) {
            long id = oldIds[j];
            if (id == 0L) continue;
            int i = this.pos(id);
            while (this.ids[i] != 0L) {
                i = this.next(i);
            }
            this.ids[i] = id;
            this.obj[i] = oldObj[j];
        }
    }

    public void set(long id, V value) {
        long v;
        if (id == 0L) {
            if (this.zeroSet) {
                this.zeroValue = value;
            } else {
                this.zeroSet = true;
                this.zeroValue = value;
                ++this.size;
            }
            return;
        }
        int i = this.pos(id);
        while ((v = this.ids[i]) != 0L) {
            if (v == id) {
                this.obj[i] = value;
                return;
            }
            i = this.next(i);
        }
        this.ids[i] = id;
        this.obj[i] = value;
        if (++this.size >= this.threshold) {
            this.resize(this.len * 2);
        }
    }

    public V put(long id, V value) {
        long v;
        if (id == 0L) {
            if (this.zeroSet) {
                V old = this.zeroValue;
                this.zeroValue = value;
                return old;
            }
            this.zeroSet = true;
            this.zeroValue = value;
            ++this.size;
            return null;
        }
        int i = this.pos(id);
        while ((v = this.ids[i]) != 0L) {
            if (v == id) {
                V old = this.obj[i];
                this.obj[i] = value;
                return old;
            }
            i = this.next(i);
        }
        this.ids[i] = id;
        this.obj[i] = value;
        if (++this.size >= this.threshold) {
            this.resize(this.len * 2);
        }
        return null;
    }

    public Object add(long id, V value) {
        long v;
        if (id == 0L) {
            if (this.zeroSet) {
                return this.zeroValue;
            }
            this.zeroSet = true;
            this.zeroValue = value;
            ++this.size;
            return null;
        }
        int i = this.pos(id);
        while ((v = this.ids[i]) != 0L) {
            if (v == id) {
                return this.obj[i];
            }
            i = this.next(i);
        }
        this.ids[i] = id;
        this.obj[i] = value;
        if (++this.size >= this.threshold) {
            this.resize(this.len * 2);
        }
        return null;
    }

    public void clear() {
        if (this.zeroSet) {
            this.zeroSet = false;
            this.zeroValue = null;
            --this.size;
        }
        if (this.size != 0) {
            for (int i = 0; i < this.len; ++i) {
                this.ids[i] = 0L;
                this.obj[i] = null;
            }
            this.size = 0;
        }
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size < 1;
    }

    public Collection values() {
        return new Values();
    }

    public Iterator valueIter() {
        return new ValueIter();
    }

    public Long2ObjectIter iterator() {
        return new Iter();
    }

    public void dispose() {
        this.zeroValue = null;
        this.ids = null;
        this.obj = null;
    }

    protected class Values
    extends AbstractCollection {
        protected Values() {
        }

        @Override
        public boolean isEmpty() {
            return Long2ObjectMap.this.size < 1;
        }

        @Override
        public int size() {
            return Long2ObjectMap.this.size;
        }

        @Override
        public Iterator iterator() {
            return new ValueIter();
        }
    }

    protected class Iter
    implements Long2ObjectIter {
        private int i = 0;
        private boolean zero;
        private long key;

        public Iter() {
            this.zero = Long2ObjectMap.this.zeroSet;
        }

        @Override
        public boolean hasNext() {
            while (this.i < Long2ObjectMap.this.len) {
                if (Long2ObjectMap.this.ids[this.i] != 0L) {
                    return true;
                }
                ++this.i;
            }
            return this.zero;
        }

        public V next() {
            while (this.i < Long2ObjectMap.this.len) {
                if (Long2ObjectMap.this.ids[this.i] != 0L) {
                    this.key = Long2ObjectMap.this.ids[this.i];
                    return Long2ObjectMap.this.obj[this.i++];
                }
                ++this.i;
            }
            if (this.zero) {
                this.zero = false;
                this.key = 0L;
                return Long2ObjectMap.this.zeroValue;
            }
            return null;
        }

        @Override
        public long getKey() {
            return this.key;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("currently not supported!");
        }
    }

    protected class ValueIter
    implements Iterator {
        private int i = 0;
        private boolean zero;
        private int r;

        public ValueIter() {
            this.zero = Long2ObjectMap.this.zeroSet;
            this.r = -1;
        }

        @Override
        public boolean hasNext() {
            while (this.i < Long2ObjectMap.this.len) {
                if (Long2ObjectMap.this.ids[this.i] != 0L) {
                    return true;
                }
                ++this.i;
            }
            return this.zero;
        }

        public V next() {
            while (this.i < Long2ObjectMap.this.len) {
                if (Long2ObjectMap.this.ids[this.i] != 0L) {
                    return Long2ObjectMap.this.obj[this.i++];
                }
                ++this.i;
            }
            if (this.zero) {
                this.zero = false;
                this.r = Integer.MAX_VALUE;
                return Long2ObjectMap.this.zeroValue;
            }
            return null;
        }

        @Override
        public void remove() {
            if (this.i == this.r) {
                throw new IllegalStateException("Current entry already removed: " + this.i);
            }
            if (this.r == Integer.MAX_VALUE) {
                if (Long2ObjectMap.this.zeroSet) {
                    Long2ObjectMap.this.zeroSet = false;
                    Long2ObjectMap.this.zeroValue = null;
                    Long2ObjectMap.this.size--;
                }
                this.i = this.r;
                return;
            }
            this.r = --this.i;
            ((Long2ObjectMap)Long2ObjectMap.this).ids[this.r] = 0L;
            ((Long2ObjectMap)Long2ObjectMap.this).obj[this.r] = null;
            Long2ObjectMap.this.size--;
            Long2ObjectMap.this.closeDeletion(this.r);
        }
    }
}

