/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.table;

import com.spacekiller.util.table.RowComparator;
import com.spacekiller.util.table.RowFilter;
import java.util.ArrayList;
import java.util.List;
import javax.swing.event.EventListenerList;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;

public class SubTableModel
implements TableModel {
    private TableModel tableModel;
    private RowFilter rowFilter;
    private RowComparator rowComparator;
    private List cols;
    private int[] sub2Model;
    private int subSize;
    private int[] model2Sub;
    private int modelSize;
    private TableModelHandler tableModelHandler = new TableModelHandler();
    private EventListenerList listenerList = new EventListenerList();
    private boolean editable = true;

    public SubTableModel() {
        this.initSubTableModel(10);
        this.refresh();
    }

    public SubTableModel(TableModel model) {
        this.initSubTableModel(model.getRowCount());
        this.setTableModel(model);
    }

    public SubTableModel(TableModel model, RowFilter filter, RowComparator comparator) {
        this.rowFilter = filter;
        this.rowComparator = comparator;
        this.initSubTableModel(model.getRowCount());
        this.setTableModel(model);
    }

    protected void initSubTableModel(int initSize) {
        this.cols = new ArrayList();
        this.sub2Model = new int[initSize];
        this.model2Sub = new int[initSize];
    }

    public synchronized RowComparator getRowComparator() {
        return this.rowComparator;
    }

    public synchronized void setRowComparator(RowComparator newRowComparator) {
        if (this.rowComparator == newRowComparator) {
            return;
        }
        this.rowComparator = newRowComparator;
        this.refresh();
    }

    public synchronized RowFilter getRowFilter() {
        return this.rowFilter;
    }

    public synchronized void setRowFilter(RowFilter newRowFilter) {
        if (this.rowFilter == newRowFilter) {
            return;
        }
        this.rowFilter = newRowFilter;
        this.refresh();
    }

    public synchronized TableModel getTableModel() {
        return this.tableModel;
    }

    public synchronized int getTableModelRowIndex(int row) {
        if (row >= 0 && row < this.subSize) {
            return this.sub2Model[row];
        }
        return -1;
    }

    public synchronized int getSubTableRowIndex(int modelRow) {
        if (modelRow >= 0 && modelRow < this.modelSize) {
            return this.model2Sub[modelRow];
        }
        return -1;
    }

    public synchronized void setTableModel(TableModel newTableModel) {
        if (this.tableModel == newTableModel) {
            return;
        }
        if (newTableModel == this) {
            throw new IllegalArgumentException("Cannot wrap myself!");
        }
        if (this.tableModel != null) {
            this.tableModel.removeTableModelListener(this.tableModelHandler);
        }
        this.tableModel = newTableModel;
        if (this.tableModel != null) {
            this.tableModel.addTableModelListener(this.tableModelHandler);
        }
        this.refresh();
    }

    @Override
    public synchronized int getColumnCount() {
        return this.cols.size();
    }

    @Override
    public synchronized int getRowCount() {
        return this.subSize;
    }

    @Override
    public synchronized Object getValueAt(int rowIndex, int columnIndex) {
        if (rowIndex < 0 || rowIndex >= this.subSize) {
            return null;
        }
        int colCount = this.cols.size();
        if (columnIndex < 0 || columnIndex >= colCount) {
            return null;
        }
        int modelRow = this.sub2Model[rowIndex];
        ColumnInfo col = (ColumnInfo)this.cols.get(columnIndex);
        int modelCol = col.modelColumnIndex;
        return this.tableModel.getValueAt(modelRow, modelCol);
    }

    public synchronized Class getColumnClass(int columnIndex) {
        int colCount = this.cols.size();
        if (columnIndex < 0 || columnIndex >= colCount) {
            return null;
        }
        ColumnInfo col = (ColumnInfo)this.cols.get(columnIndex);
        int modelCol = col.modelColumnIndex;
        return this.tableModel.getColumnClass(modelCol);
    }

    @Override
    public synchronized String getColumnName(int columnIndex) {
        int colCount = this.cols.size();
        if (columnIndex < 0 || columnIndex >= colCount) {
            return null;
        }
        ColumnInfo col = (ColumnInfo)this.cols.get(columnIndex);
        int modelCol = col.modelColumnIndex;
        return this.tableModel.getColumnName(modelCol);
    }

    @Override
    public synchronized boolean isCellEditable(int rowIndex, int columnIndex) {
        if (!this.editable) {
            return false;
        }
        if (rowIndex < 0 || rowIndex >= this.subSize) {
            return false;
        }
        int colCount = this.cols.size();
        if (columnIndex < 0 || columnIndex >= colCount) {
            return false;
        }
        int modelRow = this.sub2Model[rowIndex];
        ColumnInfo col = (ColumnInfo)this.cols.get(columnIndex);
        int modelCol = col.modelColumnIndex;
        return this.tableModel.isCellEditable(modelRow, modelCol);
    }

    @Override
    public synchronized void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        if (!this.editable) {
            return;
        }
        if (rowIndex < 0 || rowIndex >= this.subSize) {
            return;
        }
        int colCount = this.cols.size();
        if (columnIndex < 0 || columnIndex >= colCount) {
            return;
        }
        int modelRow = this.sub2Model[rowIndex];
        ColumnInfo col = (ColumnInfo)this.cols.get(columnIndex);
        int modelCol = col.modelColumnIndex;
        this.tableModel.setValueAt(aValue, modelRow, modelCol);
    }

    @Override
    public synchronized void addTableModelListener(TableModelListener l) {
        this.listenerList.add(TableModelListener.class, l);
    }

    @Override
    public synchronized void removeTableModelListener(TableModelListener l) {
        this.listenerList.remove(TableModelListener.class, l);
    }

    protected void fireTableDataChanged() {
        this.fireTableChanged(new TableModelEvent(this));
    }

    protected void fireTableStructureChanged() {
        this.fireTableChanged(new TableModelEvent(this, -1));
    }

    protected void fireTableRowsInserted(int firstRow, int lastRow) {
        this.fireTableChanged(new TableModelEvent(this, firstRow, lastRow, -1, 1));
    }

    protected void fireTableRowsUpdated(int firstRow, int lastRow) {
        this.fireTableChanged(new TableModelEvent(this, firstRow, lastRow, -1, 0));
    }

    protected void fireTableRowsDeleted(int firstRow, int lastRow) {
        this.fireTableChanged(new TableModelEvent(this, firstRow, lastRow, -1, -1));
    }

    protected void fireTableCellUpdated(int row, int column) {
        this.fireTableChanged(new TableModelEvent(this, row, row, column));
    }

    protected synchronized void fireTableChanged(TableModelEvent e) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != TableModelListener.class) continue;
            ((TableModelListener)listeners[i + 1]).tableChanged(e);
        }
    }

    public boolean isEditable() {
        return this.editable;
    }

    public void setEditable(boolean editable) {
        this.editable = editable;
    }

    protected int getInsertIndex(TableModel model, int row, RowComparator cmp) {
        int lo = 0;
        int hi = this.subSize - 1;
        block4: while (lo <= hi) {
            int x = lo + (hi - lo) / 2;
            switch (cmp.compare(this, x, model, row)) {
                case 1: {
                    hi = x - 1;
                    continue block4;
                }
                case -1: 
                case 0: {
                    lo = x + 1;
                    continue block4;
                }
            }
            throw new RuntimeException("Invalid row compare result!");
        }
        return lo;
    }

    protected int getInsertIndex(TableModel model, int row) {
        int lo = 0;
        int hi = this.subSize - 1;
        while (lo <= hi) {
            int x = lo + (hi - lo) / 2;
            int r = this.sub2Model[x];
            if (r > row) {
                hi = x - 1;
                continue;
            }
            lo = x + 1;
        }
        return lo;
    }

    public synchronized void refresh() {
        this.cols.clear();
        TableModel model = this.tableModel;
        if (model != null) {
            int modelCols = model.getColumnCount();
            for (int i = 0; i < modelCols; ++i) {
                this.cols.add(new ColumnInfo(i));
            }
            this.modelSize = model.getRowCount();
            if (this.model2Sub.length < this.modelSize) {
                this.model2Sub = new int[this.modelSize];
            }
            if (this.sub2Model.length < this.modelSize) {
                this.sub2Model = new int[this.modelSize];
            }
            RowFilter filter = this.rowFilter;
            RowComparator comp = this.rowComparator;
            if (comp == null) {
                if (filter == null) {
                    for (int r = 0; r < this.modelSize; ++r) {
                        this.sub2Model[r] = r;
                        this.model2Sub[r] = r;
                    }
                    this.subSize = this.modelSize;
                } else {
                    this.subSize = 0;
                    for (int r = 0; r < this.modelSize; ++r) {
                        if (filter.accept(model, r)) {
                            this.model2Sub[r] = this.subSize;
                            this.sub2Model[this.subSize++] = r;
                            continue;
                        }
                        this.model2Sub[r] = -1;
                    }
                }
            } else {
                int x;
                this.subSize = 0;
                for (int r = 0; r < this.modelSize; ++r) {
                    this.model2Sub[r] = -1;
                    if (filter != null && !filter.accept(model, r)) continue;
                    x = this.getInsertIndex(model, r, comp);
                    if (x >= this.subSize) {
                        this.sub2Model[this.subSize++] = r;
                        continue;
                    }
                    System.arraycopy(this.sub2Model, x, this.sub2Model, x + 1, this.subSize - x);
                    this.sub2Model[x] = r;
                    ++this.subSize;
                }
                int i = 0;
                while (i < this.subSize) {
                    x = this.sub2Model[i];
                    this.model2Sub[x] = i++;
                }
            }
        } else {
            this.subSize = 0;
            this.modelSize = 0;
        }
        this.fireTableStructureChanged();
    }

    protected synchronized void handleTableChanged(TableModelEvent e) {
        switch (e.getType()) {
            case 1: {
                int firstRow = e.getFirstRow();
                int lastRow = e.getLastRow();
                if (firstRow > this.modelSize || lastRow == Integer.MAX_VALUE || firstRow < 0 || lastRow < 0 || lastRow < firstRow) {
                    this.refresh();
                    return;
                }
                this.handleRowsInserted(firstRow, lastRow);
                return;
            }
            case -1: {
                int firstRow = e.getFirstRow();
                int lastRow = e.getLastRow();
                if (firstRow >= this.modelSize || lastRow >= this.modelSize || firstRow < 0 || lastRow < 0 || lastRow < firstRow) {
                    this.refresh();
                    return;
                }
                this.handleRowsDeleted(firstRow, lastRow);
                return;
            }
            case 0: {
                int firstRow = e.getFirstRow();
                int lastRow = e.getLastRow();
                if (firstRow >= this.modelSize || lastRow >= this.modelSize || firstRow < 0 || lastRow < 0 || lastRow < firstRow) {
                    this.refresh();
                    return;
                }
                this.handleRowsUpdated(firstRow, lastRow);
                return;
            }
        }
    }

    protected synchronized void grow(int newSize) {
        int[] arr;
        if (this.sub2Model.length < newSize) {
            arr = new int[newSize];
            System.arraycopy(this.sub2Model, 0, arr, 0, this.subSize);
            this.sub2Model = arr;
        }
        if (this.model2Sub.length < newSize) {
            arr = new int[newSize];
            System.arraycopy(this.model2Sub, 0, arr, 0, this.modelSize);
            this.model2Sub = arr;
        }
    }

    protected synchronized void handleRowsInserted(int firstRow, int lastRow) {
        int x;
        RowFilter filter = this.rowFilter;
        RowComparator comp = this.rowComparator;
        int rowCount = lastRow - firstRow + 1;
        int newModelSize = this.modelSize + rowCount;
        if (newModelSize > this.sub2Model.length) {
            this.grow(newModelSize);
        }
        if (comp == null && filter == null) {
            for (int i = this.modelSize; i < newModelSize; ++i) {
                this.sub2Model[i] = i;
                this.model2Sub[i] = i;
            }
            this.modelSize = newModelSize;
            this.subSize = newModelSize;
            this.fireTableRowsInserted(firstRow, lastRow);
            return;
        }
        if (firstRow != this.modelSize) {
            System.arraycopy(this.model2Sub, firstRow, this.model2Sub, firstRow + rowCount, this.modelSize - firstRow);
            for (x = firstRow; x <= lastRow; ++x) {
                this.model2Sub[x] = -1;
            }
            for (x = 0; x < this.subSize; ++x) {
                if (this.sub2Model[x] < firstRow) continue;
                int n = x;
                this.sub2Model[n] = this.sub2Model[n] + rowCount;
            }
        } else {
            for (x = firstRow; x <= lastRow; ++x) {
                this.model2Sub[x] = -1;
            }
        }
        this.modelSize = newModelSize;
        TableModel model = this.tableModel;
        int subRow = -1;
        for (int r = firstRow; r <= lastRow; ++r) {
            if (filter != null && !filter.accept(model, r)) continue;
            subRow = comp == null ? this.getInsertIndex(model, r) : this.getInsertIndex(model, r, comp);
            if (subRow < this.subSize) {
                System.arraycopy(this.sub2Model, subRow, this.sub2Model, subRow + 1, this.subSize - subRow);
            }
            this.sub2Model[subRow] = r;
            ++this.subSize;
        }
        if (subRow < 0) {
            return;
        }
        int i = 0;
        while (i < this.subSize) {
            x = this.sub2Model[i];
            this.model2Sub[x] = i++;
        }
        if (firstRow == lastRow) {
            this.fireTableRowsInserted(subRow, subRow);
        } else {
            this.fireTableDataChanged();
        }
    }

    protected synchronized void handleRowsDeleted(int firstRow, int lastRow) {
        RowFilter filter = this.rowFilter;
        RowComparator comp = this.rowComparator;
        int rowCount = lastRow - firstRow + 1;
        int newModelSize = this.modelSize - rowCount;
        if (comp == null && filter == null) {
            this.modelSize = newModelSize;
            this.subSize = newModelSize;
            this.fireTableRowsDeleted(firstRow, lastRow);
            return;
        }
        int x = lastRow + 1;
        if (x < this.modelSize) {
            System.arraycopy(this.model2Sub, x, this.model2Sub, firstRow, this.modelSize - x);
        }
        this.modelSize = newModelSize;
        int subRow = -1;
        int z = this.subSize;
        this.subSize = 0;
        for (int r = 0; r < z; ++r) {
            x = this.sub2Model[r];
            if (x < firstRow) {
                this.model2Sub[x] = this.subSize;
                this.sub2Model[this.subSize++] = x;
                continue;
            }
            if (x > lastRow) {
                this.model2Sub[x -= rowCount] = this.subSize;
                this.sub2Model[this.subSize++] = x;
                continue;
            }
            subRow = r;
        }
        if (subRow < 0) {
            return;
        }
        if (firstRow == lastRow) {
            this.fireTableRowsDeleted(subRow, subRow);
        } else {
            this.fireTableDataChanged();
        }
    }

    protected synchronized void handleRowsUpdated(int firstRow, int lastRow) {
        RowFilter filter = this.rowFilter;
        RowComparator comp = this.rowComparator;
        if (comp == null && filter == null) {
            this.fireTableRowsUpdated(firstRow, lastRow);
            return;
        }
        System.out.println("handleTableChanged: UPDATE: firstRow=" + firstRow + ", lastRow=" + lastRow);
        this.refresh();
    }

    public synchronized void checkConsistency() throws IllegalStateException {
        int sub;
        int row;
        int i;
        int num = this.subSize;
        for (i = 0; i < num; ++i) {
            row = this.sub2Model[i];
            if (row < 0 || row > this.modelSize) {
                throw new IllegalStateException("Invalid sub2Model #" + i + ": " + row + " / " + this.modelSize);
            }
            sub = this.model2Sub[row];
            if (sub == i) continue;
            throw new IllegalStateException("Invalid model2Sub #" + row + ": " + sub + " != " + i);
        }
        num = this.modelSize;
        for (i = 0; i < num; ++i) {
            sub = this.model2Sub[i];
            if (sub < 0 || (row = this.sub2Model[sub]) == i) continue;
            throw new IllegalStateException("Invalid model2Sub #" + i + ": " + row + " != " + i);
        }
    }

    protected class ColumnInfo {
        private int modelColumnIndex;

        public ColumnInfo(int modelColumnIndex) {
            this.modelColumnIndex = modelColumnIndex;
        }
    }

    protected class TableModelHandler
    implements TableModelListener {
        protected TableModelHandler() {
        }

        @Override
        public void tableChanged(TableModelEvent e) {
            SubTableModel.this.handleTableChanged(e);
        }
    }
}

