/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.table.sort;

import com.spacekiller.util.table.RowComparator;
import com.spacekiller.util.table.sort.ColumnValueRowComparator;
import com.spacekiller.util.table.sort.DateValueComparator;
import com.spacekiller.util.table.sort.NumberValueComparator;
import com.spacekiller.util.table.sort.StringValueComparator;
import com.spacekiller.util.table.sort.StringValueIgnoreCaseComparator;
import com.spacekiller.util.table.sort.TableSortRule;
import java.util.Comparator;
import java.util.Date;
import javax.swing.table.TableModel;

public class ColumnTableSortRule
implements TableSortRule {
    private String columnName;
    private boolean ascending;
    private boolean ignoreCase;

    public ColumnTableSortRule(String columnName, boolean ascending, boolean ignoreCase) {
        this.setColumnName(columnName);
        this.setAscending(ascending);
        this.setIgnoreCase(ignoreCase);
    }

    public boolean isAscending() {
        return this.ascending;
    }

    public void setAscending(boolean ascending) {
        this.ascending = ascending;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public void setColumnName(String columnName) {
        this.columnName = columnName;
    }

    protected int getColumnIndex(TableModel model, String colName) {
        if (colName != null) {
            int n = model.getColumnCount();
            for (int i = 0; i < n; ++i) {
                if (!colName.equals(model.getColumnName(i))) continue;
                return i;
            }
        }
        return -1;
    }

    @Override
    public RowComparator createRowComparator(TableModel model) throws Exception {
        int columnA = this.getColumnIndex(model, this.columnName);
        if (columnA < 0) {
            throw new RuntimeException("Column not found: " + this.columnName);
        }
        int columnB = columnA;
        Comparator comparator = null;
        Class<?> colType = model.getColumnClass(columnA);
        if (colType != null) {
            comparator = this.createValueComparator(colType);
        }
        if (comparator == null) {
            comparator = this.ignoreCase ? new StringValueIgnoreCaseComparator() : new StringValueComparator();
        }
        return new ColumnValueRowComparator(columnA, columnB, comparator, this.ascending);
    }

    protected Comparator createValueComparator(Class colType) {
        if (colType == null) {
            return null;
        }
        if (colType != null) {
            if (CharSequence.class.isAssignableFrom(colType)) {
                if (this.ignoreCase) {
                    return new StringValueIgnoreCaseComparator();
                }
                return new StringValueComparator();
            }
            if (Number.class.isAssignableFrom(colType)) {
                return new NumberValueComparator();
            }
            if (Date.class.isAssignableFrom(colType)) {
                return new DateValueComparator();
            }
        }
        return null;
    }

    @Override
    public String getName() {
        if (this.ascending) {
            return "" + this.columnName + " (ascending)";
        }
        return "" + this.columnName + " (descending)";
    }

    public boolean isIgnoreCase() {
        return this.ignoreCase;
    }

    public void setIgnoreCase(boolean ignoreCase) {
        this.ignoreCase = ignoreCase;
    }
}

