/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.thread;

import com.spacekiller.util.thread.ThreadPool;
import com.spacekiller.util.thread.Work;

public class DummyThreadPool
implements ThreadPool {
    private String namePrefix;
    private int threadPriority;
    private boolean daemon;
    private ClassLoader contextLoader;
    private volatile boolean closed;
    private long nextId = 1L;

    public DummyThreadPool(String namePrefix, int threadPriority, boolean daemon, ClassLoader contextLoader) {
        this.namePrefix = namePrefix;
        this.threadPriority = threadPriority;
        this.daemon = daemon;
        this.contextLoader = contextLoader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Work start(Runnable target) throws InterruptedException {
        long id;
        DummyThreadPool dummyThreadPool = this;
        synchronized (dummyThreadPool) {
            if (this.closed) {
                throw new IllegalStateException("Thread pool is closed!");
            }
            id = this.nextId++;
        }
        String name = this.namePrefix + id;
        Worker worker = new Worker(target, name);
        ClassLoader cl = this.contextLoader;
        if (cl != null) {
            worker.setContextClassLoader(cl);
        }
        worker.setDaemon(this.daemon);
        worker.setPriority(this.threadPriority);
        worker.start();
        return worker;
    }

    @Override
    public Thread getThread(Work work) {
        return (Worker)work;
    }

    @Override
    public synchronized void close() throws InterruptedException {
        this.closed = true;
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    protected class Worker
    extends Thread
    implements Work {
        private Throwable error;

        public Worker(Runnable target, String name) {
            super(target, name);
        }

        @Override
        public void run() {
            try {
                super.run();
            }
            catch (Throwable e) {
                this.error = e;
            }
        }

        @Override
        public Throwable getException() {
            return this.error;
        }
    }
}

