/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.member.jaas;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.TextOutputCallback;
import javax.security.auth.callback.UnsupportedCallbackException;

public class JaasCallbackHandler
implements CallbackHandler {
    private static final Logger logger = Logger.getLogger(JaasCallbackHandler.class.getName());
    private String user;
    private char[] pass;

    public JaasCallbackHandler(String user, char[] pass) {
        this.user = user;
        this.pass = pass;
    }

    public void clear() {
        if (this.pass != null) {
            for (int i = 0; i < this.pass.length; ++i) {
                this.pass[i] = 65535;
                this.pass[i] = '\u0000';
            }
        }
        this.user = null;
        this.pass = null;
    }

    @Override
    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(this.getClass().getName(), "handle", callbacks);
        }
        if (callbacks == null) {
            return;
        }
        NameCallback userNameCallback = null;
        PasswordCallback passwordCallback = null;
        for (int i = 0; i < callbacks.length; ++i) {
            Callback cb = callbacks[i];
            if (cb == null) continue;
            if (cb instanceof NameCallback && userNameCallback == null) {
                userNameCallback = (NameCallback)cb;
                continue;
            }
            if (cb instanceof PasswordCallback && passwordCallback == null) {
                passwordCallback = (PasswordCallback)cb;
                continue;
            }
            if (cb instanceof TextOutputCallback) {
                TextOutputCallback tcb = (TextOutputCallback)cb;
                logger.fine("TextOutputCallback: " + tcb.getMessage());
                continue;
            }
            throw new UnsupportedCallbackException(cb);
        }
        if (userNameCallback == null) {
            throw new IOException("Missing user name callback");
        }
        if (passwordCallback == null) {
            throw new IOException("Missing password callback");
        }
        userNameCallback.setName(this.user);
        passwordCallback.setPassword(this.pass);
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(this.getClass().getName(), "handle");
        }
    }
}

