/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.member.was;

import com.spacekiller.util.Tools;
import com.spacekiller.util.member.was.Was5UserRegistry;
import java.io.File;
import java.io.FileNotFoundException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;

public class Was5ClassLoader
extends URLClassLoader {
    public static final String WAS_HOME_SYSTEM_PROPERTY = "was.home";
    private static final String[] nativeLibExtensions = new String[]{".dll", ".so", ".a"};
    private static ClassLoader wasClassLoader;
    private File wasHome;
    private File wasBinDir;

    public Was5ClassLoader(File wasHome) throws Exception {
        super(new URL[0]);
        this.wasHome = wasHome;
        this.initWas5ClassLoader();
    }

    protected void initWas5ClassLoader() throws Exception {
        if (!this.wasHome.exists()) {
            throw new FileNotFoundException("Websphere home directory not found: " + this.wasHome);
        }
        File wasLibDir = new File(this.wasHome, "lib");
        File[] wasLibFiles = wasLibDir.listFiles();
        ArrayList<File> wasJarFiles = new ArrayList<File>();
        for (int c = 0; c < wasLibFiles.length; ++c) {
            String fname;
            File f = wasLibFiles[c];
            if (!f.isFile() || !(fname = f.getName()).endsWith(".jar")) continue;
            wasJarFiles.add(f);
        }
        int jarCount = wasJarFiles.size();
        for (int c = 0; c < jarCount; ++c) {
            File f = (File)wasJarFiles.get(c);
            URL url = Tools.getFileURL((File)f);
            super.addURL(url);
        }
        this.wasBinDir = new File(this.wasHome, "bin");
    }

    @Override
    protected String findLibrary(String libname) {
        for (int c = 0; c < nativeLibExtensions.length; ++c) {
            String fname = libname + nativeLibExtensions[c];
            File f = new File(this.wasBinDir, fname);
            if (!f.exists()) continue;
            return f.getAbsolutePath();
        }
        return super.findLibrary(libname);
    }

    protected static ClassLoader getWasClassLoader(String wasHomePath) throws Exception {
        if (wasClassLoader == null) {
            wasClassLoader = Was5ClassLoader.createWasClassLoader(wasHomePath);
        }
        return wasClassLoader;
    }

    protected static ClassLoader createWasClassLoader(String wasHomePath) throws Exception {
        ClassLoader myLoader = Was5UserRegistry.class.getClassLoader();
        try {
            Class<?> found = myLoader.loadClass("com.ibm.ws.security.registry.unix.UnixRegistryImpl");
            if (found != null) {
                return myLoader;
            }
        }
        catch (Throwable e) {
            // empty catch block
        }
        String wasHome = wasHomePath;
        if (wasHome == null) {
            wasHome = System.getProperty(WAS_HOME_SYSTEM_PROPERTY);
        }
        if (wasHome == null) {
            throw new Exception("Websphere home not set in system properties: was.home");
        }
        File wasHomeDir = new File(wasHome);
        Was5ClassLoader wasLoader = new Was5ClassLoader(wasHomeDir);
        return wasLoader;
    }
}

