/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.member.was;

import com.spacekiller.util.Data;
import com.spacekiller.util.Tools;
import com.spacekiller.util.member.was.Was5ClassLoader;
import com.spacekiller.util.member.was.Was5UserRegistry;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Properties;
import java.util.logging.Logger;

public class Was5LocalUserRegistry
extends Was5UserRegistry {
    private static final Logger logger = Logger.getLogger(Was5LocalUserRegistry.class.getName());

    @Override
    public void initialize(Properties config) throws Exception {
        String wasHome = config.getProperty("was.home");
        Object reg = null;
        Class<?> regClass = null;
        String osName = String.valueOf(System.getProperty("os.name"));
        ClassLoader loader = Was5ClassLoader.getWasClassLoader(wasHome);
        if (reg == null && Was5LocalUserRegistry.isWindows()) {
            Class<?> ntRegistryClass = loader.loadClass("com.ibm.ws.security.registry.nt.NTRegistryImpl");
            Constructor<?> cons = ntRegistryClass.getConstructor(Boolean.TYPE);
            boolean arg1 = false;
            reg = cons.newInstance(Data.toBoolean((boolean)arg1));
            regClass = reg.getClass();
            logger.fine("Windows-UserRegistry: " + reg);
        }
        if (reg == null && Was5LocalUserRegistry.isUnix()) {
            Class<?> unixRegistryClass = loader.loadClass("com.ibm.ws.security.registry.unix.UnixRegistryImpl");
            reg = Tools.newInstance(unixRegistryClass);
            regClass = reg.getClass();
            logger.fine("Unix-UserRegistry: " + reg);
        }
        if (reg == null) {
            throw new NullPointerException("Local user registry not supported: os=" + osName);
        }
        Method methodInitialize = regClass.getDeclaredMethod("initialize", Properties.class);
        methodInitialize.invoke(reg, config);
        super.initialize(reg);
    }

    protected static boolean isWindows() {
        String osName = String.valueOf(System.getProperty("os.name"));
        return (osName = osName.toLowerCase()).startsWith("windows");
    }

    protected static boolean isUnix() {
        return !Was5LocalUserRegistry.isWindows();
    }
}

