/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.heap;

import com.spacekiller.util.heap.AbstractArea;
import com.spacekiller.util.heap.Block;
import com.spacekiller.util.heap.DefaultBlock;
import com.spacekiller.util.heap.Heap;
import com.spacekiller.util.lock.LockFactory;
import com.spacekiller.util.lock.ReadWriteLock;
import java.io.IOException;

public abstract class AbstractHeap
implements Heap {
    private String name;
    protected final AbstractArea area;
    protected final LockFactory lockFactory;
    protected final boolean fair;

    public AbstractHeap(String name, AbstractArea area, LockFactory lockFactory, boolean fair) {
        if (area == null || lockFactory == null) {
            throw new IllegalArgumentException();
        }
        this.name = name;
        this.area = area;
        this.lockFactory = lockFactory;
        this.fair = fair;
    }

    public String toString() {
        return super.toString() + "[name=" + this.name + ", area=" + this.area + "]";
    }

    @Override
    public Block allocate(int size) throws IOException {
        if (size < 1) {
            throw new IOException("Invalid block size: " + size);
        }
        ReadWriteLock lock = this.lockFactory.createReadWriteLock(this.fair);
        DefaultBlock block = new DefaultBlock(size, lock);
        this.area.allocate(block, size);
        return block;
    }

    @Override
    public String getName() {
        return this.name;
    }

    protected void setName(String name) {
        this.name = name;
    }
}

