/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.heap;

import com.spacekiller.util.heap.Area;
import com.spacekiller.util.heap.Frag;
import com.spacekiller.util.heap.Page;
import java.io.IOException;

public abstract class AbstractPage
implements Page {
    protected final Area area;
    protected AbstractPage prev;
    protected AbstractPage next;
    protected int size;
    protected Frag first;
    protected Frag last;

    public AbstractPage(Area area, int size) {
        this.area = area;
        this.size = size;
        this.last = this.first = new Frag(0, size);
    }

    @Override
    public final Area getArea() {
        return this.area;
    }

    protected int getSize() {
        return this.size;
    }

    protected void setSize(int size) {
        this.size = size;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public synchronized int alloc(int size) {
        Frag f = this.last;
        while (f != null) {
            int off = f.alloc(size);
            if (off >= 0) {
                if (f.size() < 1) {
                    if (f.prev == null) {
                        this.first = f.next;
                    } else {
                        f.prev.next = f.next;
                    }
                    if (f.next == null) {
                        this.last = f.prev;
                    } else {
                        f.next.prev = f.prev;
                    }
                }
                return off;
            }
            f = f.prev;
        }
        return -1;
    }

    @Override
    public synchronized Frag free(int off, int len) {
        int end = off + len;
        Frag f = this.first;
        while (f != null) {
            int o = f.off;
            if (o > end) {
                Frag x = new Frag(off, end);
                x.prev = f.prev;
                x.next = f;
                if (x.prev == null) {
                    this.first = x;
                } else {
                    x.prev.next = x;
                }
                f.prev = x;
                return x;
            }
            if (o == end) {
                f.off = off;
                return f;
            }
            if (f.end == off) {
                Frag x = f.next;
                if (x != null && x.off == end) {
                    f.end = x.end;
                    f.next = x.next;
                    if (f.next == null) {
                        this.last = f;
                    } else {
                        f.next.prev = f;
                    }
                } else {
                    f.end = end;
                }
                return f;
            }
            f = f.next;
        }
        Frag x = new Frag(off, end);
        if (this.last == null) {
            this.first = x;
            this.last = x;
        } else {
            x.prev = this.last;
            this.last.next = x;
            this.last = x;
        }
        return x;
    }

    @Override
    public synchronized void check() throws IOException {
        Frag prev = null;
        int prevEnd = -1;
        Frag frag = this.first;
        while (frag != null) {
            if (frag.off < prevEnd) {
                throw new IOException("Invalid fragment offset: " + frag.off + " < " + prevEnd);
            }
            if (frag.off == prevEnd) {
                throw new IOException("Unnecessary fragment: " + frag.off + " == " + prevEnd);
            }
            prev = frag;
            prevEnd = frag.end;
            frag = frag.next;
        }
        if (this.last != prev) {
            throw new IOException("Invalid last fragment: " + this.last + " != " + prev);
        }
    }

    @Override
    public synchronized void dump(StringBuffer sb) {
        Frag frag = this.first;
        while (frag != null) {
            sb.append("   - Fragment: ofs=" + frag.off + ", len=" + frag.size() + ", end=" + frag.end).append('\n');
            frag = frag.next;
        }
    }

    public String toString() {
        return super.toString() + "[size=" + this.size + "]";
    }

    protected abstract void dispose() throws IOException;
}

