/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.heap;

import com.spacekiller.util.Platform;
import com.spacekiller.util.PreferencesObject;
import com.spacekiller.util.heap.AreaConfig;
import com.spacekiller.util.heap.HeapConfig;
import java.io.Serializable;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DefaultHeapConfig
extends PreferencesObject
implements HeapConfig,
Serializable {
    private static final Logger logger = Platform.getLogger(DefaultHeapConfig.class);
    private static final long serialVersionUID = 678934679439838L;
    private String name;
    private int defaultPageSize;
    private int copyBufferSize;
    private boolean javaHeapPreferred = true;
    private AreaConfig javaHeapAreaConfig;
    private AreaConfig directHeapAreaConfig;
    private AreaConfig swapFileAreaConfig;

    public DefaultHeapConfig() {
        super(false);
    }

    protected void setDefaults() {
        super.setDefaults();
        try {
            this.setFieldValues((DefaultHeapConfig)this.getClass().newInstance());
        }
        catch (Throwable e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    @Override
    public boolean isJavaHeapPreferred() {
        return this.javaHeapPreferred;
    }

    public void setJavaHeapPreferred(boolean javaHeapPreferred) {
        this.javaHeapPreferred = javaHeapPreferred;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public AreaConfig getJavaHeapAreaConfig() {
        return this.javaHeapAreaConfig;
    }

    public void setJavaHeapAreaConfig(AreaConfig javaHeapAreaConfig) {
        this.javaHeapAreaConfig = javaHeapAreaConfig;
    }

    @Override
    public AreaConfig getDirectHeapAreaConfig() {
        return this.directHeapAreaConfig;
    }

    public void setDirectHeapAreaConfig(AreaConfig directHeapAreaConfig) {
        this.directHeapAreaConfig = directHeapAreaConfig;
    }

    @Override
    public AreaConfig getSwapFileAreaConfig() {
        return this.swapFileAreaConfig;
    }

    public void setSwapFileAreaConfig(AreaConfig swapFileAreaConfig) {
        this.swapFileAreaConfig = swapFileAreaConfig;
    }

    @Override
    public int getDefaultPageSize() {
        return this.defaultPageSize;
    }

    public void setDefaultPageSize(int defaultPageSize) {
        this.defaultPageSize = defaultPageSize;
    }

    @Override
    public int getCopyBufferSize() {
        return this.copyBufferSize;
    }

    public void setCopyBufferSize(int copyBufferSize) {
        this.copyBufferSize = copyBufferSize;
    }
}

