/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.heap;

import com.spacekiller.util.heap.AbstractPage;
import com.spacekiller.util.heap.Area;
import com.spacekiller.util.heap.ByteArrayPage;
import com.spacekiller.util.heap.ByteBufferPage;
import com.spacekiller.util.heap.Page;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;

public class SwapFilePage
extends AbstractPage {
    protected final byte[] cb;
    protected RandomAccessFile raf;
    protected FileChannel fc;
    protected long pos;

    public SwapFilePage(Area area, int size, long pos, byte[] copyBuf, RandomAccessFile raf, FileChannel fc) {
        super(area, size);
        this.pos = pos;
        this.cb = copyBuf;
        this.raf = raf;
        this.fc = fc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void read(int off, byte[] arr, int ofs, int len) throws IOException {
        RandomAccessFile randomAccessFile = this.raf;
        synchronized (randomAccessFile) {
            this.raf.seek(this.pos + (long)off);
            this.raf.readFully(arr, ofs, len);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(int off, byte[] arr, int ofs, int len) throws IOException {
        RandomAccessFile randomAccessFile = this.raf;
        synchronized (randomAccessFile) {
            this.raf.seek(this.pos + (long)off);
            this.raf.write(arr, ofs, len);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void read(int off, ByteBuffer buf) throws IOException {
        RandomAccessFile randomAccessFile = this.raf;
        synchronized (randomAccessFile) {
            int n;
            this.fc.position(this.pos + (long)off);
            for (int len = buf.remaining(); len > 0; len -= n) {
                n = this.fc.read(buf);
                if (n >= 1) continue;
                throw new EOFException();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(int off, ByteBuffer buf) throws IOException {
        RandomAccessFile randomAccessFile = this.raf;
        synchronized (randomAccessFile) {
            int n;
            this.fc.position(this.pos + (long)off);
            for (int len = buf.remaining(); len > 0; len -= n) {
                n = this.fc.write(buf);
                if (n >= 1) continue;
                throw new EOFException();
            }
        }
    }

    @Override
    public void read(int off, OutputStream dst, int len) throws IOException {
        byte[] byArray = this.cb;
        synchronized (this.cb) {
            RandomAccessFile randomAccessFile = this.raf;
            synchronized (randomAccessFile) {
                this.raf.seek(this.pos + (long)off);
                while (true) {
                    int n = Math.min(len, this.cb.length);
                    this.raf.readFully(this.cb, 0, n);
                    dst.write(this.cb, 0, n);
                    if (n >= len) {
                        // MONITOREXIT @DISABLED, blocks:[0, 1, 2, 3, 6, 7] lbl13 : MonitorExitStatement: MONITOREXIT : var6_5
                        // ** MonitorExit[var5_4] (shouldn't be in output)
                        return;
                    }
                    len -= n;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int write(int off, InputStream src, int len) throws IOException {
        int n = Math.min(len, this.cb.length);
        byte[] byArray = this.cb;
        synchronized (this.cb) {
            n = src.read(this.cb, 0, n);
            if (n < 1) {
                // ** MonitorExit[var5_5] (shouldn't be in output)
                return n == 0 ? 0 : -1;
            }
            RandomAccessFile randomAccessFile = this.raf;
            synchronized (randomAccessFile) {
                this.raf.seek(this.pos + (long)off);
                this.raf.write(this.cb, 0, n);
            }
            // ** MonitorExit[var5_5] (shouldn't be in output)
            return n;
        }
    }

    @Override
    public void get(int off, Page dst, int ofs, int len) throws IOException {
        dst.put(ofs, this, off, len);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(int off, Page src, int ofs, int len) throws IOException {
        if (src instanceof ByteArrayPage || src instanceof ByteBufferPage) {
            src.get(ofs, this, off, len);
            return;
        }
        byte[] byArray = this.cb;
        synchronized (this.cb) {
            while (true) {
                int n = Math.min(len, this.cb.length);
                src.read(ofs, this.cb, 0, n);
                RandomAccessFile randomAccessFile = this.raf;
                synchronized (randomAccessFile) {
                    this.raf.seek(this.pos + (long)off);
                    this.raf.write(this.cb, 0, n);
                }
                if (n >= len) {
                    // ** MonitorExit[var6_5] (shouldn't be in output)
                    return;
                }
                off += n;
                len -= n;
            }
        }
    }

    @Override
    protected void dispose() throws IOException {
    }
}

