/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.workbench;

import com.spacekiller.util.Preferences;
import com.spacekiller.util.workbench.ComponentView;
import com.spacekiller.util.workbench.PreferencesPage;
import com.spacekiller.util.workbench.View;
import java.awt.Component;
import java.beans.PropertyVetoException;
import java.lang.reflect.InvocationTargetException;
import javax.swing.Icon;

public abstract class AbstractPreferencesPage
implements PreferencesPage {
    private String parentId;
    private String id;
    private String name;
    private Icon icon;
    private String tooltip;
    private double priority;

    @Override
    public Icon getIcon() {
        return this.icon;
    }

    public void setIcon(Icon icon) {
        this.icon = icon;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getTooltip() {
        return this.tooltip;
    }

    public void setTooltip(String tooltip) {
        this.tooltip = tooltip;
    }

    @Override
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String getParentId() {
        return this.parentId;
    }

    public void setParentId(String parentId) {
        this.parentId = parentId;
    }

    @Override
    public View createView() throws Exception {
        Component comp = this.createComponent();
        if (comp != null) {
            ComponentView view = new ComponentView(comp);
            return view;
        }
        return null;
    }

    public abstract Component createComponent();

    @Override
    public double getPriority() {
        return this.priority;
    }

    public void setPriority(double priority) {
        this.priority = priority;
    }

    protected static Object getObject(Preferences prefs, String key) throws IllegalAccessException, InvocationTargetException {
        if (prefs == null) {
            throw new IllegalAccessException("No preferences specified");
        }
        if (!prefs.contains(key)) {
            throw new IllegalAccessException("Property not found: " + key);
        }
        return prefs.getObject(key);
    }

    protected static boolean getBoolean(Preferences prefs, String key) throws IllegalAccessException, InvocationTargetException {
        if (prefs == null) {
            throw new IllegalAccessException("No preferences specified");
        }
        if (!prefs.contains(key)) {
            throw new IllegalAccessException("Property not found: " + key);
        }
        return prefs.getBoolean(key);
    }

    protected static byte getByte(Preferences prefs, String key) throws IllegalAccessException, InvocationTargetException {
        if (prefs == null) {
            throw new IllegalAccessException("No preferences specified");
        }
        if (!prefs.contains(key)) {
            throw new IllegalAccessException("Property not found: " + key);
        }
        return prefs.getByte(key);
    }

    protected static char getChar(Preferences prefs, String key) throws IllegalAccessException, InvocationTargetException {
        if (prefs == null) {
            throw new IllegalAccessException("No preferences specified");
        }
        if (!prefs.contains(key)) {
            throw new IllegalAccessException("Property not found: " + key);
        }
        return prefs.getChar(key);
    }

    protected static short getShort(Preferences prefs, String key) throws IllegalAccessException, InvocationTargetException {
        if (prefs == null) {
            throw new IllegalAccessException("No preferences specified");
        }
        if (!prefs.contains(key)) {
            throw new IllegalAccessException("Property not found: " + key);
        }
        return prefs.getShort(key);
    }

    protected static int getInt(Preferences prefs, String key) throws IllegalAccessException, InvocationTargetException {
        if (prefs == null) {
            throw new IllegalAccessException("No preferences specified");
        }
        if (!prefs.contains(key)) {
            throw new IllegalAccessException("Property not found: " + key);
        }
        return prefs.getInt(key);
    }

    protected static long getLong(Preferences prefs, String key) throws IllegalAccessException, InvocationTargetException {
        if (prefs == null) {
            throw new IllegalAccessException("No preferences specified");
        }
        if (!prefs.contains(key)) {
            throw new IllegalAccessException("Property not found: " + key);
        }
        return prefs.getLong(key);
    }

    protected static float getFloat(Preferences prefs, String key) throws IllegalAccessException, InvocationTargetException {
        if (prefs == null) {
            throw new IllegalAccessException("No preferences specified");
        }
        if (!prefs.contains(key)) {
            throw new IllegalAccessException("Property not found: " + key);
        }
        return prefs.getFloat(key);
    }

    protected static double getDouble(Preferences prefs, String key) throws IllegalAccessException, InvocationTargetException {
        if (prefs == null) {
            throw new IllegalAccessException("No preferences specified");
        }
        if (!prefs.contains(key)) {
            throw new IllegalAccessException("Property not found: " + key);
        }
        return prefs.getDouble(key);
    }

    protected static Object getObject(Preferences prefs, String key, Object defaultValue) throws IllegalAccessException, InvocationTargetException {
        if (prefs != null && prefs.contains(key)) {
            return prefs.getObject(key);
        }
        return defaultValue;
    }

    protected static boolean getBoolean(Preferences prefs, String key, boolean defaultValue) throws IllegalAccessException, InvocationTargetException {
        if (prefs != null && prefs.contains(key)) {
            return prefs.getBoolean(key);
        }
        return defaultValue;
    }

    protected static byte getByte(Preferences prefs, String key, byte defaultValue) throws IllegalAccessException, InvocationTargetException {
        if (prefs != null && prefs.contains(key)) {
            return prefs.getByte(key);
        }
        return defaultValue;
    }

    protected static char getChar(Preferences prefs, String key, char defaultValue) throws IllegalAccessException, InvocationTargetException {
        if (prefs != null && prefs.contains(key)) {
            return prefs.getChar(key);
        }
        return defaultValue;
    }

    protected static short getShort(Preferences prefs, String key, short defaultValue) throws IllegalAccessException, InvocationTargetException {
        if (prefs != null && prefs.contains(key)) {
            return prefs.getShort(key);
        }
        return defaultValue;
    }

    protected static int getInt(Preferences prefs, String key, int defaultValue) throws IllegalAccessException, InvocationTargetException {
        if (prefs != null && prefs.contains(key)) {
            return prefs.getInt(key);
        }
        return defaultValue;
    }

    protected static long getLong(Preferences prefs, String key, long defaultValue) throws IllegalAccessException, InvocationTargetException {
        if (prefs != null && prefs.contains(key)) {
            return prefs.getLong(key);
        }
        return defaultValue;
    }

    protected static float getFloat(Preferences prefs, String key, float defaultValue) throws IllegalAccessException, InvocationTargetException {
        if (prefs != null && prefs.contains(key)) {
            return prefs.getFloat(key);
        }
        return defaultValue;
    }

    protected static double getDouble(Preferences prefs, String key, double defaultValue) throws IllegalAccessException, InvocationTargetException {
        if (prefs != null && prefs.contains(key)) {
            return prefs.getDouble(key);
        }
        return defaultValue;
    }

    protected static void setBoolean(Preferences prefs, String key, Object value) throws IllegalAccessException, InvocationTargetException, PropertyVetoException {
        boolean v = "true".equalsIgnoreCase(String.valueOf(value));
        prefs.setBoolean(key, v);
    }

    protected static void setByte(Preferences prefs, String key, Object value) throws IllegalAccessException, InvocationTargetException, PropertyVetoException {
        try {
            byte v = Byte.parseByte(String.valueOf(value).trim());
            prefs.setByte(key, v);
        }
        catch (NumberFormatException e) {
            throw new IllegalAccessException("Invalid byte value specified for property " + key + ": " + value);
        }
    }

    protected static void setChar(Preferences prefs, String key, Object value) throws IllegalAccessException, InvocationTargetException, PropertyVetoException {
        if (value == null) {
            throw new IllegalAccessException("Invalid char value specified for property " + key + ": " + value);
        }
        String s = String.valueOf(value);
        if (s.length() < 1) {
            throw new IllegalAccessException("Invalid char value specified for property " + key + ": " + value);
        }
        char v = s.charAt(0);
        prefs.setChar(key, v);
    }

    protected static void setShort(Preferences prefs, String key, Object value) throws IllegalAccessException, InvocationTargetException, PropertyVetoException {
        try {
            short v = Short.parseShort(String.valueOf(value).trim());
            prefs.setShort(key, v);
        }
        catch (NumberFormatException e) {
            throw new IllegalAccessException("Invalid short value specified for property " + key + ": " + value);
        }
    }

    protected static void setInt(Preferences prefs, String key, Object value) throws IllegalAccessException, InvocationTargetException, PropertyVetoException {
        try {
            int v = Integer.parseInt(String.valueOf(value).trim());
            prefs.setInt(key, v);
        }
        catch (NumberFormatException e) {
            throw new IllegalAccessException("Invalid int value specified for property " + key + ": " + value);
        }
    }

    protected static void setLong(Preferences prefs, String key, Object value) throws IllegalAccessException, InvocationTargetException, PropertyVetoException {
        try {
            long v = Long.parseLong(String.valueOf(value).trim());
            prefs.setLong(key, v);
        }
        catch (NumberFormatException e) {
            throw new IllegalAccessException("Invalid long value specified for property " + key + ": " + value);
        }
    }

    protected static void setFloat(Preferences prefs, String key, Object value) throws IllegalAccessException, InvocationTargetException, PropertyVetoException {
        try {
            float v = Float.parseFloat(String.valueOf(value).trim());
            prefs.setFloat(key, v);
        }
        catch (NumberFormatException e) {
            throw new IllegalAccessException("Invalid float value specified for property " + key + ": " + value);
        }
    }

    protected static void setDouble(Preferences prefs, String key, Object value) throws IllegalAccessException, InvocationTargetException, PropertyVetoException {
        try {
            double v = Double.parseDouble(String.valueOf(value).trim());
            prefs.setDouble(key, v);
        }
        catch (NumberFormatException e) {
            throw new IllegalAccessException("Invalid double value specified for property " + key + ": " + value);
        }
    }
}

