/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.workbench;

import com.spacekiller.util.beans.Selection;
import com.spacekiller.util.beans.SelectionEvent;
import com.spacekiller.util.beans.SelectionListener;
import com.spacekiller.util.workbench.SelectionCondition;
import com.spacekiller.util.workbench.SelectionManager;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public abstract class AbstractSelectionManager
implements SelectionManager {
    private Selection selection;
    private SelectionHandler selectionHandler = new SelectionHandler();
    private Set selectionConditions = new HashSet();

    @Override
    public Selection getSelection() {
        return this.selection;
    }

    protected synchronized void setSelection(Selection sel) {
        if (this.selection == sel) {
            return;
        }
        if (this.selection != null) {
            this.selection.removeSelectionListener((SelectionListener)this.selectionHandler);
        }
        this.selection = sel;
        if (this.selection != null) {
            this.selection.addSelectionListener((SelectionListener)this.selectionHandler);
        }
        this.fireSelectionChanged();
    }

    @Override
    public void addSelectionCondition(SelectionCondition condition) {
        if (condition == null) {
            return;
        }
        this.selectionConditions.add(condition);
        condition.selectionChanged(this.selection);
    }

    @Override
    public void removeSelectionCondition(SelectionCondition condition) {
        this.selectionConditions.remove((Object)condition);
    }

    protected synchronized void fireSelectionChanged() {
        Selection sel = this.selection;
        Iterator i = this.selectionConditions.iterator();
        while (i.hasNext()) {
            ((SelectionCondition)((Object)i.next())).selectionChanged(sel);
        }
    }

    protected class SelectionHandler
    implements SelectionListener {
        protected SelectionHandler() {
        }

        public void selectionChanged(SelectionEvent ev) {
            AbstractSelectionManager.this.fireSelectionChanged();
        }
    }
}

