/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.workbench;

import com.spacekiller.util.BeansToolkit;
import com.spacekiller.util.ClassRegistry;
import com.spacekiller.util.Filter;
import com.spacekiller.util.beans.components.ClassChooser;
import com.spacekiller.util.beans.components.NewObjectPanel;
import com.spacekiller.util.workbench.AbstractConstructorView;
import com.spacekiller.util.workbench.View;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.Constructor;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ConstructorView
extends AbstractConstructorView {
    private BeansToolkit beansToolkit;
    private ClassRegistry classRegistry;
    private NewObjectPanel newObjectPanel;
    private Filter classFilter;
    private int emptySearchAction = ClassChooser.EMPTY_DO_NOTHING;
    private Filter internalFilter;
    private static final Logger logger = Logger.getLogger(ConstructorView.class.getName());

    @Override
    protected Component createComponent() {
        return this.getNewObjectPanel();
    }

    @Override
    protected void installChildComponent(View child, Component childComponent) {
    }

    @Override
    protected void uninstallChildComponent(View child, Component childComponent) {
    }

    protected NewObjectPanel createNewObjectPanel() {
        NewObjectPanel panel = new NewObjectPanel();
        panel.setBeansToolkit(this.beansToolkit);
        panel.setClassRegistry(this.classRegistry);
        Object newFilter = this.internalFilter = panel.getClassFilter();
        if (this.classFilter != null) {
            newFilter = newFilter == null ? this.classFilter : new ClassChooser.MultiClassFilter(new Filter[]{this.internalFilter, this.classFilter});
        }
        panel.setClassFilter(newFilter);
        panel.setEmptySearchAction(this.emptySearchAction);
        panel.setPreferredSize(new Dimension(400, 400));
        panel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConstructorView.this.actionCreate();
            }
        });
        return panel;
    }

    public NewObjectPanel getNewObjectPanel() {
        if (this.newObjectPanel == null) {
            this.setNewObjectPanel(this.createNewObjectPanel());
        }
        return this.newObjectPanel;
    }

    protected void setNewObjectPanel(NewObjectPanel newObjectPanel) {
        this.newObjectPanel = newObjectPanel;
    }

    public BeansToolkit getBeansToolkit() {
        return this.beansToolkit;
    }

    public void setBeansToolkit(BeansToolkit beansToolkit) {
        this.beansToolkit = beansToolkit;
    }

    public ClassRegistry getClassRegistry() {
        return this.classRegistry;
    }

    public void setClassRegistry(ClassRegistry classRegistry) {
        this.classRegistry = classRegistry;
    }

    protected void actionCreate() {
        try {
            Constructor constr = this.getNewObjectPanel().getSelectedConstructor();
            logger.fine("create object: " + constr);
            Object[] params = this.getNewObjectPanel().getParameterValues();
            Object obj = constr.newInstance(params);
            logger.fine("Insert object: " + obj);
            this.publish(obj);
        }
        catch (Throwable e) {
            this.handleException(e);
        }
    }

    @Override
    protected void handleException(Throwable e) {
        logger.log(Level.SEVERE, e.getMessage(), e);
    }

    public Filter getClassFilter() {
        return this.classFilter;
    }

    public void setClassFilter(Filter classFilter) {
        this.classFilter = classFilter;
    }

    public int getEmptySearchAction() {
        return this.emptySearchAction;
    }

    public void setEmptySearchAction(int emptySearchAction) {
        this.emptySearchAction = emptySearchAction;
    }
}

