/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.workbench;

import com.spacekiller.util.BeansToolkit;
import com.spacekiller.util.beans.BeanDropSupport;
import com.spacekiller.util.workbench.CustomizerView;
import com.spacekiller.util.workbench.DefaultViewProvider;
import com.spacekiller.util.workbench.View;
import com.spacekiller.util.workbench.WorkbenchUtilities;
import com.spacekiller.util.workspace.WorkspacePlugin;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CustomizerViewProvider
extends DefaultViewProvider {
    private static final Logger logger = Logger.getLogger(CustomizerViewProvider.class.getName());

    @Override
    protected void initView(View v) {
        super.initView(v);
        if (v instanceof CustomizerView) {
            CustomizerView cv = (CustomizerView)v;
            cv.setTitle(this.getName());
            cv.setTooltip(this.getTooltip());
            cv.setIcon(this.getIcon());
            try {
                WorkspacePlugin wsPlugin = WorkbenchUtilities.getWorkspacePlugin();
                logger.fine("WorkspacePlugin: " + wsPlugin);
                BeansToolkit btk = wsPlugin.getBeansToolkit();
                logger.fine("BeansToolkit: " + btk);
                BeanDropSupport dropSupport = wsPlugin.getBeanDropSupport();
                logger.fine("BeanDropSupport: " + dropSupport);
                cv.setBeansToolkit(btk);
                cv.setClassRegistry(btk.getClassRegistry());
                cv.setBeanDropSupport(dropSupport);
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, e.getMessage(), e);
            }
        }
    }
}

