/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.workbench;

import com.spacekiller.util.Preferences;
import com.spacekiller.util.Tools;
import com.spacekiller.util.workbench.View;
import com.spacekiller.util.workbench.ViewConstraints;
import com.spacekiller.util.workbench.ViewProvider;
import javax.swing.Icon;

public class DefaultViewProvider
implements ViewProvider {
    private String id;
    private String name;
    private String tooltip;
    private Icon icon;
    private double priority;
    private String viewClassName;

    @Override
    public Icon getIcon() {
        return this.icon;
    }

    public void setIcon(Icon icon) {
        this.icon = icon;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getTooltip() {
        return this.tooltip;
    }

    public void setTooltip(String tooltip) {
        this.tooltip = tooltip;
    }

    public String getViewClassName() {
        return this.viewClassName;
    }

    public void setViewClassName(String viewClassName) {
        this.viewClassName = viewClassName;
    }

    protected Class getViewClass() throws Exception {
        return Class.forName(this.getViewClassName());
    }

    @Override
    public View createView() throws Exception {
        Class viewClass = this.getViewClass();
        if (viewClass != null) {
            if (!View.class.isAssignableFrom(viewClass)) {
                throw new ClassCastException("Invalid view class: " + viewClass);
            }
            View view = (View)Tools.newInstance((Class)viewClass);
            this.initView(view);
            return view;
        }
        return null;
    }

    protected void initView(View v) {
        v.setProvider(this);
        v.setTitle(this.getName());
        v.setTooltip(this.getTooltip());
        v.setIcon(this.getIcon());
    }

    @Override
    public double getPriority() {
        return this.priority;
    }

    public void setPriority(double priority) {
        this.priority = priority;
    }

    @Override
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    @Override
    public void saveView(View view, Preferences prefs) throws Exception {
        prefs.setObject("name", (Object)view.getName());
        prefs.setObject("title", (Object)view.getTitle());
        prefs.setObject("tooltip", (Object)view.getTooltip());
        prefs.setObject("viewConstraints", (Object)view.getViewConstraints());
    }

    @Override
    public View loadView(Preferences prefs) throws Exception {
        View view = this.createView();
        this.loadView(view, prefs);
        return view;
    }

    protected void loadView(View view, Preferences prefs) throws Exception {
        Object objConstr;
        Object objTooltip;
        Object objTitle;
        Object objName = prefs.getObject("name");
        if (objName != null) {
            view.setName(String.valueOf(objName));
        }
        if ((objTitle = prefs.getObject("title")) != null) {
            view.setTitle(String.valueOf(objTitle));
        }
        if ((objTooltip = prefs.getObject("tooltip")) != null) {
            view.setTooltip(String.valueOf(objTooltip));
        }
        if ((objConstr = prefs.getObject("viewConstraints")) != null && objConstr instanceof ViewConstraints) {
            view.setViewConstraints((ViewConstraints)objConstr);
        }
    }
}

