/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.workbench;

import com.spacekiller.util.Extension;
import com.spacekiller.util.ExtensionPoint;
import com.spacekiller.util.Plugin;
import com.spacekiller.util.Tools;
import com.spacekiller.util.beans.CustomizerProvider;
import com.spacekiller.util.beans.IconProvider;
import com.spacekiller.util.swing.AbstractLookAndFeelStyle;
import com.spacekiller.util.swing.AbstractLookAndFeelType;
import com.spacekiller.util.swing.LookAndFeelManager;
import com.spacekiller.util.swing.LookAndFeelStyle;
import com.spacekiller.util.swing.LookAndFeelType;
import com.spacekiller.util.tooling.Tool;
import com.spacekiller.util.tooling.ToolProvider;
import com.spacekiller.util.workbench.ObjectTypeTool;
import com.spacekiller.util.workbench.Perspective;
import com.spacekiller.util.workbench.PreferencesPage;
import com.spacekiller.util.workbench.ViewProvider;
import com.spacekiller.util.workbench.WorkbenchPlugin;
import com.spacekiller.util.workspace.WorkspacePlugin;
import java.awt.Window;
import java.beans.beancontext.BeanContext;
import java.beans.beancontext.BeanContextMembershipEvent;
import java.beans.beancontext.BeanContextMembershipListener;
import java.beans.beancontext.BeanContextSupport;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;

public class DefaultWorkbenchPlugin
extends Plugin
implements WorkbenchPlugin {
    private static final Logger logger = Logger.getLogger(DefaultWorkbenchPlugin.class.getName());
    private static final Class[] NO_PARAMS = new Class[0];
    private static final Object[] NO_ARGS = new Object[0];
    private boolean debug = false;
    private List extensions = new ArrayList();
    private BeanContext lookAndFeelTypes;
    private BeanContext iconProviders;
    private BeanContext customizerProviders;
    private BeanContext views;
    private BeanContext tools;
    private BeanContext toolProviders;
    private BeanContext preferencesPages;
    private BeanContext perspectives;
    private BeanContext newObjectActions;
    private Map newObjectActionMap;
    private LookAndFeelManager lafManager;
    private LookAndFeelTypeHandler lafTypeHandler = new LookAndFeelTypeHandler();
    private WorkspacePlugin workspacePlugin;
    private Method getWindowsMethod;
    private boolean getWindowsUnavailable;

    protected Extension[] getExtensions(String pointId) {
        ArrayList<Extension> list = new ArrayList<Extension>();
        int num = this.extensions.size();
        for (int c = 0; c < num; ++c) {
            Extension ext = (Extension)this.extensions.get(c);
            String pid = ext.getExtensionPointId();
            if (pid == null || !pointId.equals(pid)) continue;
            list.add(ext);
        }
        Extension[] rc = new Extension[list.size()];
        rc = list.toArray(rc);
        return rc;
    }

    protected void extensionAvailable(ExtensionPoint point, Extension x) {
        if (this.debug) {
            logger.fine("WorkbenchPlugin.Extension available: " + point.getId() + " => " + x);
        }
        this.extensions.add(x);
        String pid = point.getId();
        try {
            if (pid.equals("com.spacekiller.util.swing.LookAndFeelType")) {
                LookAndFeelType lafType;
                if (this.lookAndFeelTypes != null && (lafType = this.createLookAndFeelType(x)) != null) {
                    this.lookAndFeelTypes.add(lafType);
                }
                return;
            }
            if (pid.equals("com.spacekiller.util.beans.IconProvider")) {
                IconProvider obj;
                if (this.iconProviders != null && (obj = this.createIconProvider(x)) != null) {
                    this.iconProviders.add(obj);
                }
                return;
            }
            if (pid.equals("com.spacekiller.util.beans.CustomizerProvider")) {
                CustomizerProvider obj;
                if (this.customizerProviders != null && (obj = this.createCustomizerProvider(x)) != null) {
                    this.customizerProviders.add(obj);
                }
                return;
            }
            if (pid.equals("com.spacekiller.util.workbench.Perspective")) {
                Perspective obj;
                if (this.perspectives != null && (obj = this.createPerspective(x)) != null) {
                    this.perspectives.add(obj);
                }
                return;
            }
            if (pid.equals("com.spacekiller.util.workbench.ViewProvider")) {
                ViewProvider obj;
                if (this.views != null && (obj = this.createViewProvider(x)) != null) {
                    this.views.add(obj);
                }
                return;
            }
            if (pid.equals("com.spacekiller.util.tooling.Tool")) {
                Tool obj;
                if (this.tools != null && (obj = this.createTool(x)) != null) {
                    this.tools.add(obj);
                }
                return;
            }
            if (pid.equals("com.spacekiller.util.workbench.PreferencesPage")) {
                PreferencesPage obj;
                if (this.preferencesPages != null && (obj = this.createPreferencesPage(x)) != null) {
                    this.preferencesPages.add(obj);
                }
                return;
            }
            if (pid.equals("com.spacekiller.util.workbench.NewObjectAction")) {
                return;
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    protected void extensionUnavailable(ExtensionPoint point, Extension x) {
        logger.fine("TODO WorkbenchPlugin.Extension unavailable: " + x);
        if (this.extensions.remove(x)) {
            // empty if block
        }
    }

    protected void startup() {
        super.startup();
    }

    protected void shutdown() {
        super.shutdown();
    }

    protected void initIconProviders() throws Exception {
        Extension[] x = this.getExtensions("com.spacekiller.util.beans.IconProvider");
        for (int c = 0; c < x.length; ++c) {
            IconProvider obj = this.createIconProvider(x[c]);
            if (obj == null) continue;
            this.iconProviders.add(obj);
        }
    }

    protected void initCustomizerProviders() throws Exception {
        Extension[] x = this.getExtensions("com.spacekiller.util.beans.CustomizerProvider");
        for (int c = 0; c < x.length; ++c) {
            CustomizerProvider obj = this.createCustomizerProvider(x[c]);
            if (obj == null) continue;
            this.customizerProviders.add(obj);
        }
    }

    protected void initLookAndFeelTypes() throws Exception {
        this.initDefaultLookAndFeelTypes();
        Extension[] x = this.getExtensions("com.spacekiller.util.swing.LookAndFeelType");
        for (int c = 0; c < x.length; ++c) {
            LookAndFeelType lafType = this.createLookAndFeelType(x[c]);
            if (lafType == null) continue;
            this.lookAndFeelTypes.add(lafType);
        }
    }

    protected void initDefaultLookAndFeelTypes() throws Exception {
        UIManager.LookAndFeelInfo[] installed = UIManager.getInstalledLookAndFeels();
        if (installed != null) {
            if (this.debug) {
                logger.fine(" - Default LookAndFeel types: " + installed.length);
            }
            for (int c = 0; c < installed.length; ++c) {
                String className = installed[c].getClassName();
                Class<?> lafClass = Class.forName(className);
                InstalledLookAndFeelType lafType = new InstalledLookAndFeelType(lafClass, installed[c].getName());
                this.lookAndFeelTypes.add(lafType);
            }
        }
    }

    protected void initPerspectives() throws Exception {
        Extension[] x = this.getExtensions("com.spacekiller.util.workbench.Perspective");
        for (int c = 0; c < x.length; ++c) {
            Perspective obj = this.createPerspective(x[c]);
            if (obj == null) continue;
            this.perspectives.add(obj);
        }
    }

    protected void initViewProviders() throws Exception {
        Extension[] x = this.getExtensions("com.spacekiller.util.workbench.ViewProvider");
        for (int c = 0; c < x.length; ++c) {
            ViewProvider obj = this.createViewProvider(x[c]);
            if (obj == null) continue;
            this.views.add(obj);
        }
    }

    protected void initTools() throws Exception {
        Extension[] x = this.getExtensions("com.spacekiller.util.tooling.Tool");
        for (int c = 0; c < x.length; ++c) {
            Tool obj = this.createTool(x[c]);
            if (obj == null) continue;
            this.tools.add(obj);
        }
    }

    protected void initToolProviders() throws Exception {
        Extension[] x = this.getExtensions("com.spacekiller.util.tooling.ToolProvider");
        for (int c = 0; c < x.length; ++c) {
            ToolProvider obj = this.createToolProvider(x[c]);
            if (obj == null) continue;
            this.toolProviders.add(obj);
        }
    }

    protected void initNewObjectActions() throws Exception {
        Extension[] x = this.getExtensions("com.spacekiller.util.workbench.NewObjectAction");
        for (int c = 0; c < x.length; ++c) {
            ObjectTypeTool typeTool;
            String[] types;
            Tool obj = this.createTool(x[c]);
            if (obj == null) continue;
            this.newObjectActions.add(obj);
            if (!(obj instanceof ObjectTypeTool) || (types = (typeTool = (ObjectTypeTool)obj).getTypeNames()) == null) continue;
            for (int i = 0; i < types.length; ++i) {
                String name = types[i];
                LinkedList<ObjectTypeTool> list = (LinkedList<ObjectTypeTool>)this.newObjectActionMap.get(name);
                if (list == null) {
                    list = new LinkedList<ObjectTypeTool>();
                    this.newObjectActionMap.put(name, list);
                }
                list.add(typeTool);
            }
        }
    }

    protected void initPreferencesPages() throws Exception {
        Extension[] x = this.getExtensions("com.spacekiller.util.workbench.PreferencesPage");
        for (int c = 0; c < x.length; ++c) {
            PreferencesPage obj = this.createPreferencesPage(x[c]);
            if (obj == null) continue;
            this.preferencesPages.add(obj);
        }
    }

    protected IconProvider createIconProvider(Extension x) throws Exception {
        return (IconProvider)this.getExtensionInstance(x);
    }

    protected CustomizerProvider createCustomizerProvider(Extension x) throws Exception {
        return (CustomizerProvider)this.getExtensionInstance(x);
    }

    protected LookAndFeelType createLookAndFeelType(Extension x) throws Exception {
        return (LookAndFeelType)this.getExtensionInstance(x);
    }

    protected Perspective createPerspective(Extension x) throws Exception {
        return (Perspective)this.getExtensionInstance(x);
    }

    protected ViewProvider createViewProvider(Extension x) throws Exception {
        return (ViewProvider)this.getExtensionInstance(x);
    }

    protected Tool createTool(Extension x) throws Exception {
        return (Tool)this.getExtensionInstance(x);
    }

    protected ToolProvider createToolProvider(Extension x) throws Exception {
        return (ToolProvider)this.getExtensionInstance(x);
    }

    protected PreferencesPage createPreferencesPage(Extension x) throws Exception {
        return (PreferencesPage)this.getExtensionInstance(x);
    }

    @Override
    public BeanContext getIconProviders() throws Exception {
        if (this.iconProviders == null) {
            this.setIconProviders(new BeanContextSupport());
            this.initIconProviders();
        }
        return this.iconProviders;
    }

    private void setIconProviders(BeanContext iconProviders) {
        this.iconProviders = iconProviders;
    }

    @Override
    public BeanContext getCustomizerProviders() throws Exception {
        if (this.customizerProviders == null) {
            this.setCustomizerProviders(new BeanContextSupport());
            this.initCustomizerProviders();
        }
        return this.customizerProviders;
    }

    private void setCustomizerProviders(BeanContext customizerProviders) {
        this.customizerProviders = customizerProviders;
    }

    @Override
    public BeanContext getLookAndFeelTypes() throws Exception {
        if (this.lookAndFeelTypes == null) {
            this.setLookAndFeelTypes(new BeanContextSupport());
            this.lookAndFeelTypes.addBeanContextMembershipListener(this.lafTypeHandler);
            this.initLookAndFeelTypes();
        }
        return this.lookAndFeelTypes;
    }

    private void setLookAndFeelTypes(BeanContext lookAndFeelTypes) {
        this.lookAndFeelTypes = lookAndFeelTypes;
    }

    @Override
    public BeanContext getPerspectives() throws Exception {
        if (this.perspectives == null) {
            this.setPerspectives(new BeanContextSupport());
            this.initPerspectives();
        }
        return this.perspectives;
    }

    private void setPerspectives(BeanContext perspectives) {
        this.perspectives = perspectives;
    }

    @Override
    public BeanContext getTools() throws Exception {
        if (this.tools == null) {
            this.setTools(new BeanContextSupport());
            this.initTools();
            this.getToolProviders();
            this.getPreferencesPages();
        }
        return this.tools;
    }

    private void setTools(BeanContext toolProviders) {
        this.tools = toolProviders;
    }

    public BeanContext getToolProviders() throws Exception {
        if (this.toolProviders == null) {
            this.setToolProviders(new BeanContextSupport());
            this.initToolProviders();
        }
        return this.toolProviders;
    }

    private void setToolProviders(BeanContext toolProviders) {
        this.toolProviders = toolProviders;
    }

    @Override
    public BeanContext getNewObjectActions() throws Exception {
        if (this.newObjectActions == null) {
            this.newObjectActionMap = new HashMap();
            this.setNewObjectActions(new BeanContextSupport());
            this.initNewObjectActions();
        }
        return this.toolProviders;
    }

    private void setNewObjectActions(BeanContext newObjectActions) {
        this.newObjectActions = newObjectActions;
    }

    @Override
    public List getNewObjectActions(Object parent) throws Exception {
        return this.getNewObjectActions(parent.getClass());
    }

    @Override
    public List getNewObjectActions(Class parentType) throws Exception {
        List temp;
        Class<Object> type;
        this.getNewObjectActions();
        HashSet set = new HashSet();
        for (type = parentType; type != null; type = type.getSuperclass()) {
            temp = (List)this.newObjectActionMap.get(type.getName());
            if (temp == null) continue;
            set.addAll(temp);
        }
        Class<?>[] ifs = parentType.getInterfaces();
        if (ifs != null) {
            for (int i = 0; i < ifs.length; ++i) {
                type = ifs[i];
                temp = (List)this.newObjectActionMap.get(type.getName());
                if (temp == null) continue;
                set.addAll(temp);
            }
        }
        ArrayList list = new ArrayList(set.size());
        list.addAll(set);
        return list;
    }

    @Override
    public BeanContext getViewProviders() throws Exception {
        if (this.views == null) {
            this.setViews(new BeanContextSupport());
            this.initViewProviders();
        }
        return this.views;
    }

    private void setViews(BeanContext views) {
        this.views = views;
    }

    @Override
    public BeanContext getPreferencesPages() throws Exception {
        if (this.preferencesPages == null) {
            this.setPreferencesPages(new BeanContextSupport());
            this.initPreferencesPages();
        }
        return this.preferencesPages;
    }

    private void setPreferencesPages(BeanContext pages) {
        this.preferencesPages = pages;
    }

    @Override
    public LookAndFeelManager getLookAndFeelManager() {
        if (this.lafManager == null) {
            this.setLookAndFeelManager(LookAndFeelManager.getInstance());
        }
        return this.lafManager;
    }

    private void setLookAndFeelManager(LookAndFeelManager lafManager) {
        this.lafManager = lafManager;
    }

    protected WorkspacePlugin lookupWorkspacePlugin() throws Exception {
        String pluginId = "com.spacekiller.util.workspace.WorkspacePlugin";
        WorkspacePlugin wsp = (WorkspacePlugin)this.getPlatform().getPlugin(pluginId);
        return wsp;
    }

    protected WorkspacePlugin getWorkspacePlugin() throws Exception {
        if (this.workspacePlugin == null) {
            this.setWorkspacePlugin(this.lookupWorkspacePlugin());
        }
        return this.workspacePlugin;
    }

    private void setWorkspacePlugin(WorkspacePlugin workspacePlugin) {
        this.workspacePlugin = workspacePlugin;
    }

    @Override
    public ViewProvider getViewProvider(String id) throws Exception {
        BeanContext bc = this.getViewProviders();
        if (bc == null || id == null) {
            return null;
        }
        for (Object o : bc) {
            ViewProvider vp;
            if (!(o instanceof ViewProvider) || !id.equals((vp = (ViewProvider)o).getId())) continue;
            return vp;
        }
        return null;
    }

    @Override
    public Window[] lookupWindows() throws Exception {
        if (!this.getWindowsUnavailable) {
            Object result;
            if (this.getWindowsMethod == null) {
                try {
                    this.getWindowsMethod = Window.class.getMethod("getWindows", NO_PARAMS);
                }
                catch (Throwable e) {
                    this.getWindowsUnavailable = true;
                    logger.log(Level.SEVERE, e.getMessage(), e);
                }
            }
            if ((result = this.getWindowsMethod.invoke(null, NO_ARGS)) != null && result instanceof Window[]) {
                return (Window[])result;
            }
        }
        return null;
    }

    public static class InstalledLookAndFeelType
    extends AbstractLookAndFeelType {
        private Class lafClass;

        public InstalledLookAndFeelType(Class lafClass, String name) {
            this.lafClass = lafClass;
            this.setName(name);
            this.addStyle((LookAndFeelStyle)new AbstractLookAndFeelStyle(){

                public String getName() {
                    return "Default";
                }
            });
        }

        public LookAndFeel getLookAndFeel(LookAndFeelStyle style) {
            try {
                return (LookAndFeel)Tools.newInstance((Class)this.lafClass);
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, e.getMessage(), e);
                return null;
            }
        }

        public String toString() {
            return "DefaultLookAndFeelType[name=" + this.getName() + "]";
        }
    }

    protected class LookAndFeelTypeHandler
    implements BeanContextMembershipListener {
        protected LookAndFeelTypeHandler() {
        }

        @Override
        public void childrenAdded(BeanContextMembershipEvent bcme) {
            Iterator i = bcme.iterator();
            while (i.hasNext()) {
                Object bean = i.next();
                if (bean == null || !(bean instanceof LookAndFeelType)) continue;
                LookAndFeelType lafType = (LookAndFeelType)bean;
                DefaultWorkbenchPlugin.this.getLookAndFeelManager().addLookAndFeelType(lafType);
                if (!DefaultWorkbenchPlugin.this.debug) continue;
                logger.fine("LookAndFeelType registered: " + lafType);
            }
        }

        @Override
        public void childrenRemoved(BeanContextMembershipEvent bcme) {
            Iterator i = bcme.iterator();
            while (i.hasNext()) {
                Object bean = i.next();
                if (bean == null || !(bean instanceof LookAndFeelType)) continue;
                LookAndFeelType lafType = (LookAndFeelType)bean;
                DefaultWorkbenchPlugin.this.getLookAndFeelManager().removeLookAndFeelType(lafType);
                if (!DefaultWorkbenchPlugin.this.debug) continue;
                logger.fine("LookAndFeelType unregistered: " + lafType);
            }
        }
    }
}

