/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.workbench;

import com.spacekiller.util.EditorContext;
import com.spacekiller.util.Tools;
import com.spacekiller.util.swing.FullscreenSupport;
import com.spacekiller.util.tooling.ToolContext;
import com.spacekiller.util.tooling.ToolGroup;
import com.spacekiller.util.workbench.AnimatedDesktopManager;
import com.spacekiller.util.workbench.DefaultPerspective;
import com.spacekiller.util.workbench.DesktopPane;
import com.spacekiller.util.workbench.FullscreenView;
import com.spacekiller.util.workbench.Perspective;
import com.spacekiller.util.workbench.View;
import com.spacekiller.util.workbench.ViewConstraints;
import com.spacekiller.util.workbench.Workbench;
import com.spacekiller.util.workbench.WorkbenchContainer;
import com.spacekiller.util.workbench.WorkbenchUtilities;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetAdapter;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyVetoException;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.TooManyListenersException;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.DesktopManager;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JDesktopPane;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;

public class DesktopView
extends View {
    private Perspective perspective;
    private JScrollPane scrollPane;
    private JDesktopPane desktop;
    private DesktopManager desktopManager;
    private InternalFrameHandler internalFrameHandler = new InternalFrameHandler();
    private Map frameByChildView = new HashMap();
    private static final Logger logger = Logger.getLogger(DesktopView.class.getName());
    private MouseHandler mouseHandler = new MouseHandler();
    private boolean windowAnimationEnabled;
    private DetachedWindowHandler detachedWindowHandler;
    private boolean autoHideDetachedViews;
    private AutoHideChecker autoHideChecker = new AutoHideChecker();
    private boolean autoHideCancelled;
    private Collection hiddenDetachedWindows = new TreeSet(new DetachedWindowOrderComparator());
    private long nextZOrder = 1L;
    private long workbenchZOrder;
    private boolean showDetachedInProgress;

    protected DesktopView() {
    }

    public DesktopView(Perspective pers) {
        this();
        this.setPerspective(pers);
    }

    protected JDesktopPane createDesktop() {
        DesktopPane rc = new DesktopPane();
        rc.setRealOpaque(false);
        rc.addMouseListener(this.mouseHandler);
        rc.setDesktopManager(this.createDesktopManager(rc));
        return rc;
    }

    protected JDesktopPane getDesktop() {
        if (this.desktop == null) {
            this.setDesktop(this.createDesktop());
        }
        return this.desktop;
    }

    private void setDesktop(JDesktopPane desktop) {
        this.desktop = desktop;
    }

    protected JScrollPane createScrollPane() {
        JScrollPane pane = new JScrollPane();
        pane.setBorder(new CompoundBorder());
        pane.setViewportView(this.getDesktop());
        pane.setHorizontalScrollBarPolicy(30);
        pane.setVerticalScrollBarPolicy(20);
        return pane;
    }

    protected JScrollPane getScrollPane() {
        if (this.scrollPane == null) {
            this.setScrollPane(this.createScrollPane());
        }
        return this.scrollPane;
    }

    private void setScrollPane(JScrollPane scrollPane) {
        this.scrollPane = scrollPane;
    }

    @Override
    protected Component createComponent() {
        return this.getScrollPane();
    }

    @Override
    protected void installChildComponent(View child, Component childComponent) {
        if (child == null) {
            return;
        }
        ViewFrame frame1 = new ViewFrame(child);
        frame1.setMaximizable(true);
        frame1.setIconifiable(true);
        frame1.setResizable(true);
        frame1.setClosable(true);
        frame1.setTitle(String.valueOf(child.getTitle()));
        Icon icon = child.getIcon();
        if (icon != null) {
            frame1.setFrameIcon(icon);
        }
        this.frameByChildView.put(child, frame1);
        frame1.addInternalFrameListener(this.internalFrameHandler);
        frame1.setDefaultCloseOperation(0);
        child.setEditorContext(new EditorContextImpl(child, frame1));
        if (childComponent == null) {
            childComponent = child.getComponent();
        }
        if (childComponent instanceof Container) {
            frame1.setContentPane((Container)childComponent);
        } else {
            JPanel panel = new JPanel();
            panel.setLayout(new GridLayout(1, 1));
            panel.add(childComponent);
            frame1.setContentPane(panel);
        }
        frame1.pack();
        this.layoutFrame(frame1, child);
        this.getDesktop().add(frame1);
        boolean detached = false;
        Rectangle detachedBounds = null;
        ViewConstraints constr = child.getViewConstraints();
        if (constr != null) {
            detached = constr.isDetached();
            detachedBounds = constr.getDetachedBounds();
            if (detachedBounds != null) {
                frame1.setDetachedBounds(detachedBounds);
            }
            if (detached && this.detachViewInternal(frame1)) {
                return;
            }
        }
        frame1.setVisible(true);
        try {
            frame1.setSelected(true);
        }
        catch (PropertyVetoException e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    @Override
    protected void uninstallChildComponent(View child, Component childComponent) {
        JInternalFrame frame;
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("remove Desktop-View: " + child + " => " + childComponent);
        }
        if ((frame = this.getInternalFrame(child)) != null) {
            ViewFrame viewFrame;
            if (frame instanceof ViewFrame && (viewFrame = (ViewFrame)frame).isDetached()) {
                this.reattachViewInternal(viewFrame, false);
            }
            this.frameByChildView.remove(child);
            frame.dispose();
            frame.setContentPane(new JPanel());
        }
    }

    @Override
    public synchronized void addChild(View v) {
        super.addChild(v);
    }

    @Override
    public synchronized void removeChild(View v) {
        super.removeChild(v);
    }

    @Override
    public synchronized void removeChildAt(int i) {
        super.removeChildAt(i);
    }

    protected View getView(JInternalFrame frame) {
        if (frame == null) {
            return null;
        }
        if (frame instanceof ViewFrame) {
            return ((ViewFrame)frame).getView();
        }
        return null;
    }

    protected JInternalFrame getInternalFrame(View view) {
        return (JInternalFrame)this.frameByChildView.get(view);
    }

    protected void layoutFrame(JInternalFrame frame, View view) {
        Rectangle viewBounds = frame.getBounds();
        Rectangle deskBounds = this.getDesktop().getBounds();
        boolean centerFrame = true;
        boolean minimize = false;
        boolean maximize = false;
        ViewConstraints constr = view.getViewConstraints();
        if (constr != null) {
            Rectangle r = constr.getBounds();
            if (r != null) {
                centerFrame = false;
                viewBounds.x = r.x;
                viewBounds.y = r.y;
                viewBounds.width = r.width;
                viewBounds.height = r.height;
            }
            minimize = constr.isMinimized();
            maximize = constr.isMaximized();
        }
        if (centerFrame) {
            int my;
            int mx = deskBounds.width / 2 - viewBounds.width / 2;
            if (mx >= 0) {
                viewBounds.x = mx;
            }
            if ((my = deskBounds.height / 2 - viewBounds.height / 2) >= 0) {
                viewBounds.y = my;
            }
        }
        if (viewBounds.x < 0) {
            viewBounds.x = 0;
        }
        if (viewBounds.y < 0) {
            viewBounds.y = 0;
        }
        if (deskBounds.width > 0) {
            if (viewBounds.x + viewBounds.width > deskBounds.width) {
                viewBounds.x = deskBounds.width - viewBounds.width;
                if (viewBounds.x < 0) {
                    viewBounds.x = 0;
                    viewBounds.width = deskBounds.width;
                }
            }
            if (viewBounds.y + viewBounds.height > deskBounds.height) {
                viewBounds.y = deskBounds.height - viewBounds.height;
                if (viewBounds.y < 0) {
                    viewBounds.y = 0;
                    viewBounds.height = deskBounds.height;
                }
            }
        }
        frame.setBounds(viewBounds);
        if (frame.isMaximum() != maximize) {
            try {
                frame.setMaximum(maximize);
            }
            catch (PropertyVetoException e) {
                logger.log(Level.SEVERE, e.getMessage(), e);
            }
        }
        if (frame.isIcon() != minimize) {
            try {
                frame.setIcon(minimize);
            }
            catch (PropertyVetoException e) {
                logger.log(Level.SEVERE, e.getMessage(), e);
            }
        }
    }

    @Override
    public Perspective getPerspective() {
        return this.perspective;
    }

    protected void setPerspective(Perspective perspective) {
        this.perspective = perspective;
    }

    public boolean maximizeView(View view) {
        JInternalFrame frame;
        View vp;
        for (vp = view; vp != null && vp.getParent() != this; vp = vp.getParent()) {
        }
        if (vp != null && (frame = this.getInternalFrame(vp)) != null) {
            DetachedWindow detachedWindow;
            ViewFrame viewFrame;
            if (frame instanceof ViewFrame && (viewFrame = (ViewFrame)frame).isDetached() && (detachedWindow = viewFrame.getDetachedWindow()) != null) {
                detachedWindow.setExtendedState(6);
                return true;
            }
            if (!frame.isMaximum()) {
                try {
                    frame.setMaximum(true);
                    return true;
                }
                catch (PropertyVetoException e) {
                    return false;
                }
            }
        }
        return false;
    }

    public boolean minimizeView(View view) {
        JInternalFrame frame;
        View vp;
        for (vp = view; vp != null && vp.getParent() != this; vp = vp.getParent()) {
        }
        if (vp != null && (frame = this.getInternalFrame(vp)) != null) {
            DetachedWindow detachedWindow;
            ViewFrame viewFrame;
            if (frame instanceof ViewFrame && (viewFrame = (ViewFrame)frame).isDetached() && (detachedWindow = viewFrame.getDetachedWindow()) != null) {
                detachedWindow.setState(1);
                return true;
            }
            if (!frame.isIcon()) {
                try {
                    frame.setIcon(true);
                    return true;
                }
                catch (PropertyVetoException e) {
                    return false;
                }
            }
        }
        return false;
    }

    public boolean restoreView(View view) {
        JInternalFrame frame;
        View vp;
        for (vp = view; vp != null && vp.getParent() != this; vp = vp.getParent()) {
        }
        boolean ok = false;
        if (vp != null && (frame = this.getInternalFrame(vp)) != null) {
            ViewFrame viewFrame;
            if (frame instanceof ViewFrame && (viewFrame = (ViewFrame)frame).isDetached()) {
                ok = this.reattachViewInternal(viewFrame, true);
            }
            if (frame.isMaximum()) {
                try {
                    frame.setMaximum(false);
                    ok = true;
                }
                catch (PropertyVetoException e) {
                    // empty catch block
                }
            }
            if (frame.isIcon()) {
                try {
                    frame.setIcon(false);
                    ok = true;
                }
                catch (PropertyVetoException e) {
                    // empty catch block
                }
            }
        }
        return ok;
    }

    protected static Image getIconImage(Icon icon) {
        Image iconImage = null;
        if (icon != null && icon instanceof ImageIcon) {
            ImageIcon imageIcon = (ImageIcon)icon;
            iconImage = imageIcon.getImage();
        }
        return iconImage;
    }

    public boolean detachView(View view) {
        View vp;
        for (vp = view; vp != null && vp.getParent() != this; vp = vp.getParent()) {
        }
        if (vp == null) {
            return false;
        }
        JInternalFrame frame = this.getInternalFrame(vp);
        if (frame != null && frame.isShowing() && frame instanceof ViewFrame) {
            ViewFrame viewFrame = (ViewFrame)frame;
            return this.detachViewInternal(viewFrame);
        }
        return false;
    }

    protected boolean detachViewInternal(ViewFrame viewFrame) {
        FullscreenView fsv;
        FullscreenSupport fs;
        Container viewContent = viewFrame.getContentPane();
        if (viewContent == null) {
            return false;
        }
        boolean newWindow = false;
        Rectangle detachedBounds = null;
        DetachedWindow detachedWindow = viewFrame.getDetachedWindow();
        if (detachedWindow == null) {
            detachedWindow = new DetachedWindow(viewFrame);
            if (this.detachedWindowHandler == null) {
                this.detachedWindowHandler = new DetachedWindowHandler();
            }
            viewFrame.setDetachedWindow(detachedWindow);
            newWindow = true;
            detachedBounds = viewFrame.getDetachedBounds();
        }
        detachedWindow.addWindowListener(this.detachedWindowHandler);
        detachedWindow.addWindowFocusListener(this.detachedWindowHandler);
        detachedWindow.addWindowStateListener(this.detachedWindowHandler);
        View view = viewFrame.getView();
        if (view != null && view instanceof FullscreenView && (fs = (fsv = (FullscreenView)((Object)view)).getFullscreenSupport()) != null) {
            fs.setFrame((Frame)detachedWindow);
        }
        detachedWindow.setTitle(viewFrame.getTitle());
        Icon frameIcon = viewFrame.getFrameIcon();
        detachedWindow.setIconImage(DesktopView.getIconImage(frameIcon));
        if (newWindow) {
            if (detachedBounds == null) {
                Dimension viewSize = viewContent.getSize();
                Point viewLocation = viewContent.isShowing() ? viewContent.getLocationOnScreen() : viewContent.getLocation();
                Container oldContainer = detachedWindow.getContentPane();
                if (oldContainer != null && oldContainer instanceof JComponent) {
                    JComponent oldCont = (JComponent)oldContainer;
                    oldCont.setPreferredSize(viewSize);
                }
                detachedWindow.pack();
                Insets frameInsets = detachedWindow.getInsets();
                detachedWindow.setLocation(viewLocation.x - frameInsets.left, viewLocation.y - frameInsets.top);
            } else {
                detachedWindow.setBounds(detachedBounds);
            }
            this.ensureWindowOnScreen(detachedWindow);
        }
        viewFrame.setDetached(true);
        viewFrame.removeInternalFrameListener(this.internalFrameHandler);
        viewFrame.setVisible(false);
        detachedWindow.setContentPane(viewContent);
        final DetachedWindow detFrame = detachedWindow;
        if (detFrame.getState() == 1) {
            detFrame.setState(0);
        }
        detFrame.setVisible(true);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                detFrame.toFront();
                detFrame.requestFocus();
            }
        });
        return true;
    }

    public boolean reattachView(View view) {
        View vp;
        for (vp = view; vp != null && vp.getParent() != this; vp = vp.getParent()) {
        }
        if (vp == null) {
            return false;
        }
        JInternalFrame frame = this.getInternalFrame(vp);
        if (frame != null && frame instanceof ViewFrame) {
            ViewFrame viewFrame = (ViewFrame)frame;
            return this.reattachViewInternal(viewFrame, true);
        }
        return false;
    }

    protected boolean reattachViewInternal(ViewFrame viewFrame, boolean show) {
        DetachedWindow detachedWindow;
        if (viewFrame.isDetached() && (detachedWindow = viewFrame.getDetachedWindow()) != null) {
            FullscreenView fsv;
            FullscreenSupport fs;
            Container viewContent = detachedWindow.getContentPane();
            detachedWindow.setVisible(false);
            detachedWindow.removeWindowListener(this.detachedWindowHandler);
            detachedWindow.removeWindowFocusListener(this.detachedWindowHandler);
            detachedWindow.removeWindowStateListener(this.detachedWindowHandler);
            View view = viewFrame.getView();
            if (view != null && view instanceof FullscreenView && (fs = (fsv = (FullscreenView)((Object)view)).getFullscreenSupport()) != null) {
                fs.setFrame(null);
            }
            viewFrame.setContentPane(viewContent);
            viewFrame.addInternalFrameListener(this.internalFrameHandler);
            viewFrame.setDetached(false);
            if (show) {
                viewFrame.setVisible(true);
                viewFrame.toFront();
                viewFrame.requestFocus();
            }
            return true;
        }
        return false;
    }

    protected void ensureWindowOnScreen(Window window) {
        Rectangle windowBounds = window.getBounds();
        if (windowBounds == null) {
            return;
        }
        GraphicsEnvironment env = GraphicsEnvironment.getLocalGraphicsEnvironment();
        for (GraphicsDevice dev : env.getScreenDevices()) {
            GraphicsConfiguration[] configs;
            if (dev == null || (configs = dev.getConfigurations()) == null) continue;
            int configCount = configs.length;
            for (int k = 0; k < configCount; ++k) {
                Rectangle bounds;
                GraphicsConfiguration config = configs[k];
                if (config == null || (bounds = config.getBounds()) == null || !bounds.intersects(windowBounds)) continue;
                return;
            }
        }
        Tools.ensureWindowFitsScreen((Window)window);
    }

    public void toFront(View v) {
        if (v == null) {
            return;
        }
        try {
            DetachedWindow detachedWindow;
            ViewFrame viewFrame;
            JInternalFrame frame = this.getInternalFrame(v);
            if (frame == null) {
                return;
            }
            if (frame instanceof ViewFrame && (viewFrame = (ViewFrame)frame).isDetached() && (detachedWindow = viewFrame.getDetachedWindow()) != null && detachedWindow.isVisible()) {
                if (detachedWindow.getState() != 0) {
                    detachedWindow.setState(0);
                }
                detachedWindow.toFront();
                detachedWindow.requestFocus();
                return;
            }
            if (frame.isIcon()) {
                frame.setIcon(false);
            }
            frame.toFront();
            frame.setSelected(true);
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    public void toBack(View v) {
        if (v == null) {
            return;
        }
        try {
            JInternalFrame frame = this.getInternalFrame(v);
            if (frame == null) {
                return;
            }
            frame.toBack();
            frame.setSelected(false);
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    public Rectangle getViewBounds(View view) {
        JInternalFrame frame = (JInternalFrame)this.frameByChildView.get(view);
        if (frame == null) {
            return null;
        }
        return frame.getBounds();
    }

    public void setViewBounds(View view, Rectangle bounds) {
        JInternalFrame frame = (JInternalFrame)this.frameByChildView.get(view);
        if (frame == null) {
            return;
        }
        frame.setBounds(bounds);
    }

    public Rectangle getViewNormalBounds(View view) {
        JInternalFrame frame = (JInternalFrame)this.frameByChildView.get(view);
        if (frame == null) {
            return null;
        }
        return frame.getNormalBounds();
    }

    public boolean isViewMinimized(View view) {
        JInternalFrame frame = (JInternalFrame)this.frameByChildView.get(view);
        if (frame == null) {
            return false;
        }
        return frame.isIcon();
    }

    public boolean isViewMaximized(View view) {
        JInternalFrame frame = (JInternalFrame)this.frameByChildView.get(view);
        if (frame == null) {
            return false;
        }
        return frame.isMaximum();
    }

    public void setViewMinimized(View view, boolean minimized) throws PropertyVetoException {
        JInternalFrame frame = (JInternalFrame)this.frameByChildView.get(view);
        if (frame == null) {
            return;
        }
        if (frame.isIcon() == minimized) {
            return;
        }
        frame.setIcon(minimized);
    }

    public void setViewMaximized(View view, boolean maximized) throws PropertyVetoException {
        JInternalFrame frame = (JInternalFrame)this.frameByChildView.get(view);
        if (frame == null) {
            return;
        }
        frame.setMaximum(maximized);
    }

    public boolean isViewDetached(View view) {
        JInternalFrame frame = (JInternalFrame)this.frameByChildView.get(view);
        if (frame == null) {
            return false;
        }
        if (frame instanceof ViewFrame) {
            ViewFrame viewFrame = (ViewFrame)frame;
            return viewFrame.isDetached();
        }
        return false;
    }

    public Rectangle getViewDetachedBounds(View view) {
        JInternalFrame frame = (JInternalFrame)this.frameByChildView.get(view);
        if (frame == null) {
            return null;
        }
        if (frame instanceof ViewFrame) {
            ViewFrame viewFrame = (ViewFrame)frame;
            Rectangle detachedBounds = null;
            DetachedWindow detachedWindow = viewFrame.getDetachedWindow();
            if (detachedWindow != null) {
                detachedBounds = detachedWindow.getBounds();
            }
            if (detachedBounds == null && (detachedBounds = viewFrame.getDetachedBounds()) != null) {
                detachedBounds = new Rectangle(detachedBounds);
            }
            return detachedBounds;
        }
        return null;
    }

    public void setViewDetachedBounds(View view, Rectangle bounds) {
        JInternalFrame frame = (JInternalFrame)this.frameByChildView.get(view);
        if (frame == null) {
            return;
        }
        if (frame instanceof ViewFrame) {
            ViewFrame viewFrame = (ViewFrame)frame;
            viewFrame.setDetachedBounds(bounds);
        }
    }

    @Override
    public synchronized void close() {
        super.close();
    }

    protected DesktopManager createDesktopManager(JDesktopPane desktopPane) {
        int millis = 250;
        int delay = 1;
        AnimatedDesktopManager manager = new AnimatedDesktopManager(desktopPane, millis, delay);
        manager.setAnimated(this.windowAnimationEnabled);
        return manager;
    }

    public void showDesktopContextMenu(int x, int y) {
        ToolContext toolContext;
        DefaultPerspective def;
        ToolGroup group;
        Perspective pers = this.perspective;
        if (pers == null) {
            return;
        }
        JPopupMenu popup = null;
        if (pers instanceof DefaultPerspective && (group = (def = (DefaultPerspective)pers).getContextMenuGroup()) != null && (popup = (JPopupMenu)group.createInstance(toolContext = null, JPopupMenu.class)).getComponentCount() < 1) {
            popup = null;
        }
        if (popup != null) {
            popup.show(this.getDesktop(), x, y);
        }
    }

    public boolean isWindowAnimationEnabled() {
        return this.windowAnimationEnabled;
    }

    public void setWindowAnimationEnabled(boolean windowAnimationEnabled) {
        this.windowAnimationEnabled = windowAnimationEnabled;
        if (this.desktopManager != null && this.desktopManager instanceof AnimatedDesktopManager) {
            AnimatedDesktopManager ani = (AnimatedDesktopManager)this.desktopManager;
            ani.setAnimated(windowAnimationEnabled);
        }
    }

    public boolean isAutoHideDetachedViews() {
        return this.autoHideDetachedViews;
    }

    public void setAutoHideDetachedViews(boolean autoHideDetachedViews) {
        this.autoHideDetachedViews = autoHideDetachedViews;
    }

    public void workbenchActivated(WindowEvent ev) {
        this.autoHideCancelled = true;
        if (!this.showDetachedInProgress) {
            if (this.hiddenDetachedWindows.isEmpty()) {
                this.workbenchZOrder = this.nextZOrder++;
            } else {
                this.showDetachedViews();
            }
        }
    }

    public void workbenchDeactivated(WindowEvent ev) {
        if (this.autoHideDetachedViews) {
            this.autoHideCancelled = false;
            SwingUtilities.invokeLater(this.autoHideChecker);
        }
    }

    public void workbenchIconified(WindowEvent ev) {
        if (this.autoHideDetachedViews) {
            this.hideDetachedViews();
        }
    }

    public void workbenchDeiconified(WindowEvent ev) {
        this.workbenchActivated(ev);
    }

    protected void handleInternalFrameClosing(JInternalFrame frame) {
        if (frame == null) {
            return;
        }
        try {
            View view = this.getView(frame);
            if (view != null && !this.promptViewClosing(view)) {
                return;
            }
            frame.dispose();
        }
        catch (Exception ex) {
            this.handleException(ex);
        }
    }

    protected boolean promptViewClosing(View view) throws Exception {
        return view.promptClose();
    }

    protected void handleInternalFrameClosed(JInternalFrame frame) {
        View view = this.getView(frame);
        if (view != null) {
            view.close();
        }
    }

    protected void handleInternalFrameActivated(JInternalFrame frame) {
        Perspective pers;
        View view = this.getView(frame);
        if (view != null && (pers = this.perspective) != null) {
            pers.setSelectedView(view);
        }
    }

    protected void handleDetachedWindowActivated(DetachedWindow window) {
        this.autoHideCancelled = true;
        window.setZOrder(this.nextZOrder++);
        ViewFrame viewFrame = window.getViewFrame();
        if (viewFrame == null) {
            return;
        }
        View view = viewFrame.getView();
        if (view == null) {
            return;
        }
        Perspective pers = view.getPerspective();
        if (pers == null) {
            return;
        }
        pers.setSelectedView(view);
    }

    protected void handleDetachedWindowDeactivated(DetachedWindow window) {
        if (this.autoHideDetachedViews) {
            this.autoHideCancelled = false;
            SwingUtilities.invokeLater(this.autoHideChecker);
        }
    }

    protected void handleDetachedWindowIconified(DetachedWindow window) {
        FullscreenView fsv;
        FullscreenSupport fs;
        ViewFrame viewFrame = window.getViewFrame();
        if (viewFrame == null) {
            return;
        }
        View view = viewFrame.getView();
        if (view == null) {
            return;
        }
        if (view instanceof FullscreenView && (fs = (fsv = (FullscreenView)((Object)view)).getFullscreenSupport()) != null && fs.isWindowFullscreen()) {
            if (logger.isLoggable(Level.FINER)) {
                logger.finer("handleDetachedWindowIconified: ignored=" + window);
            }
            return;
        }
        this.reattachView(view);
    }

    protected void handleDetachedWindowDeiconified(DetachedWindow window) {
        this.handleDetachedWindowActivated(window);
    }

    protected void checkAutoHideDetachedViews() {
        if (this.autoHideCancelled) {
            return;
        }
        Window[] wins = null;
        try {
            wins = WorkbenchUtilities.getWorkbenchPlugin().lookupWindows();
        }
        catch (Throwable e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
        if (wins == null) {
            return;
        }
        for (Window win : wins) {
            if (win == null || !win.isVisible() || !win.isShowing() || win instanceof DetachedWindow || win instanceof WorkbenchContainer) continue;
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Unknown window: " + win);
            }
            return;
        }
        this.hideDetachedViews();
    }

    protected void hideDetachedViews() {
        for (JInternalFrame frame : this.frameByChildView.values()) {
            DetachedWindow detachedWindow;
            ViewFrame viewFrame;
            if (frame == null || !(frame instanceof ViewFrame) || !(viewFrame = (ViewFrame)frame).isDetached() || (detachedWindow = viewFrame.getDetachedWindow()) == null) continue;
            this.hiddenDetachedWindows.add(detachedWindow);
            detachedWindow.setVisible(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void showDetachedViews() {
        if (this.hiddenDetachedWindows.isEmpty()) {
            return;
        }
        try {
            this.showDetachedInProgress = true;
            boolean workbenchPending = true;
            for (DetachedWindow detachedWindow : this.hiddenDetachedWindows) {
                ViewFrame viewFrame;
                if (detachedWindow == null || (viewFrame = detachedWindow.getViewFrame()) == null || !viewFrame.isDetached()) continue;
                if (workbenchPending && detachedWindow.getZOrder() > this.workbenchZOrder) {
                    workbenchPending = false;
                    this.showWorkbench();
                }
                detachedWindow.setVisible(true);
            }
            if (workbenchPending) {
                this.showWorkbench();
            }
            this.hiddenDetachedWindows.clear();
        }
        finally {
            this.showDetachedInProgress = false;
        }
    }

    protected void showWorkbench() {
        Workbench wb = this.getWorkbench();
        if (wb != null) {
            wb.show();
        }
    }

    protected void handleDetachedWindowClosing(DetachedWindow window) {
        ViewFrame viewFrame = window.getViewFrame();
        if (viewFrame == null) {
            return;
        }
        View view = viewFrame.getView();
        if (view == null) {
            return;
        }
        try {
            if (!this.promptViewClosing(view)) {
                return;
            }
            window.dispose();
            view.close();
        }
        catch (Exception ex) {
            this.handleException(ex);
        }
    }

    protected class AutoHideChecker
    implements Runnable {
        protected AutoHideChecker() {
        }

        @Override
        public void run() {
            DesktopView.this.checkAutoHideDetachedViews();
        }
    }

    protected class DetachedWindowOrderComparator
    implements Comparator {
        protected DetachedWindowOrderComparator() {
        }

        public int compare(Object o1, Object o2) {
            if (o1 == o2) {
                return 0;
            }
            DetachedWindow w1 = (DetachedWindow)o1;
            DetachedWindow w2 = (DetachedWindow)o2;
            return w1.getZOrder() < w2.getZOrder() ? -1 : 1;
        }
    }

    protected class DetachedWindowHandler
    extends WindowAdapter {
        @Override
        public void windowClosing(WindowEvent e) {
            Window window = e.getWindow();
            if (window != null && window instanceof DetachedWindow) {
                DetachedWindow dw = (DetachedWindow)window;
                DesktopView.this.handleDetachedWindowClosing(dw);
            }
        }

        @Override
        public void windowActivated(WindowEvent e) {
            Window window = e.getWindow();
            if (window != null && window instanceof DetachedWindow) {
                DetachedWindow dw = (DetachedWindow)window;
                DesktopView.this.handleDetachedWindowActivated(dw);
            }
        }

        @Override
        public void windowDeactivated(WindowEvent e) {
            Window window = e.getWindow();
            if (window != null && window instanceof DetachedWindow) {
                DetachedWindow dw = (DetachedWindow)window;
                DesktopView.this.handleDetachedWindowDeactivated(dw);
            }
        }

        @Override
        public void windowIconified(WindowEvent e) {
            Window window = e.getWindow();
            if (window != null && window instanceof DetachedWindow) {
                DetachedWindow dw = (DetachedWindow)window;
                DesktopView.this.handleDetachedWindowIconified(dw);
            }
        }

        @Override
        public void windowDeiconified(WindowEvent e) {
            Window window = e.getWindow();
            if (window != null && window instanceof DetachedWindow) {
                DetachedWindow dw = (DetachedWindow)window;
                DesktopView.this.handleDetachedWindowDeiconified(dw);
            }
        }
    }

    protected class DetachedWindow
    extends JFrame
    implements WorkbenchContainer {
        private static final long serialVersionUID = 4017564375702246306L;
        private ViewFrame viewFrame;
        private long zOrder;

        public DetachedWindow(ViewFrame viewFrame) {
            this.viewFrame = viewFrame;
            this.setResizable(true);
            this.setDefaultCloseOperation(0);
        }

        @Override
        public Workbench getWorkbench() {
            ViewFrame vf = this.viewFrame;
            if (vf != null) {
                return vf.getWorkbench();
            }
            return null;
        }

        protected ViewFrame getViewFrame() {
            return this.viewFrame;
        }

        public long getZOrder() {
            return this.zOrder;
        }

        public void setZOrder(long zOrder) {
            this.zOrder = zOrder;
        }
    }

    protected class MouseHandler
    extends MouseAdapter {
        protected MouseHandler() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            super.mousePressed(e);
            if (e.isPopupTrigger()) {
                DesktopView.this.showDesktopContextMenu(e.getX(), e.getY());
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            super.mouseReleased(e);
            if (e.isPopupTrigger()) {
                DesktopView.this.showDesktopContextMenu(e.getX(), e.getY());
            }
        }
    }

    protected static class EditorContextImpl
    implements EditorContext {
        private View view;
        private ViewFrame frame;

        public EditorContextImpl(View view, ViewFrame frame) {
            this.view = view;
            this.frame = frame;
        }

        public void setTitle(String title) {
            if (title == null) {
                return;
            }
            if (this.view != null) {
                this.view.setTitle(title);
                if (this.frame != null) {
                    this.frame.setTitle(title);
                    DetachedWindow dw = this.frame.getDetachedWindow();
                    if (dw != null) {
                        dw.setTitle(title);
                    }
                }
            }
        }

        public void setIcon(Icon icon) {
            if (this.view != null) {
                this.view.setIcon(icon);
                if (this.frame != null) {
                    this.frame.setFrameIcon(icon);
                    DetachedWindow dw = this.frame.getDetachedWindow();
                    if (dw != null) {
                        dw.setIconImage(DesktopView.getIconImage(icon));
                    }
                }
            }
        }

        public void setTooltip(String tip) {
            if (this.view != null) {
                this.view.setTooltip(tip);
                if (this.frame != null) {
                    this.frame.setToolTipText(tip);
                }
            }
        }

        public void setDirty(boolean dirty) {
            if (this.view != null) {
                this.view.setDirty(dirty);
            }
        }

        public String toString() {
            return super.toString() + "[" + this.view + "]";
        }
    }

    protected class InternalFrameHandler
    extends InternalFrameAdapter {
        protected InternalFrameHandler() {
        }

        @Override
        public void internalFrameClosing(InternalFrameEvent e) {
            JInternalFrame frame = e.getInternalFrame();
            if (frame != null) {
                DesktopView.this.handleInternalFrameClosing(frame);
            }
        }

        @Override
        public void internalFrameClosed(InternalFrameEvent e) {
            JInternalFrame frame = e.getInternalFrame();
            if (frame != null) {
                DesktopView.this.handleInternalFrameClosed(frame);
            }
        }

        @Override
        public void internalFrameActivated(InternalFrameEvent e) {
            JInternalFrame frame = e.getInternalFrame();
            if (frame != null) {
                DesktopView.this.handleInternalFrameActivated(frame);
            }
        }
    }

    protected static class NullDropTargetHandler
    extends DropTargetAdapter {
        protected NullDropTargetHandler() {
        }

        @Override
        public void dragEnter(DropTargetDragEvent dtde) {
            dtde.rejectDrag();
        }

        @Override
        public void dragExit(DropTargetEvent dte) {
        }

        @Override
        public void dragOver(DropTargetDragEvent dtde) {
            dtde.rejectDrag();
        }

        @Override
        public void dropActionChanged(DropTargetDragEvent dtde) {
            dtde.rejectDrag();
        }

        @Override
        public void drop(DropTargetDropEvent dtde) {
            dtde.rejectDrop();
        }
    }

    protected static class ViewFrame
    extends JInternalFrame
    implements WorkbenchContainer {
        private static final long serialVersionUID = 5304289967965870724L;
        private View view;
        private Border border;
        private Border noBorder;
        private boolean detached;
        private Rectangle detachedBounds;
        private DetachedWindow detachedWindow;

        public ViewFrame(View view) {
            this.view = view;
            this.initViewFrame();
        }

        @Override
        public Workbench getWorkbench() {
            Perspective pers;
            View v = this.view;
            if (v != null && (pers = v.getPerspective()) != null) {
                return pers.getWorkbench();
            }
            return null;
        }

        protected View getView() {
            return this.view;
        }

        protected void initViewFrame() {
            this.border = this.getBorder();
            this.noBorder = new CompoundBorder();
            try {
                DropTarget target = new DropTarget();
                target.addDropTargetListener(new NullDropTargetHandler());
                this.setDropTarget(target);
            }
            catch (TooManyListenersException e) {
                e.printStackTrace();
            }
        }

        @Override
        public String toString() {
            return this.getClass().getName() + "@" + Integer.toHexString(System.identityHashCode(this)) + "[view=" + this.view + "]";
        }

        @Override
        public void dispose() {
            super.dispose();
            this.view = null;
        }

        @Override
        public void setMaximum(boolean b) throws PropertyVetoException {
            boolean wasMaximum = this.isMaximum();
            super.setMaximum(b);
            if (wasMaximum == b) {
                return;
            }
            if (b) {
                super.setBorder(this.noBorder);
            } else {
                super.setBorder(this.border);
            }
        }

        @Override
        public void setBorder(Border border) {
            super.setBorder(border);
            this.border = super.getBorder();
        }

        protected DetachedWindow getDetachedWindow() {
            return this.detachedWindow;
        }

        protected void setDetachedWindow(DetachedWindow detachedWindow) {
            this.detachedWindow = detachedWindow;
        }

        protected boolean isDetached() {
            return this.detached;
        }

        protected void setDetached(boolean detached) {
            this.detached = detached;
        }

        protected Rectangle getDetachedBounds() {
            return this.detachedBounds;
        }

        protected void setDetachedBounds(Rectangle detachedBounds) {
            this.detachedBounds = detachedBounds;
        }
    }
}

