/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.workbench;

import com.spacekiller.util.workbench.View;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.MenuBar;
import java.awt.Window;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JMenuBar;
import javax.swing.JPanel;

public class EmbeddedWindowView
extends View {
    private Window window;
    private JPanel panel;
    private ContainerHandler containerHandler = new ContainerHandler();
    private static final Logger logger = Logger.getLogger(EmbeddedWindowView.class.getName());

    public EmbeddedWindowView(Window win) {
        this.setWindow(win);
    }

    @Override
    protected Component createComponent() {
        return this.getPanel();
    }

    @Override
    protected void installChildComponent(View child, Component childComponent) {
    }

    @Override
    protected void uninstallChildComponent(View child, Component childComponent) {
    }

    public JPanel getPanel() {
        if (this.panel == null) {
            this.setPanel(this.createPanel());
        }
        return this.panel;
    }

    private void setPanel(JPanel panel) {
        this.panel = panel;
    }

    protected JPanel createPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new GridLayout(1, 1));
        return panel;
    }

    protected Window getWindow() {
        return this.window;
    }

    protected synchronized void setWindow(Window newwindow) {
        if (this.window == newwindow) {
            return;
        }
        if (this.window != null) {
            this.window.removeContainerListener(this.containerHandler);
        }
        this.window = newwindow;
        this.embed();
        if (this.window != null) {
            this.window.addContainerListener(this.containerHandler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void embed() {
        Frame frame;
        String title = null;
        Image iconImage = null;
        Component component = null;
        MenuBar menuBar = null;
        JMenuBar jmenuBar = null;
        Window win = this.window;
        if (win instanceof Frame) {
            frame = (Frame)win;
            title = frame.getTitle();
            iconImage = frame.getIconImage();
            Object object = frame.getTreeLock();
            synchronized (object) {
                int comps = frame.getComponentCount();
                if (comps == 1) {
                    component = frame.getComponent(0);
                } else if (comps > 1) {
                    JPanel panel = new JPanel();
                    component = panel;
                    panel.setLayout(frame.getLayout());
                    for (int j = 0; j < comps; ++j) {
                        Component comp = frame.getComponent(j);
                        panel.add(comp, j);
                    }
                }
            }
            menuBar = frame.getMenuBar();
        }
        if (win instanceof JFrame) {
            frame = (JFrame)win;
            title = frame.getTitle();
            iconImage = frame.getIconImage();
            component = ((JFrame)frame).getContentPane();
            jmenuBar = ((JFrame)frame).getJMenuBar();
        }
        if (component == null) {
            throw new RuntimeException("No window content component found: " + win);
        }
        if (win.isVisible()) {
            win.setVisible(false);
        }
        this.setTitle(title);
        if (iconImage != null) {
            this.setIcon(new ImageIcon(iconImage));
        }
        JPanel panel = this.getPanel();
        panel.removeAll();
        panel.setLayout(new BorderLayout());
        if (menuBar == null && jmenuBar != null) {
            panel.add((Component)jmenuBar, "North");
        }
        panel.add(component, "Center");
    }

    protected class ContainerHandler
    implements ContainerListener {
        protected ContainerHandler() {
        }

        @Override
        public void componentAdded(ContainerEvent e) {
            logger.fine("TODO componentAdded: " + e);
        }

        @Override
        public void componentRemoved(ContainerEvent e) {
            logger.fine("TODO componentRemoved: " + e);
        }
    }
}

