/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.workbench;

import com.spacekiller.util.Tools;
import com.spacekiller.util.swing.TransListCellRenderer;
import com.spacekiller.util.workspace.ProjectReference;
import com.spacekiller.util.workspace.ProjectSource;
import com.spacekiller.util.workspace.Workspace;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditor;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class ExportProjectDialog
extends JPanel {
    private static final long serialVersionUID = 1853260707225745319L;
    private JDialog dialog;
    private Workspace workspace;
    private boolean confirmed = false;
    private JScrollPane jScrollPane = null;
    private JList jListTarget = null;
    private JPanel jPanel = null;
    private JButton jButtonSave = null;
    private JButton jButton1 = null;
    private DefaultListModel projectSourceListModel;
    private PropertyEditor editor;
    private EditorListener editorListener = new EditorListener();
    private JPanel jPanelEditor = null;
    private ProjectSource projectSource;
    private ProjectReference projectReference;
    private static final Logger logger = Logger.getLogger(ExportProjectDialog.class.getName());

    public ExportProjectDialog() {
        this.initialize();
        this.initSaveDialog();
    }

    private void initialize() {
        GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
        JLabel jLabel = new JLabel();
        this.setLayout(new GridBagLayout());
        this.setSize(404, 284);
        gridBagConstraints1.gridx = 1;
        gridBagConstraints1.gridy = 0;
        gridBagConstraints1.anchor = 17;
        gridBagConstraints1.insets = new Insets(4, 4, 4, 4);
        jLabel.setText("Destination:");
        gridBagConstraints2.gridx = 1;
        gridBagConstraints2.gridy = 1;
        gridBagConstraints2.weightx = 1.0;
        gridBagConstraints2.weighty = 1.0;
        gridBagConstraints2.fill = 1;
        gridBagConstraints2.insets = new Insets(0, 4, 0, 4);
        gridBagConstraints3.gridx = 1;
        gridBagConstraints3.gridy = 3;
        gridBagConstraints3.anchor = 13;
        gridBagConstraints6.gridx = 1;
        gridBagConstraints6.gridy = 2;
        gridBagConstraints6.weightx = 1.0;
        gridBagConstraints6.weighty = 1.0;
        gridBagConstraints6.fill = 1;
        gridBagConstraints6.insets = new Insets(4, 4, 4, 4);
        this.add((Component)jLabel, gridBagConstraints1);
        this.add((Component)this.getJScrollPane(), gridBagConstraints2);
        this.add((Component)this.getJPanel(), gridBagConstraints3);
        this.add((Component)this.getJPanelEditor(), gridBagConstraints6);
    }

    public boolean showDialog() {
        if (this.workspace == null) {
            throw new NullPointerException("workspace");
        }
        this.refreshProjectSources();
        JDialog dlg = this.getDialog();
        this.setConfirmed(false);
        dlg.pack();
        Tools.centerWindow((Window)dlg);
        dlg.setModal(true);
        dlg.setVisible(true);
        return this.isConfirmed();
    }

    public boolean isConfirmed() {
        return this.confirmed;
    }

    private void setConfirmed(boolean confirmed) {
        this.confirmed = confirmed;
    }

    public JDialog getDialog() {
        if (this.dialog == null) {
            JFrame frame = new JFrame();
            try {
                frame.setIconImage(Tools.createImage((Component)frame, this.getClass(), (String)"/com/spacekiller/util/workbench/icons/export_wiz.gif"));
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, e.getMessage(), e);
            }
            this.dialog = new JDialog(frame);
            this.dialog.setTitle("Export Project(s)");
            this.dialog.setContentPane(this);
        }
        return this.dialog;
    }

    void setDialog(JDialog dialog) {
        this.dialog = dialog;
    }

    public Workspace getWorkspace() {
        return this.workspace;
    }

    public void setWorkspace(Workspace workspace) {
        this.workspace = workspace;
    }

    private JScrollPane getJScrollPane() {
        if (this.jScrollPane == null) {
            this.jScrollPane = new JScrollPane();
            this.jScrollPane.setViewportView(this.getJListTarget());
        }
        return this.jScrollPane;
    }

    private JList getJListTarget() {
        if (this.jListTarget == null) {
            this.jListTarget = new JList();
            this.jListTarget.setOpaque(false);
            this.jListTarget.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    ExportProjectDialog.this.refreshPropertyEditor();
                }
            });
        }
        return this.jListTarget;
    }

    private JPanel getJPanel() {
        if (this.jPanel == null) {
            GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
            GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
            this.jPanel = new JPanel();
            this.jPanel.setLayout(new GridBagLayout());
            gridBagConstraints4.insets = new Insets(4, 4, 4, 4);
            gridBagConstraints5.insets = new Insets(4, 0, 4, 4);
            this.jPanel.add((Component)this.getJButtonSave(), gridBagConstraints4);
            this.jPanel.add((Component)this.getJButton1(), gridBagConstraints5);
        }
        return this.jPanel;
    }

    private JButton getJButtonSave() {
        if (this.jButtonSave == null) {
            this.jButtonSave = new JButton();
            this.jButtonSave.setText("Export");
            this.jButtonSave.setMargin(new Insets(2, 4, 2, 4));
            this.jButtonSave.setIcon(new ImageIcon(this.getClass().getResource("/com/spacekiller/util/workbench/icons/export_wiz.gif")));
            this.jButtonSave.setEnabled(false);
            this.jButtonSave.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ExportProjectDialog.this.setConfirmed(true);
                    ExportProjectDialog.this.dialog.dispose();
                }
            });
        }
        return this.jButtonSave;
    }

    private JButton getJButton1() {
        if (this.jButton1 == null) {
            this.jButton1 = new JButton();
            this.jButton1.setText("Cancel");
            this.jButton1.setMargin(new Insets(2, 4, 2, 4));
            this.jButton1.setIcon(new ImageIcon(this.getClass().getResource("/com/spacekiller/util/workbench/icons/cancel.gif")));
            this.jButton1.setFont(new Font("Dialog", 0, 12));
            this.jButton1.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ExportProjectDialog.this.setConfirmed(false);
                    ExportProjectDialog.this.dialog.dispose();
                }
            });
        }
        return this.jButton1;
    }

    protected DefaultListModel getProjectSourceListModel() {
        return this.projectSourceListModel;
    }

    void setProjectSourceListModel(DefaultListModel projectSourceListModel) {
        this.projectSourceListModel = projectSourceListModel;
    }

    protected void refreshProjectSources() {
        this.projectSourceListModel.removeAllElements();
        int num = this.workspace.getProjectSourceCount();
        for (int c = 0; c < num; ++c) {
            ProjectSource source = this.workspace.getProjectSourceAt(c);
            this.projectSourceListModel.addElement(source);
        }
        if (num > 0) {
            this.getJListTarget().setSelectedIndex(0);
        }
    }

    private void initSaveDialog() {
        this.projectSourceListModel = new DefaultListModel();
        this.getJListTarget().setCellRenderer(new ProjectSourceListCellRenderer());
        this.getJListTarget().setModel(this.projectSourceListModel);
    }

    protected void refreshPropertyEditor() {
        int i = this.getJListTarget().getSelectedIndex();
        this.getJPanelEditor().removeAll();
        if (this.editor != null) {
            this.editor.removePropertyChangeListener(this.editorListener);
        }
        if (i >= 0) {
            try {
                Component comp;
                ProjectSource source = (ProjectSource)this.projectSourceListModel.get(i);
                this.editor = source.createSaveProjectPropertyEditor();
                if (this.editor != null && this.editor.supportsCustomEditor() && (comp = this.editor.getCustomEditor()) != null) {
                    this.editor.addPropertyChangeListener(this.editorListener);
                    this.getJPanelEditor().add(comp);
                    comp.requestFocus();
                }
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, e.getMessage(), e);
            }
        }
        this.getJPanelEditor().validate();
        this.getJPanelEditor().repaint();
        this.checkEnable();
    }

    private JPanel getJPanelEditor() {
        if (this.jPanelEditor == null) {
            GridLayout gridLayout7 = new GridLayout();
            this.jPanelEditor = new JPanel();
            this.jPanelEditor.setLayout(gridLayout7);
            this.jPanelEditor.setBorder(BorderFactory.createEtchedBorder(0));
            gridLayout7.setRows(1);
        }
        return this.jPanelEditor;
    }

    protected void checkEnable() {
        int i = this.getJListTarget().getSelectedIndex();
        boolean enabled = false;
        ProjectSource source = null;
        ProjectReference ref = null;
        if (i >= 0 && this.editor != null) {
            source = (ProjectSource)this.projectSourceListModel.get(i);
            Object value = this.editor.getValue();
            if (value != null && value instanceof ProjectReference) {
                ref = (ProjectReference)value;
                enabled = source.supportsSaveProject(ref);
            }
        }
        if (!enabled) {
            source = null;
            ref = null;
        }
        this.setProjectSource(source);
        this.setProjectReference(ref);
        this.getJButtonSave().setEnabled(enabled);
    }

    public ProjectReference getProjectReference() {
        return this.projectReference;
    }

    protected void setProjectReference(ProjectReference projectReference) {
        this.projectReference = projectReference;
    }

    public ProjectSource getProjectSource() {
        return this.projectSource;
    }

    protected void setProjectSource(ProjectSource projectSource) {
        this.projectSource = projectSource;
    }

    private class EditorListener
    implements PropertyChangeListener {
        private EditorListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            ExportProjectDialog.this.checkEnable();
        }
    }

    public static class ProjectSourceListCellRenderer
    extends TransListCellRenderer {
        private static final long serialVersionUID = -5749782815499076508L;

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Object o = value;
            Component rc = super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
            if (o != null && o instanceof ProjectSource) {
                ProjectSource source = (ProjectSource)o;
                this.setText("" + source.getName());
                this.setIcon(source.getIcon());
                this.setToolTipText(source.getTooltip());
            }
            return rc;
        }
    }
}

